/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)fe_recursive.cc	1.30% %92/06/10% Sun Microsystems"

/*
 * ast_recursive.cc - Check whether a type is used recursively in a situation
 *		      where this use would be illegal.
 *
 * EXPLANATION: The CORBAS says that the only legal use of recursive types is
 * in a manifest sequence declared inside a struct or union whose base type is
 * the struct or union
 *
 * ALGORITH FOR CHECK:
 * Sequences push a NULL on the scope stack to mark where in the scope nesting
 * they appear.
 *
 * - If the type is not a struct or union, return FALSE (legal use of type)
 * - Otherwise check up the scope stack, looking for this base type. If we
 *   find a NULL return FALSE (legal use of type, since it is inside some
 *   sequence). If we find the type on the stack, return TRUE (illegal use
 *   since it was not bracketed by a sequence). If we don't find the base
 *   type nor a sequence, return FALSE (legal use, since we're not nested).
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * FE_illegal_recursive_type() - Implement the algorithm described above
 */
boolean
AST_illegal_recursive_type(AST_Decl *t)
{
  UTL_ScopeStackActiveIterator *i;
  UTL_Scope		       *s;
  AST_Structure		       *st1, *st2;
  AST_Union		       *un1, *un2;
  boolean		       check_for_struct = FALSE,
			       check_for_union = FALSE;

  /*
   * We only care about structs and unions
   */
  if (t->node_type() != AST_Decl::NT_struct &&
      t->node_type() != AST_Decl::NT_union)
    return FALSE;	// NOT ILLEGAL
  /*
   * Narrow the type appropriately so comparison will work
   */
  if (t->node_type() == AST_Decl::NT_struct) {
    check_for_struct = TRUE;
    st1 = AST_Structure::narrow_from_decl(t);
    if (st1 == NULL)
      return FALSE;	// NOT ILLEGAL
  } else if (t->node_type() == AST_Decl::NT_union) {
    check_for_union = TRUE;
    un1 = AST_Union::narrow_from_decl(t);
    if (un1 == NULL)
      return FALSE;	// NOT ILLEGAL
  }
  /*
   * OK, iterate up the stack
   */
  i = new UTL_ScopeStackActiveIterator(idl_global->scopes());
  while (!(i->is_done())) {
    s = i->item();
    /*
     * If we hit a NULL we're done since it means that we're nested inside
     * a sequence, where recursive types may be used
     */
    if (s == NULL) {
      delete i;
      return FALSE;	// NOT ILLEGAL
    }
    /*
     * OK, must check this scope
     */
    if (s->scope_node_type() == AST_Decl::NT_struct && check_for_struct) {
      st2 = AST_Structure::narrow_from_scope(s);
      if (st2 != NULL && st2 == st1) {
	delete i;
        return TRUE;	// ILLEGAL RECURSIVE TYPE USE
      }
    } else if (s->scope_node_type() == AST_Decl::NT_union &&
	       check_for_union) {
      un2 = AST_Union::narrow_from_scope(s);
      if (un2 != NULL && un2 == un1) {
        delete i;
	return TRUE;	// ILLEGAL RECURSIVE TYPE USE
      }
    }
    /*
     * This one is fine, get next item
     */
    i->next();
  }
  /*
   * No more scopes to check. This type was used legally
   */
  delete i;
  return FALSE;		// NOT ILLEGAL
}

