/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_union_label.cc	1.30% %92/06/11% Sun Microsystems"

/*
 * ast_union_label.cc - Implementation of class AST_UnionLabel
 *
 * AST_UnionLabel denotes the label of a branch in an IDL union
 * declaration.
 * AST_UnionLabel nodes have a label kind (the values come from the
 * enum AST_UnionLabel::LabelKind) and a label value (which is a
 * subclass of AST_Expression).
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s)
 */
AST_UnionLabel::AST_UnionLabel()
	      : pd_label_kind(UL_default),
		pd_label_val(NULL)
{
}

AST_UnionLabel::AST_UnionLabel(UnionLabel lk, AST_Expression *lv)
	       : pd_label_kind(lk),
		 pd_label_val(lv)
{
    if (lv != NULL)
      lv->evaluate(AST_Expression::EK_const);
}

/*
 * Private operations
 */

/*
 * Public operations
 */

/*
 * Redefinition of inherited virtual operations
 */

/*
 * Data accessors
 */

AST_UnionLabel::UnionLabel
AST_UnionLabel::label_kind()
{
  return pd_label_kind;
}

AST_Expression *
AST_UnionLabel::label_val()
{
  return pd_label_val;
}

/*
 * Dump this AST_UnionLabel node to the ostream o
 */
void
AST_UnionLabel::dump(ostream &o)
{
  if (pd_label_kind == UL_default)
    o << "default";
  else
    pd_label_val->dump(o);
}
