/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)drv_args.cc	1.16% %92/06/10% Sun Microsystems"

// drv_args.c - Argument parsing for IDL compiler main driver

#include	<idl.hh>
#include	<idl_extern.hh>

#include	<drv_private.hh>

#include	<stdio.h>

/*
 * Push a file into the list of files to be processed
 */
static void
DRV_push_file(char *s)
{
  DRV_files[DRV_nfiles++] = s;
}

/*
 * Prepare a CPP argument
 */
static void
DRV_prep_cpp_arg(char *s)
{
  char *newarg = new char[512];  
  char *farg;

  newarg[0] = '\0';
  for (farg = strtok(s, ","); farg != NULL; farg = strtok(NULL, ","))
    strcat(newarg,farg);
  DRV_cpp_putarg(newarg);
}

/*
 * Print a usage message and exit
 */
void
DRV_usage()
{
  cerr << idl_global->prog_name()
       << GTDEVEL(": usage: ")
       << idl_global->prog_name()
       << GTDEVEL(" [flag | file]*\n");
  cerr << GTDEVEL("Legal flags:\n");
  cerr << GTDEVEL(" -A...\t\t\tlocal implementation-specific escape\n");
  cerr << GTDEVEL(" -Dname[=value]\t\tdefines name for preprocessor\n");
  cerr << GTDEVEL(" -E\t\t\truns preprocessor only, prints on stdout\n");
  cerr << GTDEVEL(" -Idir\t\t\tincludes dir in search path for preprocessor\n");
  cerr << GTDEVEL(" -Uname\t\t\tundefines name for preprocessor\n");
  cerr << GTDEVEL(" -V\t\t\tprints version info then exits\n");
  cerr << GTDEVEL(" -W[p|b],arg1,argn\tpasses args to preprocessor or BE\n");
  cerr << GTDEVEL(" -Yp,path\t\tdefines location of preprocessor\n");
  cerr << GTDEVEL(" -bback_end\t\tcauses specified back end to be used\n");
  cerr << GTDEVEL(" -u\t\t\tprints usage message and exits\n");
  cerr << GTDEVEL(" -v\t\t\ttraces compilation stages\n");
  cerr << GTDEVEL(" -w\t\t\tsuppresses IDL compiler warning messages\n");
}

/*
 * Parse arguments on command line
 */
void
DRV_parse_args(long ac, char **av)
{
  char	*buffer;
  char	*s;
  long	i;

  DRV_cpp_init();
  idl_global->set_prog_name(av[0]);
  for (i = 1; i < ac; i++) {
    if (av[i][0] == '-') {
      switch (av[i][1]) {
      case 0:
	DRV_push_file("standard input");
	break;
      case 'A':
	if (av[i][2] == '\0') {
	  if (i < ac - 1) {
	    i++;
	    s = av[i];
	  } else
	    exit(99);
	} else
	  s = av[i] + 2;
	strcat(idl_global->local_escapes(), s);
	strcat(idl_global->local_escapes(), " ");
	break;
      case 'D':
      case 'U':
      case 'I':
	if (av[i][2] == '\0') {
	  if (i < ac - 1) {
	    buffer = new char[strlen(av[i]) + strlen(av[i + 1]) + 2];
	    sprintf(buffer, "%s%s", av[i], av[i+1]);
	    DRV_cpp_putarg(buffer);
	    i++;
	  } else {
	    cerr << GTDEVEL("IDL: missing argument after '")
		 << av[i] 
		 << GTDEVEL("' flag\n");
	    exit(99);
	  }
	} else
	  DRV_cpp_putarg(av[i]);
	break;
      case 'E':
	idl_global->set_compile_flags(idl_global->compile_flags() |
				      IDL_CF_ONLY_PREPROC);
	break;
      case 'V':
	idl_global->set_compile_flags(idl_global->compile_flags() |
				      IDL_CF_VERSION);
	break;
      case 'W':
	if (av[i][2] == '\0') {
	  if (i < ac - 1) {
	    i++;
	    s = av[i];
	  } else {
	    cerr << GTDEVEL("IDL: missing argument after '")
		 << av[i]
		 << GTDEVEL("' flag\n");
	    exit(99);
	  }
        } else
	  s = av[i] + 2;
	switch (*s) {
	default:
	    cerr << GTDEVEL("IDL: -W must be followed by 'p' or 'b'\n");
	    exit(99);
	case 'p':
	  if (*(s + 1) == ',')
	    DRV_prep_cpp_arg(s + 2);
	  break;
	case 'b':
	  if (*(s + 1) == ',')
	    BE_prep_arg(s + 2, TRUE);
	  break;
	}
	break;
      case 'Y':
	if (av[i][2] == '\0') {
	  if (i < ac - 1) {
	    i++;
	    s = av[i];
	  } else {
	    cerr << GTDEVEL("IDL: missing argument after '")
		 << av[i]
		 << GTDEVEL("' flag\n");
	    exit(99);
	  }
        } else
	  s = av[i] + 2;
	switch (*s) {
	case 'p':
	  if (*(s + 1) == ',') {
	    idl_global->set_cpp_location(s + 2);
	    DRV_cpp_new_location(s + 2);
	  }
	  break;
	default:
	  break;
	}
	break;
      case 'b':
	if (av[i][2] == '\0') {
	  if (i < ac - 1) {
	    i++;
	    s = av[i];
	  } else {
	    cerr << GTDEVEL("IDL: missing argument after '")
		 << av[i]
		 << GTDEVEL("' flag\n");
	    exit(99);
	  }
	} else
	  s = av[i] + 2;
	idl_global->set_be(s);
	break;
      case 'd':
	idl_global->set_compile_flags(idl_global->compile_flags() |
				      IDL_CF_DUMP_AST);
	break;
      case 'u':
	idl_global->set_compile_flags(idl_global->compile_flags() |
				      IDL_CF_ONLY_USAGE);
	break;
      case 'v':
	idl_global->set_compile_flags(idl_global->compile_flags() |
				      IDL_CF_INFORMATIVE);
	break;
      case 'w':
	idl_global->set_compile_flags(idl_global->compile_flags() |
				      IDL_CF_NOWARNINGS);
	break;
      default:
	cerr << GTDEVEL("IDL: Illegal option '") << av[i] << "'\n";
	idl_global->set_compile_flags(idl_global->compile_flags() |
				      IDL_CF_ONLY_USAGE);
	break;
      }
    } else
      DRV_push_file(av[i]);
  }
}
