/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)drv_fork.cc	1.7% %92/06/10% Sun Microsystems"

/*
 * DRV_fork.cc - Fork a process for each file to be processed, wait for
 *		 status from the child process
 */

#include	<idl.hh>
#include	<idl_extern.hh>

#include	<drv_private.hh>

#include	<unistd.h>		// POSIX standard types
#include	<sys/wait.h>		// POSIX definition of wait()

/*
 * Fork off a process, wait for it to die
 */
void
DRV_fork()
{
  pid_t child_pid;
  pid_t wait_pid;
#if defined(__wait)
  union __wait wait_status;
#else
  int wait_status;
#endif

  /*
   * The parent loops over all files to be processed, forking off a child
   * for each one. When they terminate, the exit status is checked. If not
   * zero, the parent does not process any more files.
   */
  for (DRV_file_index = 0; DRV_file_index < DRV_nfiles; DRV_file_index++) {
    if ((child_pid = fork()) != 0) {
      if (child_pid == -1) {
	cerr << GTDEVEL("IDL: fork failed\n");
	exit(99);
      }

      while ((wait_pid = wait(&wait_status)) != child_pid);
      if (WEXITSTATUS(wait_status) != 0)
	exit(WEXITSTATUS(wait_status));
    } else {
      /*
       * OK, do it to this file (in the child)
       */
      DRV_drive(DRV_files[DRV_file_index]);
      exit(0);
    }
  }
  /*
   * Now the parent process can exit
   */
  exit(0);
}
