/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)drv_preproc.cc	1.16% %92/06/10% Sun Microsystems"

/*
 * DRV_pre_proc.cc - pass an IDL file through the C preprocessor
 */

#include	<idl.hh>
#include	<idl_extern.hh>

#include	<drv_private.hh>

#include	<stdio.h>
#include	<unistd.h>		// POSIX standard types
#include	<sys/wait.h>		// POSIX definition of wait()

#undef	MAX_ARGLIST
#define	MAX_ARGLIST	128

extern	FILE	*yyin;

static	char	*arglist[MAX_ARGLIST];
static	long	argcount = 0;

/*
 * Push the new CPP location if we got a -Yp argument
 */
void
DRV_cpp_new_location(char *new_loc)
{
  arglist[0] = new_loc;
}

/*
 * Push an argument into the arglist
 */
void
DRV_cpp_putarg(char *str)
{
  if (argcount >= MAX_ARGLIST) {
    cerr << idl_global->prog_name()
         << GTDEVEL(": More than ")
	 << MAX_ARGLIST
	 << GTDEVEL(" arguments to preprocessor\n");
    exit (99);
  }
  arglist[argcount++] = str;
}

/*
 * Initialize the cpp argument list
 */
void
DRV_cpp_init()
{
  DRV_cpp_putarg(idl_global->cpp_location());
  DRV_cpp_putarg("-B");
  DRV_cpp_putarg("-DIDL");
  DRV_cpp_putarg("-I.");
}

/*
 * lines can be 1024 chars long
 */
#define	LINEBUF_SIZE	1024
static	char	drv_line[LINEBUF_SIZE + 1];

/*
 * Get a line from stdin
 */
static long
DRV_get_line(FILE *f)
{
    char	*l = fgets(drv_line, LINEBUF_SIZE, f);
    long	i;

    if (l == NULL)
	return FALSE;
    if (*l == '\0' && feof(f))
	return FALSE;
    if (*l == '\0')
	return TRUE;
    i = strlen(l) - 1;
    if (l[i] == '\n')
	l[i] = '\0';
    return TRUE;
}

/*
 * Copy from stdin to a file
 */
static void
DRV_copy_input(char *fn)
{
  FILE	*f = fopen(fn, "w");

  if (f == NULL) {
    cerr << idl_global->prog_name()
	 << GTDEVEL(": cannot open temp file ")
	 << fn
	 << GTDEVEL(" for writing\n");
    exit(99);
  }
  while (DRV_get_line(stdin))
    fprintf(f, "%s\n", drv_line);
  fclose(f);
}

/*
 * File names
 */
static char	tmp_file[128];
static char	tmp_ifile[128];

/*
 * Pass input through preprocessor
 */
char *
DRV_pre_proc(char *myfile)
{
#if defined(__wait)
  union __wait wait_status;
#else
  int wait_status;
#endif
  long	readfromstdin = FALSE;
  pid_t	child_pid;
  char	catbuf[512];
  
  strcpy(tmp_file, "/tmp/idl.cpp.XXXXXX");
  strcpy(tmp_ifile, "/tmp/idl.cpp.i.XXXXXX");

  if (strcmp(myfile, "standard input") == 0) {
    (void) mktemp(tmp_ifile);
    myfile = tmp_ifile;
    DRV_copy_input(tmp_ifile);
    idl_global->set_read_from_stdin(TRUE);
  }      
  (void) mktemp(tmp_file);
  switch (child_pid = fork()) {
  case 0:	/* Child - call cpp */
    DRV_cpp_putarg(myfile);
    DRV_cpp_putarg(tmp_file);
    execv(arglist[0], arglist);
    cerr << GTDEVEL("IDL: execv of ")
	 << arglist[0]
	 << GTDEVEL("failed\n");
    exit(99);
  case -1:
    cerr << GTDEVEL("IDL: fork failed\n");
    exit(99);
  default:	/* Parent - wait */
    while (child_pid != wait(&wait_status));
    if (WEXITSTATUS(wait_status) != 0) {
      cerr << idl_global->prog_name()
	   << GTDEVEL(": Preprocessor returned non-zero status ")
	   << "\n";
      if (idl_global->read_from_stdin()) unlink(tmp_ifile);
      unlink(tmp_file);
      exit(WEXITSTATUS(wait_status));
    }
  }
  yyin = fopen(tmp_file, "r");
  if (yyin == NULL) {
    cerr << idl_global->prog_name()
	 << GTDEVEL(": Could not open cpp output file ")
	 << tmp_file
	 << "\n";
    exit(99);
  }
  if (idl_global->read_from_stdin() && unlink(tmp_ifile) != 0) {
    cerr << idl_global->prog_name()
	 << GTDEVEL(": Could not remove cpp input file ")
	 << tmp_ifile
	 << "\n";
    exit(99);
  }
  if (idl_global->compile_flags() & IDL_CF_ONLY_PREPROC) {
    sprintf(catbuf, "cat < %s", tmp_file);
    system(catbuf);
  }
  if (unlink(tmp_file) != 0) {
    cerr << idl_global->prog_name()
	 << GTDEVEL(": Could not remove cpp output file ")
	 << tmp_file
	 << "\n";
    exit(99);
  }
  if (idl_global->compile_flags() & IDL_CF_ONLY_PREPROC)
    exit(0);
  return myfile;
}
