/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)fe_init.cc	1.21% %92/06/10% Sun Microsystems"

/*
 * fe_init.cc - Initialize the FE
 *
 * The FE initialization is carried out in two stages, with the BE
 * initialization protocol sandwiched between the two stages.
 *
 * The first stage is responsible for creating the scopes stack.
 * The second stage is run after the BE initialization has created
 * and returned an instance of AST_Generator (or a subclass). This
 * instance is used to create the root node for the AST, and to
 * populate it with AST_PredefinedType nodes which represent the
 * predefined IDL types. This AST root is then pushed on the scopes
 * stack as the outermost scope.
 */

#include	<idl.hh>
#include	<idl_extern.hh>

#include	<fe_private.hh>

/*
 * Create a scoped name
 */
static UTL_ScopedName *
create_scoped_name(char *s)
{
  return new UTL_StrList(new String(s), NULL);
}

/*
 * Populate the global scope with all predefined entities
 */
static void
fe_populate(AST_Module *m)
{
  AST_PredefinedType *pdt;

  pdt = idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_long,
					          create_scoped_name("long"),
						  NULL);
  m->add_predefined_type(pdt);

  pdt =
    idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_ulong,
					   create_scoped_name("unsigned long"),
					   NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_short,
						  create_scoped_name("short"),
						  NULL);
  m->add_predefined_type(pdt);
  pdt =
   idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_ushort,
					  create_scoped_name("unsigned short"),
					  NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_float,
						  create_scoped_name("float"),
					       	  NULL);
  m->add_predefined_type(pdt);
  pdt =
    idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_double,
					      create_scoped_name("double"),
					      NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_char,
						  create_scoped_name("char"),
						  NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_octet,
						  create_scoped_name("octet"),
						  NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_any,
						  create_scoped_name("any"),
						  NULL);
  m->add_predefined_type(pdt);
  pdt =
    idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_boolean,
					      create_scoped_name("boolean"),
					      NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()->create_predefined_type(AST_PredefinedType::PT_void,
						  create_scoped_name("void"),
						  NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("Object"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("TypeCode"),
					 NULL);
  m->add_predefined_type(pdt);

  /*
   * Add these to make all keywords protected even in different spellings
   */

  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("attribute"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("case"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("const"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("context"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("default"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("enum"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("exception"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("in"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("out"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("inout"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("interface"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("module"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("oneway"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("raises"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("readonly"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("sequence"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("string"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("struct"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("switch"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("typedef"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("union"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("unsigned"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("TRUE"),
					 NULL);
  m->add_predefined_type(pdt);
  pdt = idl_global->gen()
  		->create_predefined_type(AST_PredefinedType::PT_pseudo,
					 create_scoped_name("FALSE"),
					 NULL);
  m->add_predefined_type(pdt);
}

/*
 * Initialization stage 1: create global scopes stack
 */
void
FE_init_stage1()
{
  idl_global->set_scopes(new UTL_ScopeStack());
  if (idl_global->scopes() == NULL) {
    cerr << GTDEVEL("IDL: FE init failed to create scope stack, exiting\n");
    exit(99);
  }
}

/*
 * Initialization stage 2: create global scope and populate it
 */
void
FE_init_stage2()
{
  AST_Root	*r;

  /*
   * Check that the BE init created a generator object
   */
  if (idl_global->gen() == NULL) {
    cerr << GTDEVEL("IDL: BE did not initialize idl_global->gen(), exiting\n");
    exit(99);
  }
  /*
   * Create a global root for the AST. Note that the AST root has no
   * name
   */
  r = idl_global->gen()->create_root(new UTL_ScopedName(new String(""),
							NULL),
				     NULL);
  idl_global->set_root(r);
  if (r == NULL) {
    cerr << GTDEVEL("IDL: FE init failed to create AST root, exiting\n");
    exit(99);
  }
  /*
   * Push it on the stack
   */
  idl_global->scopes()->push(idl_global->root());
  /*
   * Populate it with nodes for predefined types
   */
  fe_populate(idl_global->root());
  /*
   * Set flag to indicate we are processing the main file now
   */
  idl_global->set_in_main_file(TRUE);
}
