/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: iocode.c,v 1.18 1994/02/09 19:41:24 janssen Exp $
*/

#include "m3.h"

/*===================================================================
=====================================================================

              IO for non-object types

=====================================================================
=====================================================================*/

/*********************************************************************
**********************************************************************

     Output code

**********************************************************************
**********************************************************************/

static unsigned long DimCount;
static unsigned long DimStop = 0;

static void DimHeader (long int d, Context context)
{
  if (DimStop > 0 AND DimCount >= DimStop)
    return;

  fprintf (context->file, "%*.*sFOR i%u := 0 TO %u DO\n",
	   (int) DimCount * 2 + 4, (int) DimCount * 2 + 4, "", (int) DimCount, d - 1);
  DimCount += 1;
}

static void DimRef (long int d, char *buf)
{
  if (DimStop > 0 AND DimCount >= DimStop)
    return;

  sprintf (buf + strlen(buf), "[i%u]", DimCount);
  DimCount += 1;
}

static void DimFooter (long int d, Context context)
{
  DimCount -= 1;
  if (DimStop > 0 AND DimCount < DimStop)
    return;
  fprintf (context->file, "%*.*sEND (*for*);\n", (int) DimCount * 2 + 2, (int) DimCount * 2 + 2, "");
}

struct double_s {
  Context c;
  Type t;
  unsigned int id;
};

static void OutputRecordArg (Argument arg, Context context)
{
  char buf[1000];

  sprintf (buf, "val.%s", m3_argument_name(arg));
  MarshallValue (arg->type, buf, context, 6);
}

static void OutputUnionType (Argument a, struct double_s *s)
{
  Type type = a->type;

  fprintf (s->c->file, "    | %s (x) =>\n", UnionTypeName(s->t, a->type));
  fprintf (s->c->file, "        IluRuntime.OutputUnion(call_, %s__Code);\n",
	   UnionTypeName(s->t, a->type));
  MarshallValue (type, "x.v", s->c, 8);
}

static void FindZero (long unsigned int val, boolean *z)
{
  if (val == 0)
    *z = TRUE;
}

static void generate_output_code (Type type, enum PrimitiveTypes t, Context context)
{
  TypeDescription d = type_description(type);
  boolean zeroarray = FALSE;
  int dims = 0;

  if (t == array_Type)
    {
      dims = list_size(d->structuredDes.array.dimensions);
      zeroarray = FALSE;
      list_enumerate(d->structuredDes.array.dimensions, (EnumProc) FindZero, &zeroarray);
    }

  fprintf (context->file, "PROCEDURE Marshall_%s (call_ : IluRuntime.Call; %sREADONLY val : %s)\n",
	   M3_SHORT_TYPE_NAME(type), zeroarray ? "<*UNUSED*> " : "", M3_TYPE_NAME(type));
  fprintf (context->file, "  RAISES {IluBasics.Failed, Thread.Alerted} =\n");

  if (t == array_Type)
    {
      char buf[1000];

      fprintf (context->file, "  BEGIN\n    IluRuntime.OutputArray(call_);\n");
      if (NOT zeroarray)
	{
	  enum PrimitiveTypes t2 = type_basic_type(d->structuredDes.array.type);
	  if (t2 == byte_Type OR t2 == shortcharacter_Type)
	    {
	      DimStop = dims - 1;
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimHeader, context);
	      sprintf (buf, "val");
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimRef, buf);
	      fprintf (context->file, "%*.*sIluRuntime.Output%s (call_, %s);\n", dims * 2 + 2, dims*2+2, "",
		       (t2 == byte_Type) ? "Opaque" : "StringVec", buf);
	      DimCount = dims;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimFooter, context);
	      DimStop = 0;
	    }
	  else
	    {
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimHeader, context);
	      sprintf (buf, "val");
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimRef, buf);
	      fprintf (context->file, "%*.*s", dims * 2 + 2, dims*2+2, "");
	      MarshallValue (d->structuredDes.array.type, buf, context, dims*2+2);
	      DimCount = dims;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimFooter, context);
	    }
	}
      fprintf (context->file, "    IluRuntime.EndArray(call_);\n");
    }
  else if (t == sequence_Type)
    {
      fprintf (context->file, "  VAR len := NUMBER(val^);\n  BEGIN\n");
      fprintf (context->file, "    IluRuntime.OutputSequence(call_, len, %u);\n",
	       d->structuredDes.sequence.limit);
      fprintf (context->file, "    FOR i := 0 TO len - 1 DO\n");
      MarshallValue (d->structuredDes.sequence.type, "val[i]", context, 6);
      fprintf (context->file, "    END (*for*);\n    IluRuntime.EndSequence(call_);\n");
    }
  else if (t == union_Type)
    {
      struct double_s s;

      s.c = context;
      s.t = type;
      fprintf (context->file, "  BEGIN\n    TYPECASE val OF\n");
      list_enumerate (d->structuredDes.uniond.types, (EnumProc) OutputUnionType, &s);
      fprintf (context->file, "    ELSE\n      RAISE\n");
      fprintf (context->file, "        IluBasics.Failed(NEW(IluBasics.Failure, info := \"can't marshall unexpected case of %s\"))\n",
	       M3_TYPE_NAME(type));
      fprintf (context->file, "    END (*typecase*);\n");
      fprintf (context->file, "    IluRuntime.EndUnion(call_);\n");
    }
  else if (t == record_Type)
    {
      fprintf (context->file, "  BEGIN\n    IluRuntime.OutputRecord(call_);\n");
      list_enumerate (d->structuredDes.record, (EnumProc) OutputRecordArg, context);
      fprintf (context->file, "    IluRuntime.EndRecord(call_);\n");
    }
  else if (t == object_Type)
    {}	/* done elsewhere */
  else
    {}

  fprintf (context->file, "  END Marshall_%s;\n\n", M3_SHORT_TYPE_NAME(type));
}

/**********************************************************************
***********************************************************************
*
*     Input code
*
***********************************************************************
***********************************************************************/


static void InputRecordField (Argument arg, Context context)
{
  char buf[1000];

  sprintf (buf, "val.%s", m3_argument_name(arg));
  UnmarshallValue (context, arg->type, 0, buf, 6, TRUE);
}

static void InputUnionType (Argument a, struct double_s *s)
{
  if (IsBulkyData(a->type))
    {
      fprintf (s->c->file, "    | %s__Code =>\n", UnionTypeName(s->t, a->type));
      fprintf (s->c->file, "        VAR v_ : %s;\n", M3_TYPE_NAME(a->type));
      fprintf (s->c->file, "        BEGIN\n");
      UnmarshallValue (s->c, a->type, 0, "v_", 10, TRUE);
      fprintf (s->c->file, "          val := NEW(%s, v := v_);\n", UnionTypeName(s->t, a->type));
      fprintf (s->c->file, "        END\n");
    }
  else
    {
      fprintf (s->c->file, "    | %s__Code => val := NEW(%s, ",
	       UnionTypeName(s->t, a->type), UnionTypeName(s->t, a->type));
      UnmarshallValue (s->c, a->type, 0, "v", 0, FALSE);
      fprintf (s->c->file, ")\n");
    }
}

static void generate_input_code (Type type, enum PrimitiveTypes t, Context context)
{
  char *name = M3_SHORT_TYPE_NAME(type);
  char *tname = M3_TYPE_NAME(type);
  TypeDescription d = type_description(type);
  boolean zeroarray = FALSE;
  int dims = 0;

  if (t == array_Type)
    {
      dims = list_size(d->structuredDes.array.dimensions);
      zeroarray = FALSE;
      list_enumerate(d->structuredDes.array.dimensions, (EnumProc) FindZero, &zeroarray);
    }

  context->class = type;

  if (IsBulkyData(type))
    fprintf (context->file, "PROCEDURE Unmarshall_%s (call_ : IluRuntime.Call; %sVAR val : %s)\n",
	     name, zeroarray ? "<*UNUSED*> " : "", tname);
  else
    fprintf (context->file, "PROCEDURE Unmarshall_%s (call_ : IluRuntime.Call) : %s\n",
	     name, tname);
  fprintf (context->file, "  RAISES {IluBasics.Failed, Thread.Alerted} =\n");
  if (!IsBulkyData(type))
    fprintf (context->file, "  VAR val: %s;\n", tname);

  if (t == array_Type)
    {
      char buf[1000];

      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    IluRuntime.InputArray(call_);\n");
      if (NOT zeroarray)
	{
	  enum PrimitiveTypes t2 = type_basic_type(d->structuredDes.array.type);
	  if (t2 == byte_Type OR t2 == shortcharacter_Type)
	    {
	      DimStop = dims - 1;
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimHeader, context);
	      sprintf (buf, "val");
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimRef, buf);
	      fprintf (context->file, "%*.*sIluRuntime.Input%s (call_, %s);\n", dims * 2 + 2, dims*2+2, "",
		       (t2 == byte_Type) ? "Opaque" : "StringVec", buf);
	      DimCount = dims;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimFooter, context);
	      DimStop = 0;
	    }
	  else
	    {
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimHeader, context);
	      sprintf (buf, "val");
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimRef, buf);
	      UnmarshallValue (context, d->structuredDes.array.type, 0, buf, dims*2+2, TRUE);
	      DimCount = dims;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimFooter, context);
	    }
	}
      fprintf (context->file, "    IluRuntime.EndArray(call_);\n");
    }
  else if (t == sequence_Type)
    {
      Type et = d->structuredDes.sequence.type;

      fprintf (context->file, "  VAR len : IluRuntime.Cardinal;\n  BEGIN\n");
      fprintf (context->file, "    len := IluRuntime.InputSequence (call_, %u);\n",
	       d->structuredDes.sequence.limit);
      fprintf (context->file, "    val := NEW(%s, len);\n", tname);
      fprintf (context->file, "    FOR i := 0 TO len - 1 DO\n");
      UnmarshallValue (context, et, type->def, "val[i]", 6, TRUE);
      fprintf (context->file, "    END (* for *);\n");
      fprintf (context->file, "    IluRuntime.EndSequence(call_);\n");
    }
  else if (t == union_Type)
    {
      struct double_s s;

      s.c = context;
      s.t = type;
      s.id = 0;
      fprintf (context->file, "  VAR disc := IluRuntime.InputUnion(call_);\n");
      fprintf (context->file, "  BEGIN\n    CASE disc OF\n");
      list_enumerate (d->structuredDes.uniond.types, (EnumProc) InputUnionType, &s);
      fprintf (context->file, "    ELSE\n      RAISE\n        IluBasics.Failed(NEW(IluBasics.Failure, ");
      fprintf (context->file, "info := Fmt.F(\"got %%s as tag for a %s\", Fmt.Int(disc))))\n", tname);
      fprintf (context->file, "    END (*case*);\n    IluRuntime.EndUnion(call_);\n");
    }
  else if (t == record_Type)
    {
      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    IluRuntime.InputRecord (call_);\n");
      list_enumerate (d->structuredDes.record, (EnumProc) InputRecordField, context);
      fprintf (context->file, "    IluRuntime.EndRecord(call_);\n");
    }
  else if (t == optional_Type)
    {
      enum PrimitiveTypes t2 = type_basic_type(d->structuredDes.optional);
      boolean pointer = (t2 == object_Type OR t2 == sequence_Type OR t2 == union_Type);

      fprintf (context->file, "  VAR test : BOOLEAN;\n");
      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    test := IluRuntime.InputOptional(call_);\n");
      fprintf (context->file, "    IF test THEN\n");
      if (!pointer)
	fprintf (context->file, "      val := NEW(%s);\n", tname);
      UnmarshallValue (context, d->structuredDes.optional, d->structuredDes.optional->def,
		       pointer ? "val" : "val^", 6, TRUE);
      fprintf (context->file, "    ELSE\n");
      fprintf (context->file, "      val := NIL;\n");
      fprintf (context->file, "    END (*if*);\n");
    }
  else if (t == enumeration_Type)
    {
      fprintf (context->file, "  VAR code : IluRuntime.EnumOrd;  found : BOOLEAN := FALSE;\n");
      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    code := IluRuntime.InputEnum(call_);\n");
      fprintf (context->file, "    FOR i := 0 TO %u DO\n", list_size(d->structuredDes.enumeration) - 1);
      fprintf (context->file, "      IF %s__EnumValues[i] = code THEN\n", name);
      fprintf (context->file, "        val := VAL(i, %s);\n        found := TRUE;\n        EXIT;\n", tname);
      fprintf (context->file, "      END (* if *);\n");
      fprintf (context->file, "    END (* for *);\n");
      fprintf (context->file, "    IF NOT found THEN\n      RAISE\n");
      fprintf (context->file, "        IluBasics.Failed(NEW(IluBasics.Failure, info := Fmt.F(\"got %%s as code for an enumeration type %s\", Fmt.Int(code))))\n", tname);
      fprintf (context->file, "    END;\n");
    }
  else if (t == object_Type)
    {}	/* done elsewhere */
  else
    {}

  if (!IsBulkyData(type))
    fprintf (context->file, "    RETURN val;\n");
  fprintf (context->file, "  END Unmarshall_%s;\n\n", name);
}

/**********************************************************************
***********************************************************************
*
*     Sizeof code
*
***********************************************************************
***********************************************************************/

static void SizeOfUnion (Argument a, struct double_s *s)
{
  fprintf (s->c->file, "    | %s (x) => size := IluRuntime.SizeUnion(call_, %s__Code) + ",
	   UnionTypeName(s->t, a->type), UnionTypeName(s->t, a->type));
  SizeValue (a->type, "x.v", s->c);
  fprintf (s->c->file, ";\n");
}

static void SizeRecordArg (Argument arg, Context context)
{
  char buf[1000];
  fprintf (context->file, "    INC(size, ");
  sprintf (buf, "val.%s", m3_argument_name(arg));
  SizeValue (arg->type, buf, context);
  fprintf (context->file, ");\n");
}

static void generate_sizeof_code (Type type, enum PrimitiveTypes t, Context context)
{
  TypeDescription d = type_description(type);
  char *name = M3_SHORT_TYPE_NAME(type);
  char *tname = M3_TYPE_NAME(type);
  boolean zeroarray = FALSE;
  int dims = 0;

  if (t == array_Type)
    {
      dims = list_size(d->structuredDes.array.dimensions);
      zeroarray = FALSE;
      list_enumerate(d->structuredDes.array.dimensions, (EnumProc) FindZero, &zeroarray);
    }

  context->class = type;

  fprintf (context->file, "PROCEDURE ComputeMarshalledSize_%s (call_: IluRuntime.Call; %sREADONLY val: %s): IluRuntime.Cardinal\n",
	   name, zeroarray ? "<*UNUSED*> " : "", tname);
  fprintf (context->file, "  RAISES {IluBasics.Failed} =\n  VAR size: IluRuntime.Cardinal;\n");
  if (t == array_Type)
    {
      char buf[1000];

      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    size := IluRuntime.SizeArray(call_);\n");
      if (NOT zeroarray)
	{
	  enum PrimitiveTypes t2 = type_basic_type(d->structuredDes.array.type);
	  if (t2 == byte_Type OR t2 == shortcharacter_Type)
	    {
	      DimStop = dims - 1;
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimHeader, context);
	      sprintf (buf, "val");
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimRef, buf);
	      fprintf (context->file, "%*.*sINC(size, IluRuntime.Size%s (call_, %s));\n", dims * 2 + 2, dims*2+2, "",
		       (t2 == byte_Type) ? "Opaque" : "StringVec", buf);
	      DimCount = dims;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimFooter, context);
	      DimStop = 0;
	    }
	  else
	    {
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimHeader, context);
	      sprintf (buf, "val");
	      DimCount = 0;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimRef, buf);
	      fprintf (context->file, "%*.*sINC(size, ", dims * 2 + 4, dims*2+4, "");
	      SizeValue (d->structuredDes.array.type, buf, context);
	      fprintf (context->file, ");\n");
	      DimCount = dims;
	      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) DimFooter, context);
	    }
	}
      fprintf (context->file, "    IluRuntime.EndArray(call_);\n");
    }
  else if (t == sequence_Type)
    {
      fprintf (context->file, "  VAR len := NUMBER(val^);\n");
      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    size := IluRuntime.SizeSequence(call_, len, %u);\n",
	       d->structuredDes.sequence.limit);
      fprintf (context->file, "    FOR i := 0 TO len - 1 DO\n");
      fprintf (context->file, "      INC(size, ");
      SizeValue (d->structuredDes.sequence.type, "val[i]", context);
      fprintf (context->file, ");\n");
      fprintf (context->file, "    END (*for*);\n");
      fprintf (context->file, "    IluRuntime.EndSequence(call_);\n");
    }
  else if (t == union_Type)
    {
      struct double_s s;

      s.c = context;
      s.t = type;
      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    TYPECASE val OF\n");
      list_enumerate (d->structuredDes.uniond.types, (EnumProc) SizeOfUnion, &s);
      fprintf (context->file, "    ELSE\n");
      fprintf (context->file, "      RAISE IluBasics.Failed(NEW(IluBasics.Failure, info := \"can't size unexpected case of %s\"))\n", tname);
      fprintf (context->file, "    END (*typecase*);\n");
      fprintf (context->file, "    IluRuntime.EndUnion(call_);\n");
    }
  else if (t == record_Type)
    {
      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    size := IluRuntime.SizeRecord (call_);\n");
      list_enumerate (d->structuredDes.record, (EnumProc) SizeRecordArg, context);
      fprintf (context->file, "    IluRuntime.EndRecord(call_);\n");
    }
  else if (t == optional_Type)
    {
      enum PrimitiveTypes t2 = type_basic_type(d->structuredDes.optional);
      char *s = (t2 == object_Type OR t2 == sequence_Type OR t2 == union_Type) ? "val" : "val^";

      fprintf (context->file, "  BEGIN\n");
      fprintf (context->file, "    size := IluRuntime.SizeOptional (call_, (val # NIL));\n");
      fprintf (context->file, "    IF val # NIL THEN\n      size := size + ");
      SizeValue (d->structuredDes.optional, s, context);
      fprintf (context->file, ";\n    END;\n");
    }
  else if (t == object_Type)
    {}	/* done elsewhere */
  else
    {}

  fprintf (context->file, "    RETURN size;\n  END ComputeMarshalledSize_%s;\n\n", name);
}

static int UnionCount;

static void list_union_code (Argument arg, Context context)
{
  fprintf (context->file, "CONST %s__Code = %u;\n",
	   UnionTypeName(context->class, arg->type), UnionCount);
  UnionCount++;
}

void generate_type_io_code (Type type, Context context)
{
  enum PrimitiveTypes t = type_basic_type(type);

  if ((TypeIsNonObjectStruct(type)
       OR (TypeIsArray(type)
	   AND ((list_size(type_description(type)->structuredDes.array.dimensions) > 1)
		OR ((type_basic_type(type_description(type)->structuredDes.array.type) != byte_Type)
		    AND (type_basic_type(type_description(type)->structuredDes.array.type) != shortcharacter_Type))))
       OR (t == sequence_Type
	   AND (type_basic_type(type_description(type)->structuredDes.sequence.type) != byte_Type)
	   AND (type_basic_type(type_description(type)->structuredDes.sequence.type) != shortcharacter_Type)))
      AND (t != object_Type)
      AND (type->importInterfaceName == NULL))
    {
      if (t == union_Type)
	{
	  context->class = type;
	  UnionCount = 0;
	  list_enumerate(type_description(type)->structuredDes.uniond.types, (EnumProc) list_union_code, context);
	  fprintf (context->file, "\n");
	}

      generate_output_code (type, t, context);
      generate_input_code (type, t, context);
      generate_sizeof_code (type, t, context);
    }
  if (t == optional_Type
      AND (type->importInterfaceName == NULL))
    {
      generate_input_code (type, t, context);
      generate_sizeof_code (type, t, context);
    }
  if (t == enumeration_Type
      AND (type->importInterfaceName == NULL))
    {
      generate_input_code (type, t, context);
    }
}
