/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: m3.h,v 1.9 1994/02/15 02:27:44 janssen Exp $
*/

#include <stdio.h>
#include <string.h>

#define TRUE  1
#define FALSE 0
typedef int Boolean;

#define AND  &&
#define OR   ||
#define NOT  !

#include <iluptype.h>

#define SEGFAULT	*((char *)1)='a'

typedef void (*EnumProc)(void *, void *);
typedef boolean (*FindProc)(void *, void *);

enum Module { GeneralInterface, InternalInterface, InternalModule, ClientModule, ServerModule };

typedef struct context_s {
  Interface interface;
  FILE *file;
  Type class;
  enum Module module;
} * Context;

Class class_object();
TypeDescription type_description();
enum PrimitiveTypes type_basic_type(Type);
void ImportInterface(Imported i, Context context);
Type exception_type();
string type_name(Type);
string m3_return_type();
string m3_type_name(Type t, boolean full);
string m3_simple_name();
string m3_string(string s);
string m3_interface_name(Interface i);
string interface_name(Interface);
string type_name(Type);     
list new_list();
boolean IsSequenceObject(Type type, Interface i);
boolean IsPipeObject(Type type, Interface i);
boolean TypeIsStruct();
boolean TypeIsArray(Type type);
boolean TypeIsString(Type type);
boolean TypeIsNonObjectStruct(Type type);
void SizeValue (Type type, string name, Context context);
void MarshallValue (Type type, string name, Context context, int indent);
void UnmarshallValue (Context context, Type type, LineNumber line, string name, int indent, boolean terminate);
boolean BlockingCall (Procedure proc);

void generate_headers (Interface interface, FILE *file);
void generate_support_headers (Interface i, FILE *file);
void generate_support_code (Interface i, FILE *file);
void generate_client_code (Interface i, FILE *file);
void generate_server_code (Interface parse, FILE *file);
string iname(string name, Interface interface);
string m3_constant_name (Constant c, boolean full);
string m3_argument_name (Argument a);
char * UnionTypeName (Type union_type, Type field_type);
string m3_exception_name (Exception e, boolean full);
void generate_boilerplate (FILE *file, Interface parse);
string m3_procedure_name (Procedure p, boolean full);
boolean IsBulkyData (Type type);
void UnmarkSupertypes(Type);
Type ultimateType (Type);

#define M3_TYPE_NAME(type)		m3_type_name(type, TRUE)
#define M3_SHORT_TYPE_NAME(type)	m3_type_name(type, FALSE)
#define M3_EXCEPTION_NAME(exception)		m3_exception_name(exception, TRUE)
#define M3_SHORT_EXCEPTION_NAME(exception)	m3_exception_name(exception, FALSE)
#define M3_CONSTANT_NAME(constant)		m3_constant_name(constant, TRUE)
#define M3_SHORT_CONSTANT_NAME(constant)	m3_constant_name(constant, FALSE)
#define M3_METHOD_NAME(method)		m3_procedure_name(method, TRUE)
#define M3_SHORT_METHOD_NAME(method)	m3_procedure_name(method, FALSE)

