/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: iluptype.h,v 1.30 1994/04/07 23:56:44 janssen Exp $
*/

typedef int boolean;
#define TRUE 1
#define FALSE 0

typedef unsigned long cardinal;

typedef char * string;
typedef unsigned char * bytes;
typedef unsigned char byte;
typedef char character;
typedef void *refany;

typedef struct list_element_s {
  refany data;
  struct list_element_s *next;
} listElement;

typedef struct list_s {
  listElement *head;
  listElement *tail;
  cardinal count;
} *list;

typedef list set;

typedef void (*void_procedure)();

typedef boolean (*boolean_procedure)();

typedef struct usagename_s {
  char *lang;
  char *name;
} * usagename;

typedef struct name_s {
  char *base_name;
  set	langnames;	/* set of usagename pairs */
} * Name;

typedef enum {In, Out, InOut} ArgDirection;

/***********************************************************************
  Types needed by ILU parser

***********************************************************************/

typedef struct ilu_interface_s	*	Interface;
typedef struct ilu_type_s	*	Type;
typedef struct ilu_proc_s	*	Procedure;
typedef struct ilu_argument_s	*	Argument;
typedef struct ilu_exception_s	*	Exception;
typedef struct ilu_typedes_s	*	TypeDescription;
typedef struct ilu_imported_s	*	Imported;
typedef int				ProtocolId;
typedef struct enumerationField_s *	EnumField;
typedef cardinal			LineNumber;
typedef struct ilu_constant_s	*	Constant;
typedef struct ilu_constantvalue_s *	ConstantValue;
typedef struct ilu_class_s	*	Class;

enum PrimitiveTypes {
  invalid_Type, void_Type,
  byte_Type, boolean_Type,
  character_Type, shortcharacter_Type,
  shortinteger_Type, integer_Type, longinteger_Type,
  shortcardinal_Type, cardinal_Type, longcardinal_Type,
  real_Type, shortreal_Type, longreal_Type,
  object_Type, pipe_Type, optional_Type,
  union_Type, sequence_Type, record_Type, array_Type, enumeration_Type };

struct ilu_imported_s {
  string		name;
  string		filename;
};

struct enumerationField_s {
  string		name;
  int			id;
};

struct ilu_interface_s {
  Name			name;
  string		brand;
  set			types;		/* set of Type */
  set			classes;	/* set of Type */
  set			exceptions;	/* set of Exception */
  set			imports;	/* set of Imported */
  set			constants;	/* set of Constants */
  LineNumber		def;
  string		filename;	/* file in which interface is defined (if any) */
};

struct ilu_type_s {
  Name			name;
  TypeDescription	description;
  Type			supertype;
  set			refs;			/* set of LineNumber */
  LineNumber		def;
  boolean		builtIn;
  string		importInterfaceName;	/* if imported, name of interface */
  Interface		interface;
  TypeDescription	cached_des;		/* cache for type_basic_type() */
  boolean		marked;			/* mark for recursive type search */
  string		uid;
};

struct ilu_proc_s {
  Name			name;
  list			arguments;	/* list of Argument */
  boolean		returnOptional;	/* may be NULL */
  Type			returnType;
  set			exceptions;	/* set of Exception */
  LineNumber		def;
  ProtocolId		id;
  Type			object;		/* for use with methods */
  Interface		interface;
  boolean		functional;
  boolean		asynch;
  boolean		marked;		/* for use with recursive sweep */
  char *		doc_string;
};

struct ilu_argument_s {
  Name			name;
  Type			type;
  ArgDirection		direction;
  boolean		sibling;
  list			values;		/* used only for Unions */
  LineNumber		def;
};

struct ilu_exception_s {
  Name			name;
  Type			type;
  boolean		valueOptional;	/* T if value may be NULL */
  LineNumber		def;
  set			refs;		/* set of LineNumber */
  boolean		builtIn;
  ProtocolId		id;
  string		importInterfaceName;	/* if imported, name of interface */
  Exception		import;			/* imported exception */
  Interface		interface;
  boolean		marked;
  char *		doc_string;
};

struct ilu_constant_s {
  Name			name;
  LineNumber		def;
  Interface		interface;
  Type			type;
  string		importInterfaceName;
  Constant		import;
  ConstantValue		value;
};

struct ilu_constantvalue_s {
  enum PrimitiveTypes type;
  union {
    boolean b;
    struct {
      int sign;
      unsigned long value;
    } i;
    struct {
      int sign;
      string value;
      string fraction;
      long exponent;
    } r;
    string s;
  } val;
};

struct ilu_class_s {
  list		superclasses;
  string	brand;
  boolean	singleton;
  boolean	collectible;
  string	authentication;
  list		methods;	/* list of Procedure */
  char *	doc_string;
};

struct ilu_typedes_s {
  enum PrimitiveTypes type;
  union
    {
      struct {
	Type type;
	boolean optional;
	cardinal limit;
      } sequence;

      struct {
	Type type;
	boolean sink_p;
	boolean optional;
      } pipe;

      struct {
	Type type;
	list dimensions;	/* list of dimensions */
	boolean optional;
	} array;

      list record;		/* list of Argument */

      list enumeration;		/* list of EnumField */

      struct {
	Type discriminator_type;
	list types;		/* list of Argument */
      } uniond;

      Class object;

      Type optional;		/* non-optional type of the optional type */

    } structuredDes;
};

/* various exported functionality */
extern list ParseFile (string filename);	/* list of Interface found in file */
extern Interface GetInterface (string interfacename, string filename);
extern char *CanonicalPathname (char *file);
extern char *iluparser_GetProgramName (char *short_name);

/* memory management */
extern void *Malloc(unsigned long size);
extern void Free(void *ptr);
extern void *Realloc (void *ptr, unsigned long size);
extern char * ilu_strdup (char *);
extern int ilu_strcasecmp (char *s1, char *s2);	/* -n if s1 < s2, 0 if s1 == s2, n if s1 > s2 */

/* list primitives */
typedef void (*iluparser_EnumProc) (refany element, refany rock);
typedef boolean (*iluparser_FindProc) (refany element, refany rock);
cardinal list_size (list l);
refany list_ref (list l, cardinal index);
list list_cdr (list l);
refany list_car (list l);
void list_insert (list, refany new_element);
boolean list_remove (list, refany element);
void list_clear (list, boolean freeElements);
void list_enumerate (list, iluparser_EnumProc proc, refany rock);
refany list_find (list, iluparser_FindProc proc, refany rock);
list iluparser_new_list(void);
#define new_list iluparser_new_list

/* type primitives */
TypeDescription 	type_description (Type);
enum PrimitiveTypes 	type_basic_type (Type);
string 			type_name (Type);
Interface		type_interface (Type);
void			type_recurse (Type, void (*proc)(Type, refany rock), refany rock);

/* name primitives */
void name_set_lang_name (Name n, string lang, string name);
string name_lang_name (Name n, string lang);
string name_base_name (Name n);

/* accessors for various kinds of names */
string exception_name(Exception e);
string interface_name(Interface i);
string argument_name (Argument a);
string procedure_name (Procedure);
