INTERFACE PageHandle;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.4 $
    $Date: 1999/07/25 19:36:51 $
    $Log: PageHandle.i3,v $
    Revision 1.4  1999/07/25 19:36:51  hosking
    Changed accessPage to simply load page if not loaded.

    Revision 1.3  1999/05/27 02:15:24  hosking
    Revised signature for accessPage to indicate if access changed it.

    Revision 1.2  1999/04/28 15:12:33  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:43  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/02/29 17:40:02  rbnix
    	New methods getAll and copyData added.

    Revision 1.1  1996/01/31 10:04:51  rbnix
    	Initial version for subsystem PageCache.

*)
(***************************************************************************)

(*
 * --- PageHandle ---------------------------------------------------------
 * This abstract data type specializes a BasePageHandle as a swapable page
 * relating it to a storage position and media.
 *
 * This type represents not only an isolated entry but also it's relation
 * to the PageCache. Therefore swapping is made mostly transparent.
 * ------------------------------------------------------------------------
 *)

IMPORT BasePageHandle AS Super;
IMPORT
  Page,
  BasePageMedia;

<* PRAGMA SPEC *>

CONST
  Brand			="PageHandle";		(* for generic modules	*)

TYPE
  T                     <: Public;

  Public		= Super.T OBJECT
    METHODS
      setMedia		(        media		:BasePageMedia.T);
      getMedia		() :BasePageMedia.T;

      setPageNo		(        pageNo		:CARDINAL);
      getPageNo		() :CARDINAL;

      loadData          ();
      dropData		();

      accessPage	(): Page.T;

    (*
    OVERRIDES
      (* BasePageHandle *)
      putData		:= PutData;
      getData		:= GetData;
      getAll		:= GetAll;
      copyData		:= CopyData;
      (*
        Access to page data MUST be done within following specification,
        see PageCache for further details:
      *)
      <* SPEC REQUIRES cacheUser = CURRENT *>
    *)
    END;
  

END PageHandle.
