INTERFACE ChgMgmtOpenGraphs;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:53:54 $
    $Log: ChgMgmtOpenGraphs.i3,v $
    Revision 1.1.1.1  1998/12/03 18:53:54  hosking
    Import of GRAS3-1.1

    Revision 1.1  1998/05/19 10:30:00  roland
    Support for log-groups implemented.

*)
(***************************************************************************)

IMPORT PersistentGraph, Pathname;

TYPE
  T <: Public;

  Public =
    OBJECT
    METHODS
      init(): T;
      createEntry (number : CARDINAL;
                   graph  : PersistentGraph.T;
                   vname  : Pathname.T;
                   wname  : Pathname.T;
                   counter: CARDINAL           );
      free           (graph: CARDINAL);
      exists         (graph: CARDINAL): BOOLEAN;
      putLogHandle   (graph: CARDINAL; log: CARDINAL);
      putOpenCounter (graph: CARDINAL; count: CARDINAL);
      getLogHandle   (graph: CARDINAL): CARDINAL;
      getVisibleName (graph: CARDINAL): Pathname.T;
      getGraph       (graph: CARDINAL): PersistentGraph.T RAISES {NotOpen};
      getWorkingName (graph: CARDINAL): Pathname.T;
      getOpenCounter (graph: CARDINAL): CARDINAL;
    END;

EXCEPTION NotOpen;
  
END ChgMgmtOpenGraphs.
