(*!  DATA TYPE MODULE *)
INTERFACE GraphEventHandler;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:12:43 $
    $Log: GraphEventHandler.i3,v $
    Revision 1.2  1999/04/28 15:12:43  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:08  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/11/12 15:23:56  roland
    Specialized event handler subsystem for PersistentGraphs
    introduced. Events on edges and attributes depend on their nodes, so
    that events might not be delivered, when their nodes are deleted in
    the meantime.

*)
(***************************************************************************)

(* A GraphEventHandler.T is a specialization of EventHandler.  It is aware
   of the types of events on Graphs and is able to handle Edge and
   attribute events as dependents of node events. *)

IMPORT EventHandler AS Super;
IMPORT Node, TriggerStorage, Txn;

TYPE
  T <: Public;

  Public = Super.T OBJECT
           METHODS
             init (ts: TriggerStorage.T): T;
             notifyNodeDeletion (unit : CARDINAL;
                                 level: Txn.Level;
                                 node : Node.T             );
           END;

CONST Brand = "GraphEventHandler";

END GraphEventHandler.
