INTERFACE ScheduledClientPage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.3 $
    $Date: 1999/05/27 02:17:54 $
    $Log: ScheduledClientPage.i3,v $
    Revision 1.3  1999/05/27 02:17:54  hosking
    Changed signature of writeAccess to indicate if page needs loading from server
    or not (in case of write to entire page); this avoids installation reads from
    server.

    Revision 1.2  1999/04/28 15:12:51  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:23  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/11/18 17:51:47  roland
    ASSERTs and FATALs (mostly) replaced by exception handling.

    Revision 1.1  1996/02/09 16:46:57  rbnix
    	First version of client scheduler added.

*)
(***************************************************************************)

(*
 | --- ScheduledClientPage ------------------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  PageHandle,
  Access;
IMPORT
  AtomList;

CONST
  Brand			= "ScheduledClientPage";

TYPE
  T			<: Public;

  Public		= <*TRANSIENT*> ROOT OBJECT
    METHODS
      readAccess	() :PageHandle.T
			RAISES {Access.Locked, FatalError};
      
      writeAccess	(load := TRUE) :PageHandle.T
			RAISES {Access.Locked, FatalError};
    END;

EXCEPTION
  FatalError(AtomList.T);

END ScheduledClientPage.
