INTERFACE InternalVirtualPage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/05/27 02:21:36 $
    $Log: InternalVirtualPage.i3,v $
    Revision 1.2  1999/05/27 02:21:36  hosking
    Changed signature of writeAccess to indicate if page needs loading from server
    or not (in case of write to entire page); this avoids installation reads from
    server.

    Revision 1.1.1.1  1998/12/03 18:54:24  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/11/18 17:52:15  roland
    ASSERTs and FATALs (mostly) replaced by exception handling.

    Revision 1.1  1996/02/29 17:44:13  rbnix
    	First version of subsystem VirtualPages giving transparent
    	access to local/remote files/pages.

*)
(***************************************************************************)
(*
 | --- InternalVirtualPage ------------------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  PageHandle,
  Access,
  VirtualPage;


REVEAL
  VirtualPage.T		<: Internal;

TYPE
  Internal		= VirtualPage.Public OBJECT
    METHODS
      readAccess	()
			:PageHandle.T
			RAISES {Access.Locked, VirtualPage.FatalError}
			:= NIL;
      
      writeAccess	(load	:= TRUE)
			:PageHandle.T
			RAISES {Access.Locked, VirtualPage.FatalError}
			:= NIL;
    END;
  

END InternalVirtualPage.
