MODULE VirtualRemotePage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.3 $
    $Date: 1999/05/27 02:23:53 $
    $Log: VirtualRemotePage.m3,v $
    Revision 1.3  1999/05/27 02:23:53  hosking
    Changed signature of writeAccess to indicate if page needs loading from server
    or not (in case of write to entire page); this avoids installation reads from
    server.

    Revision 1.2  1999/04/28 15:12:55  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:26  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/11/18 17:52:24  roland
    ASSERTs and FATALs (mostly) replaced by exception handling.

    Revision 1.1  1996/02/29 17:44:30  rbnix
    	First version of subsystem VirtualPages giving transparent
    	access to local/remote files/pages.

*)
(***************************************************************************)
(*
 | --- VirtualRemotePage --------------------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  PageHandle,
  Access,
  ScheduledClientPage,
  InternalVirtualPage, VirtualPage,
  ErrorSupport;


REVEAL
  T                     = Public BRANDED OBJECT
      scheduledPage	:ScheduledClientPage.T;

    OVERRIDES
      init		:= Init;
      readAccess	:= ReadAccess;
      writeAccess	:= WriteAccess;
    END;


PROCEDURE Init		(         self		:T;
                                  scheduledPage	:ScheduledClientPage.T)
			:T =
  BEGIN
    self.scheduledPage := scheduledPage;

    RETURN self;
  END Init;


PROCEDURE ReadAccess	(         self		:T)
			:PageHandle.T 
			RAISES {Access.Locked, VirtualPage.FatalError} =
  BEGIN
    TRY
      RETURN self.scheduledPage.readAccess ();
    EXCEPT
      ScheduledClientPage.FatalError(info) =>
      RAISE VirtualPage.FatalError(ErrorSupport.Propagate(
                           "VirtualRemotePage.ReadAccess",
                           "ScheduledClientPage.FatalError", info));
    END;
  END ReadAccess;
  

PROCEDURE WriteAccess	(         self		:T;
                                  load		:BOOLEAN)
			:PageHandle.T 
			RAISES {Access.Locked, VirtualPage.FatalError} =
  BEGIN
    TRY
      RETURN self.scheduledPage.writeAccess (load);
    EXCEPT
      ScheduledClientPage.FatalError(info) =>
      RAISE VirtualPage.FatalError(ErrorSupport.Propagate(
                           "VirtualRemotePage.WriteAccess",
                           "ScheduledClientPage.FatalError", info));
    END;
  END WriteAccess;


BEGIN
END VirtualRemotePage.
