INTERFACE InternalServedClient;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:29 $
    $Log: InternalServedClient.i3,v $
    Revision 1.1.1.1  1998/12/03 18:54:29  hosking
    Import of GRAS3-1.1

    Revision 1.3  1996/11/21 07:55:11  roland
    New resources getResourceUser, getFileUser, and getGraphUser
    implemented. These resources compute sequences of information about
    clients that use the Graph/Resource/File.

    Revision 1.2  1996/08/06 16:32:08  roland
    Merge of PAGESERVER and main branch.

    Revision 1.1.2.1  1996/07/24 12:54:11  rbnix
    	New parameter/method to access info text of client added.

    Revision 1.1  1996/02/23 15:02:46  rbnix
    	First version of subsystem ServedClient added.

*)
(***************************************************************************)

(*
 | --- InternalServedClient -----------------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  Pathname,
  CallbackPort,
  ServedClient,
  ClientInfo;


REVEAL
  ServedClient.T		<: Internal;

TYPE
  Internal			= ServedClient.Public OBJECT
    METHODS
      init			(         resourceName	:Pathname.T;
				          callbackPort	:CallbackPort.T;
                                          info		:ClientInfo.T)
				:ServedClient.T;
  END;    
  

END InternalServedClient.
