MODULE ActiveAction;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:38 $
    $Log: ActiveAction.m3,v $
    Revision 1.1.1.1  1998/12/03 18:54:38  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:03:58  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. The event handler
    subsystem implements the mapping between events and action via triggers.

*)
(***************************************************************************)

PROCEDURE PrioLess(p1, p2: PriorityType): BOOLEAN =
  BEGIN
    IF p1.prio < p2.prio THEN
      RETURN TRUE;
    ELSIF p2.prio < p1.prio THEN
      RETURN FALSE;
    ELSE
      RETURN p1.timeStamp > p2.timeStamp;
    END;
  END PrioLess;

PROCEDURE Priority(act: T): PriorityType =
  BEGIN
    RETURN act.priority;
  END Priority; 

BEGIN
END ActiveAction.
