INTERFACE Globals;

IMPORT OO7, BaseAssemblyList, GenParams, IntRefBPlusTree, TextRefBPlusTree,
       ModuleSet, ODMG;

VAR
  (* index mapping atomic part ids to atomic parts *)
  AtomicPartIdx: IntRefBPlusTree.T;
  (* index mapping composite part ids to composite parts *)
  CompPartIdx: IntRefBPlusTree.T;
  (* index mapping document titles to documents *)
  DocumentIdx: TextRefBPlusTree.T;
  (* index mapping document ids to documents *)
  DocumentIdIdx: IntRefBPlusTree.T;
  (* index mapping assembly ids to base assemblies *)
  BaseAssemblyIdx: IntRefBPlusTree.T;
  (* index mapping module names to modules *)
  ModuleIdx: TextRefBPlusTree.T;
  (* index mapping build dates to atomic parts *)
  BuildDateIndex: IntRefBPlusTree.T;
  (* extent of all modules *)
  AllModules: ModuleSet.T;
  chain_tx := TRUE;
  nextAtomicId: INTEGER;
  nextCompositeId: INTEGER;
  nextComplexAssemblyId: INTEGER;
  nextBaseAssemblyId: INTEGER;
  nextModuleId: INTEGER;
  shared_cp: REF ARRAY OF BaseAssemblyList.T;
  private_cp: REF ARRAY OF BaseAssemblyList.T;
  types: ARRAY [0..GenParams.NumTypes - 1] OF OO7.Type;
  debugMode := FALSE;

PROCEDURE InitGlobals(db: ODMG.T);

END Globals.
