MODULE SetParams EXPORTS SetParams, VarParams;

IMPORT Rd, Stdio, Lex, Thread, FloatMode;
FROM IO IMPORT OpenRead, Put, PutInt;
FROM Lex IMPORT Int, Match, Skip;

(*
//////////////////////////////////////////////////////////////////
// Set generation parameters for the benchmark.
//
// Assumes a configuration file "OO7.config" of the
// following format:
//
// NumAssmPerAssm     	n1
// NumCompPerAssm     	n2
// NumCompPerModule   	n3
// NumAssmLevels      	n4
// TotalModules       	n5
// NumAtomicPerComp	n6
// NumConnPerAtomic 	n7
// DocumentSize		n8
// ManualSize           n9
//
// where n1 through n0 are integers.  The order of
// parameters is critical!  (This is a dumb parser
// after all.) 
//////////////////////////////////////////////////////////////////
*)

PROCEDURE FromFile(configFileName: TEXT) =
  VAR
    configFile := OpenRead(configFileName);
  PROCEDURE GetParam(param: TEXT): INTEGER =
    VAR value: INTEGER;
    BEGIN
      TRY
        Skip(configFile);
        Match(configFile, param);
        value := Int(configFile);
      EXCEPT
      | Rd.Failure, Lex.Error, Thread.Alerted, FloatMode.Trap =>
        Put("Error reading configuration parameter "); Put(param); Put("\n");
        <*ASSERT FALSE*>
      END;
      Put(param); Put(" = "); PutInt(value); Put(".\n");
      RETURN value;
    END GetParam;
  BEGIN
    IF configFile = NIL THEN
      Put("Couldn't open config file: ", Stdio.stderr);
      Put(configFileName, Stdio.stderr); Put("\n", Stdio.stderr);
      <*ASSERT FALSE*>
    END;

    (* Get parameters. *)
    NumAssmPerAssm    := GetParam("NumAssmPerAssm");
    NumCompPerAssm    := GetParam("NumCompPerAssm");
    NumCompPerModule  := GetParam("NumCompPerModule");
    NumAssmLevels     := GetParam("NumAssmLevels");
    TotalModules      := GetParam("TotalModules");
    NumAtomicPerComp  := GetParam("NumAtomicPerComp");
    NumConnPerAtomic  := GetParam("NumConnPerAtomic");
    DocumentSize      := GetParam("DocumentSize");
    ManualSize        := GetParam("ManualSize");

    TotalCompParts := NumCompPerModule * TotalModules;
    Put("Setting TotalCompParts to "); PutInt(TotalCompParts); Put(".\n");

    TotalAtomicParts := TotalCompParts * NumAtomicPerComp;
    Put("Setting TotalAtomicParts to "); PutInt(TotalAtomicParts); Put(".\n" );
  END FromFile; 

BEGIN
END SetParams.
