MODULE Resource;

IMPORT RTIO, Atom, AtomList, RTParams, Lex, Scan, Pathname, Env, Config,
       Text, FloatMode;
IMPORT VirtualResourceSystem, VirtualResource, Access, PageFile;

EXCEPTION FatalError; <*FATAL FatalError*>
PROCEDURE fatalAtoms (t: AtomList.T) =
  BEGIN
    WHILE t # NIL DO
      RTIO.PutText(Atom.ToText(t.head)); RTIO.PutChar('\n');
      t := t.tail;
    END;
    RTIO.Flush();
    RAISE FatalError;
  END fatalAtoms;
 
PROCEDURE fatalText (t: TEXT) =
  BEGIN
    RTIO.PutText(t); RTIO.PutChar('\n'); RTIO.Flush();
    RAISE FatalError;
  END fatalText;

BEGIN
END Resource.
