UNSAFE MODULE Transaction;

IMPORT Shore, ShoreError, SHerror, AtomList, RTDB;
FROM RTHeapDep IMPORT Page;
FROM ShoreErrorPosix IMPORT ErrnoAtom;

<* FATAL ShoreError.E *>

VAR m := NEW(MUTEX);

REVEAL Private = <*TRANSIENT*> ROOT BRANDED "Transaction.Private" OBJECT END;
REVEAL T = Public BRANDED "Transaction.T" OBJECT
  open := FALSE;
OVERRIDES
  begin := Begin;
  commit := Commit;
  chain := Chain;
  abort := Abort;
  checkpoint := Checkpoint;
  isOpen := IsOpen;
  lock := Lock;
END;

PROCEDURE Begin(self: T) RAISES { InProgress } =
  BEGIN
    LOCK m DO
      TRY
        Shore.begin();
      EXCEPT ShoreError.E(code) => 
        IF AtomList.Member(code, ErrnoAtom(SHerror.SH_Already)) THEN
          RAISE InProgress;
        ELSIF AtomList.Member(code, ErrnoAtom(SHerror.SH_TxNotAllowed)) THEN
          RAISE InProgress
        ELSE 
          RAISE ShoreError.E(code);
        END;
      END;
      RTDB.Invalidate();
      self.open := TRUE;
    END;
  END Begin;

PROCEDURE Commit(self: T)
  RAISES { NotInProgress, Disabled } =
  BEGIN
    LOCK m DO
      IF NOT self.open THEN RAISE NotInProgress; END;
      IF NOT RTDB.Flush() THEN RAISE Disabled END;
      TRY
        Shore.commit();
      EXCEPT ShoreError.E(code) => 
        IF AtomList.Member(code, ErrnoAtom(SHerror.SH_TxRequired)) THEN
          RAISE NotInProgress
        ELSE 
          RAISE ShoreError.E(code);
        END;
      END;
      RTDB.Release();
      self.open := FALSE;
    END;
   END Commit;

PROCEDURE Chain(self: T)
  RAISES { NotInProgress, Disabled } =
  BEGIN
    LOCK m DO
      IF NOT self.open THEN RAISE NotInProgress; END;
      IF NOT RTDB.Flush() THEN RAISE Disabled END;
      TRY
        Shore.chain();
      EXCEPT ShoreError.E(code) => 
        IF AtomList.Member(code, ErrnoAtom(SHerror.SH_TxRequired)) THEN
          RAISE NotInProgress
        ELSE 
          RAISE ShoreError.E(code);
        END;
      END;
    END;
  END Chain; 

PROCEDURE Abort(self: T) RAISES { NotInProgress } =
  BEGIN
    LOCK m DO
      IF NOT self.open THEN RAISE NotInProgress; END;
      TRY
        Shore.abort();
      EXCEPT ShoreError.E(code) => 
        IF AtomList.Member(code, ErrnoAtom(SHerror.SH_TxRequired)) THEN
          RAISE NotInProgress
        ELSE 
          RAISE ShoreError.E(code);
        END;
      END;
      RTDB.Release();
      self.open := FALSE;
    END;
  END Abort;

PROCEDURE Checkpoint(self: T)
  RAISES { NotInProgress, Disabled } =
  BEGIN
    LOCK m DO
      IF NOT self.open THEN RAISE NotInProgress; END;
      IF NOT RTDB.Flush() THEN RAISE Disabled END;
    END;
  END Checkpoint;

PROCEDURE IsOpen(self: T): BOOLEAN =
  BEGIN
    LOCK m DO
      RETURN self.open;
    END;
  END IsOpen;

PROCEDURE Lock(self: T; object: REFANY; mode: LockMode)
  RAISES { NotInProgress } =
  VAR
    db: RTDB.T;
    p: Page;
  BEGIN
    LOCK m DO
      IF NOT self.open THEN RAISE NotInProgress; END;
      IF RTDB.RefPageMap(object, db, p) THEN
        db.lock(p, mode);
      END;
    END;
  END Lock;

BEGIN
END Transaction.
