INTERFACE Shore;

IMPORT ShoreError;
FROM Utypes IMPORT mode_t;
FROM Ctypes IMPORT char_star, char_star_star;

<*EXTERNAL "shore_dbTSize"*>
VAR dbTSize: INTEGER;

<*EXTERNAL "shore_pageTSize"*>
VAR pageTSize: INTEGER;

<*EXTERNAL "shore_init"*>
PROCEDURE init(argc: INTEGER; argv: char_star_star)
  RAISES { ShoreError.E};

<*EXTERNAL "shore_create"*>
PROCEDURE create(database_name: char_star; mode: mode_t; db: ADDRESS)
  RAISES { ShoreError.E };

<*EXTERNAL "shore_open"*>
PROCEDURE open(database_name: char_star; db: ADDRESS)
  RAISES { ShoreError.E };

<*EXTERNAL "shore_exit"*>
PROCEDURE exit();

<*EXTERNAL "shore_GetPage"*>
PROCEDURE GetPage(db: ADDRESS; pageId, bytes: INTEGER; page: ADDRESS)
  RAISES { ShoreError.E };

<*EXTERNAL "shore_Fetch"*>
PROCEDURE Fetch(page: ADDRESS): ADDRESS
  RAISES { ShoreError.E };

<*EXTERNAL "shore_Update"*>
PROCEDURE Update(page: ADDRESS): ADDRESS
  RAISES { ShoreError.E };

TYPE LockMode = {
  NL,                                    (* no lock                        *)
  IS,					 (* intention share (read)         *)
  IX,					 (* intention exclusive (read)     *)
  SH,					 (* share (read)                   *)
  SIX,					 (* share with intention exclusive *)
  UD,					 (* update (allow no more readers) *)
  EX					 (* exclusive (write)              *)
};

<*EXTERNAL "shore_Valid"*>
PROCEDURE Valid(page: ADDRESS; mode: LockMode)
  RAISES { ShoreError.E };

<*EXTERNAL "shore_Flush"*>
PROCEDURE Flush(page: ADDRESS)
  RAISES { ShoreError.E };

<*EXTERNAL "shore_begin"*>
PROCEDURE begin()
  RAISES { ShoreError.E };

<*EXTERNAL "shore_commit"*>
PROCEDURE commit()
  RAISES { ShoreError.E };

<*EXTERNAL "shore_abort"*>
PROCEDURE abort()
  RAISES { ShoreError.E };

<*EXTERNAL "shore_chain"*>
PROCEDURE chain()
  RAISES { ShoreError.E };

END Shore.
