UNSAFE MODULE ShoreErrorPosix EXPORTS ShoreError, ShoreErrorPosix;

IMPORT Atom, AtomList, Fmt, OSErrorPosix, ShoreError, SHerror;

VAR cache := ARRAY [SHerror.Min..SHerror.Max] OF Atom.T {NIL, ..};
(* The table is initialized lazily. *)

PROCEDURE NewAtom (n: CARDINAL): Atom.T =
  BEGIN
    RETURN Atom.FromText("errno=" & Fmt.Int(n));
  END NewAtom;

PROCEDURE ErrnoAtom(n: CARDINAL): Atom.T =
  BEGIN
    IF n < SHerror.Min OR n > SHerror.Max THEN
      RETURN OSErrorPosix.ErrnoAtom(n);
    ELSE
      IF cache[n] = NIL THEN cache[n] := NewAtom(n) END;
      RETURN cache[n]
    END;
  END ErrnoAtom;

PROCEDURE Raise0(errno: INTEGER) RAISES {ShoreError.E} =
  BEGIN
    RAISE ShoreError.E(
      NEW(AtomList.T, head := ErrnoAtom(errno), tail := NIL))
  END Raise0;

BEGIN
  ShoreErrorPosix_Raise0 := LOOPHOLE (Raise0, ADDRESS);
END ShoreErrorPosix.
