#ifdef __GNUC__
#pragma  "implementation"
#endif
#define MODULE_C
#define MODULE_CODE

#ifdef __CCE__
#pragma expand
#endif

#include "m3.h"

void (*ShoreErrorPosix_Raise0)(int errno);

static int volid_init = 0;
static VolId volid;

int shore_dbTSize = sizeof(Ref<Database>);
int shore_pageTSize = sizeof(Ref<Page>);

extern "C" void shore_init(int argc, char *argv[])
{
  shrc rc;

  // initialize connection to server
  rc = Shore::init(argc, argv, 0, getenv("M3_RC"));
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());
}

extern "C" void
shore_create(char *database_name, mode_t mode, Ref<Database> &db) {
  shrc rc;

  if (mode & 0400) mode |= 0100;
  if (mode & 0040) mode |= 0010;
  if (mode & 0004) mode |= 0001;
  SH_DO(Shore::mkdir(database_name, mode));
  SH_DO(Shore::chdir(database_name));
  SH_DO(Ref<Database>::new_persistent("db", 0644, db));
  db.update()->initialize();
  SH_DO(Shore::chdir("/"));
}

void Database::initialize() {
  SH_DO(pages.create("pages", 0664, pages));
  SH_DO(pageIndex.init(UniqueBTree));
}

extern "C" void shore_open(char *database_name, Ref<Database> &db) {
  shrc rc;

  SH_BEGIN_TRANSACTION(rc);
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());

  SH_DO(Shore::chdir(database_name));
  SH_DO(Ref<Database>::lookup("db", db));
  SH_DO(Shore::chdir("/"));
  SH_DO(SH_COMMIT_TRANSACTION);
}

extern "C" void shore_exit() {
  shrc rc = Shore::exit();
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());  
}

#define shore_pagesize 8192

Ref<Page> Database::getPage(pageId id, long bytes) const {
  bool found;
  Ref<Page> page;
  shrc rc = pageIndex.find(id, page, found);
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());
  if (!found) {
    page = new(pages) Page;
    page.update()->id = id;
    page.update()->size = bytes;
    page.update()->data.set(bytes - 1, 0);
    rc = pageIndex.insert(id, page);
    if (rc != RCOK)
      ShoreErrorPosix_Raise0(rc.err_num());
  }
  if (page->size < bytes) abort();
  return page;
}

extern "C" void
shore_GetPage(Ref<Database> db, pageId id, int bytes, Ref<Page> &page)
{
  page = db->getPage(id, bytes);
}

extern "C" char *shore_Fetch(Ref<Page> &page)
{
  return page->data;
}

extern "C" char *shore_Update(Ref<Page> &page)
{
  return page.update()->data;
}

extern "C" void shore_Valid(Ref<Page> &page, lock_mode_t mode)
{
  page.valid(mode);
}

extern "C" void
shore_Flush(Ref<Page> &page)
{
  page.flush();
}

extern "C" void shore_begin() {
  shrc rc = Shore::begin_transaction();
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());
}

extern "C" void shore_commit() {
  shrc rc = Shore::commit_transaction();
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());
}

extern "C" void shore_abort() {
  shrc rc = Shore::abort_transaction();
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());
}

extern "C" void shore_chain() {
  shrc rc = Shore::chain_transaction();
  if (rc != RCOK)
    ShoreErrorPosix_Raise0(rc.err_num());
}
