MODULE Access;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:53:35 $
    $Log: Access.m3,v $
    Revision 1.1.1.1  1998/12/03 18:53:35  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/03/01 12:56:40  rbnix
    	Format function(s) added.

*)
(***************************************************************************)
(*
 | --- Access -------------------------------------------------------------
 
 | ------------------------------------------------------------------------
 *)

PROCEDURE FmtMode	(         mode		:Mode) :TEXT =
  BEGIN
    CASE mode OF
    | Mode.ReadOnlyShared =>
      RETURN "Access.Mode.ReadOnlyShared";
      
    | Mode.ReadWriteShared =>
      RETURN "Access.Mode.ReadWriteShared";
      
    | Mode.ReadWriteExclusive =>
      RETURN "Access.Mode.ReadWriteExclusive";
    END
  END FmtMode;
  

PROCEDURE FmtKind	(         kind		:Kind) :TEXT =
  BEGIN
    CASE kind OF
    | Kind.Data =>
      RETURN "Access.Kind.Data";
      
    | Kind.Log =>
      RETURN "Access.Kind.Log";
    END
  END FmtKind;

BEGIN
END Access.
