INTERFACE Txn;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: chenj $
    $Revision: 1.3 $
    $Date: 1999/07/08 22:56:35 $
    $Log: Txn.i3,v $
    Revision 1.3  1999/07/08 22:56:35  chenj
    Add chain transaction.

    Revision 1.2  1999/04/28 15:12:24  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:36  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/03/01 12:56:46  rbnix
    	Format function(s) added.

    Revision 1.1  1996/02/09 16:03:05  rbnix
    	First version of common used scheduler parts.

*)
(***************************************************************************)


(*
 | --- Txn --------------------------------------------------------
  This type collection module reveals some common information about
  transactions.

  User transactions starts with TopLevel. Every begin transaction increases
  the transaction level by 1. If no user transactions are pending the
  transaction level is set to EnvelopeLevel.
 | ------------------------------------------------------------------------
*)


CONST
  EnvelopeLevel		= 0;
  TopLevel		= 1;

  
TYPE
  Level			= [EnvelopeLevel .. LAST (INTEGER)];

  End			= {No,			(* continue		*)
                           Commit,		(* propagate changes	*)
                           Chain,		(* propagate changes and continue *)
                           Abort};		(* forget changes	*)


PROCEDURE FmtEnd	(         end		:End) :TEXT;
  

END Txn.
