INTERFACE Type;

(***************************************************************************)
(** Created by:  Peter Klein						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/05/04 22:09:11 $
    $Log: Type.i3,v $
    Revision 1.2  1999/05/04 22:09:11  hosking
    Fix definition of Word type for 64-bit machines.

    Revision 1.1.1.1  1998/12/03 18:53:35  hosking
    Import of GRAS3-1.1

    Revision 1.3  1996/02/09 16:06:58  rbnix
    	Types are now packed to be more reliable.

# Revision 1.2  1993/10/08  13:59:19  pk
# Triple inserted.
#
# Revision 1.1  1993/09/29  23:55:47  pk
# Initial revision
#
*)
(***************************************************************************)

IMPORT Int32;

CONST
  MaxByte	= 16_FF;			(* max byte value	*)
  MaxShort	= 16_FFFF;			(* max two byte value	*)
  MaxTriple	= 16_FFFFFF;			(* max three byte value *)
  MaxWord	= 16_FFFFFFFF;			(* max four byte value	*)


TYPE
  Byte		= BITS  8 FOR [0 .. MaxByte];	(* a byte		*)
  Short		= BITS 16 FOR [0 .. MaxShort];	(* two bytes		*)
  Triple	= BITS 24 FOR [0 .. MaxTriple];	(* three byte subrange	*)
  Word		= Int32.T;			(* four bytes		*)

  ByteArray	= ARRAY OF Byte;

END Type.
