INTERFACE Page;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.3 $
    $Date: 2001/04/03 16:32:51 $
    $Log: Page.i3,v $
    Revision 1.3  2001/04/03 16:32:51  hosking
    Eliminated transform parameter to putData/getData.

    Revision 1.2  1999/04/28 15:12:30  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:38  hosking
    Import of GRAS3-1.1

    Revision 1.3  1996/02/29 17:35:03  rbnix
    	New method copyData added.

    Revision 1.2  1996/02/09 16:32:54  rbnix
    	Function getAll added to avoid multiple copying of arguments.

    Revision 1.1  1996/01/31 10:02:09  rbnix
    	Initial version for subsystem Page.

*)
(***************************************************************************)

(*
 * --- Page ---------------------------------------------------------------
 * Abstract data type containing "raw" page data.
 * ------------------------------------------------------------------------
 *)

IMPORT
  PageData;

TYPE
  T                     <: Public;

  Public		= <*TRANSIENT*> ROOT OBJECT
      data		:PageData.T;

    METHODS
      putData           (READONLY data		:PageData.Part;
			          pos		:= FIRST (PageData.Index));

      getData           (VAR      data		:PageData.Part;
			          pos		:= FIRST (PageData.Index));

      copyData		(         source	:PageData.Index;
                                  destination	:PageData.Index;
                                  length	:PageData.Index);
    END;


END Page.
