INTERFACE TypeCache;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:12:46 $
    $Log: TypeCache.i3,v $
    Revision 1.2  1999/04/28 15:12:46  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:15  hosking
    Import of GRAS3-1.1

    Revision 1.2  1997/10/31 14:23:28  roland
    Adapted to new RuleEngine.

    Revision 1.1  1997/07/07 15:56:49  roland
    New caches for node types of a typed graph.

*)
(***************************************************************************)

(* A TypeCache holds the value of the Type-IndexAttribute of nodes in a
   TypedGraph.  It is coupled with the RuleEngine to synchronize
   with transactions of other clients. *)

IMPORT Node, TypedGraphPool;

TYPE
  T <: Public;

  Public = <*TRANSIENT*> ROOT OBJECT
           METHODS
             init (pool: TypedGraphPool.T): T;

             get (node: Node.T; VAR val: TEXT): BOOLEAN;
                  (* Return the value stored for node.  If it is not in the
                     cache the return-value will be FALSE. *)
             put (node: Node.T; val: TEXT);
                  (* Stores val as value for key *)
             delete (node: Node.T);
                     (* If cache has an entry for key, it is removed. *)
             flush ();
                    (* Clears the cache. *)
           END;

END TypeCache.
