INTERFACE ScheduledClientPage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.8 $
    $Date: 2001/04/10 18:23:03 $
    $Log: ScheduledClientPage.i3,v $
    Revision 1.8  2001/04/10 18:23:03  hosking
    peekAccess should not raise Access.Locked.

    Revision 1.7  2001/04/07 18:47:53  hosking
    Allow peekAccess to raise Access.Locked as necessary.

    Revision 1.6  2001/04/04 19:28:55  hosking
    Added peekAccess.

    Revision 1.5  2001/04/04 19:21:26  hosking
    Added hook for peekAccess method.

    Revision 1.4  2000/05/26 20:03:48  hosking
    No need for load parameter to writeAccess.

    Revision 1.3  1999/05/27 02:17:54  hosking
    Changed signature of writeAccess to indicate if page needs loading from server
    or not (in case of write to entire page); this avoids installation reads from
    server.

    Revision 1.2  1999/04/28 15:12:51  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:23  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/11/18 17:51:47  roland
    ASSERTs and FATALs (mostly) replaced by exception handling.

    Revision 1.1  1996/02/09 16:46:57  rbnix
    	First version of client scheduler added.

*)
(***************************************************************************)

(*
 | --- ScheduledClientPage ------------------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  PageHandle,
  Access;
IMPORT
  AtomList;

CONST
  Brand			= "ScheduledClientPage";

TYPE
  T			<: Public;

  Public		= <*TRANSIENT*> ROOT OBJECT
    METHODS
      peekAccess	() :PageHandle.T
			RAISES {FatalError};
      
      readAccess	() :PageHandle.T
			RAISES {Access.Locked, FatalError};
      
      writeAccess	() :PageHandle.T
			RAISES {Access.Locked, FatalError};
    END;

EXCEPTION
  FatalError(AtomList.T);

END ScheduledClientPage.
