INTERFACE ServedClient;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.9 $
    $Date: 1999/07/22 16:06:24 $
    $Log: ServedClient.i3,v $
    Revision 1.9  1999/07/22 16:06:24  hosking
    Added clearChainData method.

    Revision 1.8  1999/07/21 21:28:32  hosking
    Cleaned up.

    Revision 1.7  1999/07/16 03:10:24  chenj
    Fix bugs for chain transaction.

    Revision 1.6  1999/07/10 04:10:23  hosking
    CommunicationTbl not EntryTbl.

    Revision 1.5  1999/07/10 04:02:42  hosking
    Make chainTxnChanges access into method call to be consistent with code style.

    Revision 1.4  1999/07/10 03:57:18  hosking
    Cosmetic cleanup.

    Revision 1.3  1999/07/08 23:03:23  chenj
    Add chain transaction.

    Revision 1.2  1999/04/28 15:12:58  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:29  hosking
    Import of GRAS3-1.1

    Revision 1.5  1996/11/21 07:55:13  roland
    New resources getResourceUser, getFileUser, and getGraphUser
    implemented. These resources compute sequences of information about
    clients that use the Graph/Resource/File.

    Revision 1.4  1996/08/06 16:32:09  roland
    Merge of PAGESERVER and main branch.

    Revision 1.3.2.2  1996/07/24 12:54:14  rbnix
    	New parameter/method to access info text of client added.

    Revision 1.3.2.1  1996/07/11 10:48:34  rbnix
    	Method getTransactionNumber added. Transaction are numbered at
    	start of transaction to determine its age.

    Revision 1.3  1996/03/06 07:32:08  rbnix
    	In method kill: additional parameter describing why this
    	client was killed added.

    	New method whyKilled added to ask kill reason.

    Revision 1.2  1996/02/26 17:57:23  rbnix
    	Procedures Hash and Equal added to use with generics.

    Revision 1.1  1996/02/23 15:02:47  rbnix
    	First version of subsystem ServedClient added.

*)
(***************************************************************************)

(*
 | --- ServedClientEntry --------------------------------------------------
 This abstract data type module holds common used information about served
 clients.
 | ------------------------------------------------------------------------
 *)
IMPORT
  Word,
  Pathname,
  CallbackPort, CommunicationSeq, ClientInfo, CommunicationTbl;


CONST
  Brand				= "ServedClient";

TYPE
  T				<: Public;

  Public			= <*TRANSIENT*> ROOT OBJECT
    METHODS
      getID			() :TEXT;
      getInfo			() :ClientInfo.T;
      getResourceName		() :Pathname.T;
      getCallbackPort		() :CallbackPort.T;

      
      incXLockCount		();
      decXLockCount		();
      getXLockCount		() :INTEGER;

      isKilled			() :BOOLEAN;
      kill			(         why		:TEXT
							:= NIL);
      whyKilled			() :TEXT;

      inTransaction		() :BOOLEAN;
      setTransaction		(         on		:BOOLEAN);
      getTransactionNumber	() :CARDINAL;

      getPropagationData	() :CommunicationSeq.T;
      clearPropagationData	();

      getChainData		() :CommunicationTbl.T;
      clearChainData		();
    END;


PROCEDURE Equal			(         t1, t2	:T) :BOOLEAN;

PROCEDURE Hash			(         t		:T) :Word.T;


END ServedClient.
