MODULE ServerWaitEntry;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:33 $
    $Log: ServerWaitEntry.m3,v $
    Revision 1.1.1.1  1998/12/03 18:54:33  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/08/06 16:33:01  roland
    Merge of PAGESERVER and main branch.

    Revision 1.1.2.1  1996/07/11 12:13:34  rbnix
    	First version of module providing a data type holding
    	information about waiting clients for data request.

*)
(***************************************************************************)
IMPORT Fmt AS StdFmt;


PROCEDURE Fmt		(         entry		:T) :TEXT =
  
  BEGIN
    RETURN "waitingClient = " & entry.waitingClient.getID () &
           (* ", otherClients = (" & entry.otherClients.fmt () & ")" & *)
           ", age = " & StdFmt.Int (entry.age) &
           ", pageNo = " & StdFmt.Int (entry.pageNo) &
           ", file = " & entry.file;
  END Fmt;

BEGIN
END ServerWaitEntry.
