INTERFACE WaitForGraph;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:13:03 $
    $Log: WaitForGraph.i3,v $
    Revision 1.2  1999/04/28 15:13:03  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:33  hosking
    Import of GRAS3-1.1

    Revision 1.3  1996/10/17 11:23:50  rbnix
    	New method deleteNode added.

    Revision 1.2  1996/08/06 16:33:04  roland
    Merge of PAGESERVER and main branch.

    Revision 1.1.2.1  1996/07/11 12:16:56  rbnix
    	First version of abstract data type module representing a wait
    	for graph.

*)
(***************************************************************************)
(*
 | --- WaitForGraph -------------------------------------------------------
 
 | ------------------------------------------------------------------------
 *)
IMPORT
  ServedClient;


TYPE
  T			<: Public;
  
  Public		= OBJECT
    METHODS
      init		() :T;

      getNode		(         client	:ServedClient.T)
			:Node;

      insertNode	(         client	:ServedClient.T)
			:Node;

      deleteNode	(         client	:ServedClient.T);

      insertEdge	(         source,
                                  target	:Node);

      iterateNodes	()
			:NodeIterator;
      
      iterateNeighbours	(         source	:Node)
			:NodeIterator;
    END;

  
  Node			<: PublicNode;

  PublicNode		= <*TRANSIENT*> ROOT OBJECT
    METHODS
      setWeight		(         weight	:CARDINAL);
      getWeight		() :CARDINAL;
      getClient		() :ServedClient.T;
    END;


  NodeIterator		<: PublicNodeIterator;

  PublicNodeIterator	= OBJECT
    METHODS
      next		(VAR      node		:Node;
                         VAR      client	:ServedClient.T)
			:BOOLEAN;
    END;


END WaitForGraph.
