(*!  FUNCTIONAL MODULE *)
INTERFACE EventTranslation;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:13:08 $
    $Log: EventTranslation.i3,v $
    Revision 1.2  1999/04/28 15:13:08  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:39  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:05:00  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. The remote rule handler
    connects to a special server object to communicate with other rule engines.

*)
(***************************************************************************)

IMPORT IntIntTransientTbl AS IntIntTbl, IntTextTransientTbl AS IntTextTbl;
IMPORT EventPattern, Event;

EXCEPTION
  UnknownType;
  AttributeMismatch;

PROCEDURE ComposeEvent (type : TEXT;
                        bools: IntIntTbl.T;
                        ints : IntIntTbl.T;
                        texts: IntTextTbl.T): Event.T
  RAISES {UnknownType, AttributeMismatch};

PROCEDURE DecomposeEvent (    event: Event.T;
                          VAR type : TEXT;
                          VAR bools: IntIntTbl.T;
                          VAR ints : IntIntTbl.T;
                          VAR texts: IntTextTbl.T);

PROCEDURE ComposePattern (type : TEXT;
                          bools: IntIntTbl.T;
                          ints : IntIntTbl.T;
                          texts: IntTextTbl.T ): EventPattern.T
  RAISES {UnknownType, AttributeMismatch};

PROCEDURE DecomposePattern (    pattern: EventPattern.T;
                            VAR type   : TEXT;
                            VAR bools  : IntIntTbl.T;
                            VAR ints   : IntIntTbl.T;
                            VAR texts  : IntTextTbl.T    );

END EventTranslation.
