MODULE RemoteActiveAction;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:39 $
    $Log: RemoteActiveAction.m3,v $
    Revision 1.1.1.1  1998/12/03 18:54:39  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:05:08  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. The remote rule handler
    connects to a special server object to communicate with other rule engines.

*)
(***************************************************************************)

PROCEDURE PrioLess(p1, p2: PriorityType): BOOLEAN =
  BEGIN
    IF p1.prio < p2.prio THEN
      RETURN TRUE;
    ELSIF p2.prio < p1.prio THEN
      RETURN FALSE;
    ELSE
      RETURN p1.timeStamp > p2.timeStamp;
    END;
  END PrioLess;

PROCEDURE Priority(act: T): PriorityType =
  BEGIN
    RETURN act.priority;
  END Priority; 

BEGIN
END RemoteActiveAction.
