(*! DATA OBJECT MODULE *)
INTERFACE TriggerMap;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:40 $
    $Log: TriggerMap.i3,v $
    Revision 1.1.1.1  1998/12/03 18:54:40  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:05:20  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. The remote rule handler
    connects to a special server object to communicate with other rule engines.

*)
(***************************************************************************)

PROCEDURE Bind(local, remote: CARDINAL);
PROCEDURE RemoveWithLocal(local: CARDINAL);
PROCEDURE RemoveWithRemote(remote: CARDINAL);

PROCEDURE GetLocal(remote: CARDINAL; VAR local: CARDINAL): BOOLEAN;
PROCEDURE GetRemote(local: CARDINAL; VAR remote: CARDINAL): BOOLEAN;
  (* Return value is true iff a binding exists *)

END TriggerMap.
