(*! DATA TYPE MODULE *)
INTERFACE ContextSet;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:13:11 $
    $Log: ContextSet.i3,v $
    Revision 1.2  1999/04/28 15:13:11  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:35  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:06:13  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. RuleTypes and EventTypes
    subsystems implement basic types of the rule engine.

*)
(***************************************************************************)

IMPORT Word, TextTransientSeq AS TextSeq;

TYPE
  T = Word.T;                    (* This is opaque ! *)
  Index = [0 .. BITSIZE(T) - 1];

EXCEPTION
  Unknown;
  
PROCEDURE DeclareContext (name: TEXT): Index;

PROCEDURE ContextIndex(name: TEXT): Index RAISES {Unknown};
PROCEDURE ContextName (context: Index): TEXT RAISES {Unknown};
PROCEDURE ExistsContextByName (name: TEXT): BOOLEAN;
PROCEDURE ExistsContext (context: Index): BOOLEAN;

PROCEDURE Empty (): T;
PROCEDURE Insert (cs: T; context: Index): T;
PROCEDURE Remove (cs: T; context: Index): T;
PROCEDURE Contains (cs: T; context: Index): BOOLEAN;

PROCEDURE FromSeq (s: TextSeq.T): T RAISES {Unknown};
PROCEDURE ToSeq (cs: T): TextSeq.T;

PROCEDURE Inhibits (inh, act: T): BOOLEAN;
  (* Context inh is inhibiting for context act, iff their intersection is
     not empty, i.e. if any context of inh is also in act *)
PROCEDURE Permits (perm, act: T): BOOLEAN;
  (* Context perm is permitting for context act, iff perm is a subset of
     act, i.e. if all context of perm are in act. *)

END ContextSet.
