UNSAFE MODULE Database EXPORTS Database, InternalDatabase;

IMPORT TextRefTransientTbl AS TextRefTbl;
IMPORT BaseDatabase, InternalTransaction, BaseTransaction;
IMPORT PStore;
IMPORT Transaction;
IMPORT RTHeapDB;
IMPORT Pathname;
IMPORT ThreadF;


REVEAL
  T = Internal BRANDED "Database.T" OBJECT
    opened := FALSE;
  OVERRIDES
    init := Init;
  END;



VAR
  dbs := NEW(TextRefTbl.Default).init();
  mutex := NEW(MUTEX);

PROCEDURE Init(self: T): BaseDatabase.T =
  BEGIN
    EVAL BaseDatabase.T.init(self);
    RETURN self;
  END Init;


PROCEDURE Create(name: Pathname.T)
  RAISES { Exists, Transaction.InProgress, Transaction.Disabled } =
  VAR
    db: T :=  NEW(T).init();
    tr := NARROW(NEW(Transaction.T).init(), InternalTransaction.Internal);
  BEGIN
    LOCK mutex DO
      tr.id := PStore.begin();
      ThreadF.TxnBegin(tr);
      db.id := PStore.create(tr.id, name);
      TRY
        RTHeapDB.Flush(db)
      EXCEPT
      | RTHeapDB.Disabled =>
        PStore.abort(tr.id);             <* NOWARN *>
        RAISE Transaction.Disabled;
      END;
      PStore.commit(tr.id);              <* NOWARN *>
      ThreadF.TxnCommit();
      IF dbs.put(name, db) THEN
        <* ASSERT FALSE *>
      END;
    END;
  END Create;

PROCEDURE Open(name: Pathname.T): T
  RAISES { NotFound, Opened, Transaction.InProgress } =
  VAR
    db: T;
    tr := NARROW(NEW(Transaction.T).init(), InternalTransaction.Internal);
    ref: <*TRANSIENT*> REFANY;
  BEGIN
    IF dbs.get(name, ref) THEN
      db := ref;
      IF db.opened THEN RAISE Opened END;
    ELSE
      db := NEW(T).init();
      tr.id := PStore.begin();
      ThreadF.TxnBegin(tr);
      TRY
        db.id := 
            PStore.open(tr.id, name);
      EXCEPT
      | NotFound =>
        PStore.abort(tr.id);               <* NOWARN *>
        ThreadF.TxnAbort();
        RAISE NotFound;
      | Opened =>
        PStore.abort(tr.id);               <* NOWARN *>
        ThreadF.TxnAbort();
        RAISE Opened;
      END;
      PStore.commit(tr.id);                  <* NOWARN *>
      ThreadF.TxnCommit();
      EVAL dbs.put(name, db);
    END;
    RETURN db;
  END Open;


BEGIN
END Database.
