INTERFACE SHerror;

CONST
  SH_AlreadyInitialized    = 16_11110000; (* OC already initialized *)
  SH_NotInitialized        = 16_11110001; (* OC not intialized *)
  SH_OptionsNotInitialized = 16_11110002; (* Options not called yet *)
  SH_BadObject             = 16_11110003; (* Invalid object *)
  SH_ReadOnly              = 16_11110004; (* Object not writable *)
  SH_BadWRef               = 16_11110005; (* Cannot perform update() *)
  SH_BadAssignment         = 16_11110006; (* Cannot perform assignment *)
  SH_BadVolume             = 16_11110007; (* Invalid volume *)
  SH_BadPool               = 16_11110008; (* Invalid pool *)
  SH_BadType               = 16_11110009; (* Invalid type *)
  SH_BadLockMode           = 16_1111000a; (* Invalid lock mode *)
  SH_NotAPool              = 16_1111000b; (* Object is not a pool *)
  SH_NotADir               = 16_1111000c; (* Object is not a directory *)
  SH_ScanAlreadyOpen       = 16_1111000d; (* Scan is already open *)
  SH_ScanNotOpen           = 16_1111000e; (* Scan is not open *)
  SH_EndOfScan             = 16_1111000f; (* Reached EOF in scan *)
  SH_ScanBufTooSmall       = 16_11110010; (* Buffer provided is too small *)
  SH_OutOfMemory           = 16_11110011; (* Out of memory *)
  SH_TxNotAllowed          = 16_11110012; (* Not allowed in a transaction *)
  SH_TxRequired            = 16_11110013; (* Transaction required to perform *)
  SH_TxAborted             = 16_11110014; (* The transaction was aborted *)
  SH_NotFound              = 16_11110015; (* The named object was not found *)
  SH_Already               = 16_11110016; (* Operation was already performed *)
  SH_ROFailure             = 16_11110017; (* Failure in remote operation *)
  SH_Internal              = 16_11110018; (* Object cache internal error *)
  SH_NoIndex               = 16_11110019; (* Object with no indexes *)
  SH_NoSuchIndex           = 16_1111001a; (* Index operation on non-index *)
  SH_DuplicateEntry        = 16_1111001b; (* Operation causes duplicate *)

  Min = SH_AlreadyInitialized;
  Max = SH_DuplicateEntry;
  
END SHerror.
