#line 1001 "../c/../book/symbols.nw"
/* C compiler: symbol table management */

#line 1035 "../c/../book/symbols.nw"
#include "c.h"

#line 204 "../c/../book/symbols.nw"
struct entry {		/* symbol table entry: */
	struct symbol sym;	/* the symbol */
	List refs;		/* list form of sym.uses (omit) */
	struct entry *link;	/* next entry on hash chain */
};

#line 211 "../c/../book/symbols.nw"
struct table {		/* symbol tables: */
	int level;		/* scope level for this table */
	struct table *previous;	/* table for previous scope */
	Symbol list;		/* list of entries via up fields */
	struct entry *buckets[HASHSIZE];
};
#line 235 "../c/../book/symbols.nw"
static struct table
	tconstants =   { CONSTANTS },
	texternals =   { GLOBAL },
	tidentifiers = { GLOBAL },
	ttypes =       { GLOBAL };
Table constants	  = &tconstants;	/* constants */
Table externals	  = &texternals;	/* externals */
Table identifiers = &tidentifiers;	/* identifiers */
Table globals	  = &tidentifiers;	/* globals */
Table labels[2];			/* labels */
Table types	  = &ttypes;		/* types */
#line 1041 "../c/../book/symbols.nw"
	
int bnumber;				/* current block number */
int level;				/* current block level */
List symbols;				/* list of all symbols; used only if xref != 0 */

#line 579 "../c/../book/symbols.nw"
static struct temporary {/* temporaries: */
	Symbol sym;		/* pointer to the symbol */
	struct temporary *link;	/* next available temporary */
} *temps;		/* list of available temporaries */

#line 1048 "../c/../book/symbols.nw"
/* constant - install and return constant v of type ty */
#line 485 "../c/../book/symbols.nw"
Symbol constant(ty, v) Type ty; Value v; {
	struct entry *p;
	unsigned h = v.u&(HASHSIZE-1);

	ty = unqual(ty);
	for (p = constants->buckets[h]; p; p = p->link)
		if (ty == p->sym.type)
			
#line 523 "../c/../book/symbols.nw"
switch (ty->op) {
case CHAR:     if (v.uc == p->sym.u.c.v.uc) return &p->sym; break;
case SHORT:    if (v.ss == p->sym.u.c.v.ss) return &p->sym; break;
case INT:      if (v.i  == p->sym.u.c.v.i)  return &p->sym; break;
case UNSIGNED: if (v.u  == p->sym.u.c.v.u)  return &p->sym; break;
case FLOAT:    if (v.f  == p->sym.u.c.v.f)  return &p->sym; break;
case DOUBLE:   if (v.d  == p->sym.u.c.v.d)  return &p->sym; break;
case ARRAY: case FUNCTION:
case POINTER:  if (v.p  == p->sym.u.c.v.p)  return &p->sym; break;
default: assert(0);
}
#line 493 "../c/../book/symbols.nw"
	p = (struct entry *) alloc(sizeof *p);
	BZERO(&p->sym, struct symbol);
	p->sym.name = vtoa(ty, v);
	p->sym.scope = CONSTANTS;
	p->sym.type = ty;
	p->sym.class = STATIC;
	p->sym.u.c.v = v;
	p->link = constants->buckets[h];
	p->sym.up = constants->list;
	constants->list = &p->sym;
	constants->buckets[h] = p;
	p->refs = 0;	/* (omit) */
	defsymbol(&p->sym);
	return &p->sym;
}

#line 1051 "../c/../book/symbols.nw"
/* enterscope - enter a scope */
#line 307 "../c/../book/symbols.nw"
void enterscope() {
	if (++level >= USHRT_MAX)
		error("compound statements nested too deeply\n");
}

#line 1054 "../c/../book/symbols.nw"
/* exitscope - exit a scope */
#line 314 "../c/../book/symbols.nw"
void exitscope() {
	rmtypes();
	rmtemps(0, level);
	if (identifiers->level == level) {
		
#line 340 "../c/../book/symbols.nw"
if (Aflag >= 2) {
	int n = 0;
	Symbol p;
	for (p = identifiers->list; p && p->scope == level; p = p->up)
		if (++n > 127) {
			warning("more than 127 identifiers declared in a block\n");
			break;
		}
}
#line 319 "../c/../book/symbols.nw"
		if (xref)	/* (omit) */
			setuses(identifiers);	/* (omit) */
		identifiers = identifiers->previous;
	}
	if (types->level == level) {
		if (xref) {	/* (omit) */
			foreach(fielduses, types, level);	/* (omit) */
			setuses(types);	/* (omit) */
		}	/* (omit) */
		types = types->previous;
	}
	assert(level >= GLOBAL);
	--level;
}

#line 1057 "../c/../book/symbols.nw"
/* fielduses - convert use lists for fields in type p */
void fielduses(p) Symbol p; {
	if (p->type && isstruct(p->type) && p->u.s.ftab)
		setuses(p->u.s.ftab);
}

/* findlabel - lookup/install label lab in the labels table */
#line 433 "../c/../book/symbols.nw"
Symbol findlabel(lab) {
	char *label = stringd(lab);
	Symbol p;

	if (p = lookup(label, labels[1]))
		return p;
	p = install(label, &labels[1], 0);
	p->generated = 1;
	p->u.l.label = lab;
	p->u.l.equatedto = p;
	defsymbol(p);
	return p;
}

#line 1066 "../c/../book/symbols.nw"
/* findtype - find type ty in identifiers */
Symbol findtype(ty) Type ty; {
	Table tp = identifiers;
	int i;
	struct entry *p;

	assert(tp);
	do
		for (i = 0; i < HASHSIZE; i++)
			for (p = tp->buckets[i]; p; p = p->link)
				if (p->sym.type == ty && p->sym.class == TYPEDEF)
					return &p->sym;
	while (tp = tp->previous);
	return 0;
}

/* foreach - call f(p) for each entry p in table tp */
#line 271 "../c/../book/symbols.nw"
void foreach(f, tp, lev) dclproto(void (*f),(Symbol)) Table tp; {
	assert(tp);
	while (tp && tp->level > lev)
		tp = tp->previous;
	if (tp && tp->level == lev) {
		Symbol p;
		Coordinate sav;
		sav = src;
		for (p = tp->list; p && p->scope == lev; p = p->up) {
			src = p->src;
			(*f)(p);
		}
		src = sav;
	}
}

#line 1085 "../c/../book/symbols.nw"
/* genident - create an identifier with class `class', type ty at scope lev */
#line 555 "../c/../book/symbols.nw"
Symbol genident(class, ty, lev) Type ty; {
	Symbol p;

	if (lev <= PARAM)
		p = (Symbol) alloc(sizeof *p);
	else
		p = (Symbol) talloc(sizeof *p);
	BZERO(p, struct symbol);
	p->name = stringd(genlabel(1));
	p->scope = lev;
	p->class = class;
	p->type = ty;
	p->generated = 1;
	if (lev < PARAM)
		defsymbol(p);
	return p;
}

#line 1088 "../c/../book/symbols.nw"
/* genlabel - generate n local labels, return first one */
#line 412 "../c/../book/symbols.nw"
int genlabel(n) {
	static int label = 1;

	label += n;
	return label - n;
}

#line 1091 "../c/../book/symbols.nw"
/* install - install name in table *tp; permanently allocate entry iff perm!=0 */
#line 358 "../c/../book/symbols.nw"
Symbol install(name, tpp, perm) char *name; Table *tpp; {
	struct entry *p;
	unsigned h = (unsigned)name&(HASHSIZE-1);

	if ((tpp == &identifiers || tpp == &types) && (*tpp)->level < level)
		*tpp = table(*tpp, level);
	if (perm)
		p = (struct entry *) alloc(sizeof *p);
	else
		p = (struct entry *) talloc(sizeof *p);
	BZERO(&p->sym, struct symbol);
	p->sym.name = name;
	p->sym.scope = (*tpp)->level;
	p->sym.up = (*tpp)->list;
	(*tpp)->list = &p->sym;
	p->link = (*tpp)->buckets[h];
	(*tpp)->buckets[h] = p;
	p->refs = 0;	/* (omit) */
	return &p->sym;
}

#line 1094 "../c/../book/symbols.nw"
/* intconst - install and return integer constant n */
#line 538 "../c/../book/symbols.nw"
Symbol intconst(n) {
	Value v;

	v.i = n;
	return constant(inttype, v);
}

#line 1097 "../c/../book/symbols.nw"
/* locus - append (table, cp) to the evolving loci and symbol tables lists */
void locus(tp, cp) Table tp; Coordinate *cp; {
	extern List loci, tables;

	loci = append((Generic)cp, loci);
	tables = append((Generic)tp->list, tables);
}

/* lookup - lookup name in table tp, return pointer to entry */
#line 390 "../c/../book/symbols.nw"
Symbol lookup(name, tp) char *name; Table tp; {
	struct entry *p;
	unsigned h = (unsigned)name&(HASHSIZE-1);

	assert(tp);
	do
		for (p = tp->buckets[h]; p; p = p->link)
			if (name == p->sym.name)
				return &p->sym;
	while (tp = tp->previous);
	return 0;
}

#line 1108 "../c/../book/symbols.nw"
/* newconst - install and return constant n with type tc */
Symbol newconst(v, tc) Value v; {
	static Type *btot[] = { 0, &floattype, &doubletype, &chartype,
		&shorttype, &inttype, &unsignedtype, &voidptype };

	assert(tc > 0 && tc < sizeof btot/sizeof btot[0]);
	return constant(*btot[tc], v);
}

/* newtemp - back-end interface to temporary (see below) */
#line 642 "../c/../book/symbols.nw"
Symbol newtemp(class, tc) {
	Symbol t1;
	static Type *btot[] = { 0, &floattype, &doubletype, &chartype,
		&shorttype, &inttype, &unsignedtype, &voidptype };

	assert(tc > 0 && tc < sizeof btot/sizeof btot[0]);
	t1 = temporary(class, *btot[tc]);
	t1->scope = LOCAL;
	if (t1->defined == 0) {
		local(t1);
		t1->defined = 1;
	}
	return t1;
}

#line 1120 "../c/../book/symbols.nw"
/* release - release a temporary for re-use */
#line 626 "../c/../book/symbols.nw"
void release(t1) Symbol t1; {
	if (t1->ref) {
		struct temporary *p = (struct temporary *) talloc(sizeof *p);
		p->sym = t1;
		p->link = temps;
		temps = p;
		t1->ref = 0;
	}
}

#line 1123 "../c/../book/symbols.nw"
/* rmtemps - remove temporaries at scope `level' or with `class' */
#line 611 "../c/../book/symbols.nw"
void rmtemps(class, level) {
	struct temporary *p, **q = &temps;

	for (p = *q; p; p = *q)
		if (p->sym->scope == level || p->sym->class == class)
			*q = p->link;
		else
			q = &p->link;
}

#line 1126 "../c/../book/symbols.nw"
/* setuses - convert p->refs to p->uses for all p at the current level in *tp */
void setuses(tp) Table tp; {
	if (xref) {
		int i;
		struct entry *p;
		for (i = 0; i < HASHSIZE; i++)
			for (p = tp->buckets[i]; p; p = p->link) {
				if (p->refs)
					p->sym.uses = (Coordinate **)ltoa(p->refs, 0);
				p->refs = 0;
				symbols = append((Generic)&p->sym, symbols);
			}
	}
}

/* table - create a new table with predecessor tp, scope lev */
#line 254 "../c/../book/symbols.nw"
Table table(tp, lev) Table tp; {
	int i;
	Table new = (Table)talloc(sizeof *new);

	assert(lev > GLOBAL || lev == LABELS);
	new->previous = tp;
	new->level = lev;
	new->list = tp ? tp->list : 0;	/* (omit) */
	for (i = 0; i < HASHSIZE; i++)
		new->buckets[i] = 0;
	return new;
}

#line 1144 "../c/../book/symbols.nw"
/* temporary - create temporary with class `class', type ty */
#line 585 "../c/../book/symbols.nw"
Symbol temporary(class, ty) Type ty; {
	Symbol t1;
	struct temporary *p, **q = &temps;

	for (p = *q; p; q = &p->link, p = *q)
		if (p->sym->class == class
		&& p->sym->type->size  == ty->size
		&& p->sym->type->align >= ty->align) {
			*q = p->link;
			p->sym->type = ty;
			return p->sym;
		}
	t1 = genident(class, ty, level);
	t1->temporary = 1;
	return t1;
}

#line 1147 "../c/../book/symbols.nw"
/* use - add src to the list of uses for p */
void use(p, src) Symbol p; Coordinate src; {
	if (xref) {
		Coordinate *cp = (Coordinate *)alloc(sizeof *cp);
		*cp = src;
		((struct entry *)p)->refs = append((Generic)cp, ((struct entry *)p)->refs);
	}
}
