(* Copyright (C) 1994, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)
(* Last modified on Fri Feb 25 14:22:24 PST 1994 by kalsow    *)
(*      modified on Tue Nov 30 23:33:48 PST 1993 by heydon    *)
(*      modified on Wed Oct  6 09:09:31 PDT 1993 by mcjones   *)
(*      modified on Mon Feb 15 14:17:17 PST 1993 by ramshaw   *)
(*      modified on Sun Jun  3 14:25:23 PST 1991 by luca      *)

(* HISTORY
 * 19-Dec-95  Brian Bershad (bershad) at the University of Washington
 *	Removed REAL reliance for kernel services.
 *
 *)

(* The "Scan" interface provides procedures for reading strings,
   booleans, integers, and floating-point numbers from a text string.
   Similar functionality on readers is availble from the "Lex"
   interface. *)

INTERFACE Scan;

IMPORT Word, Lex;

(*, FloatMode;*)

(* Each of these procedures parses a string of characters and converts
   it to a binary value.  Leading and trailing blanks (ie. characters
   in "Lex.Blanks") are ignored.  "Lex.Error" is raised if the first
   non-blank substring is not generated by the corresponding "Lex"
   grammar or if there are zero or more than one non-blank substrings.
   "FloatMode.Trap" is raised as per "Lex". *)

PROCEDURE Bool(txt: TEXT): BOOLEAN
  RAISES {Lex.Error};

PROCEDURE Int(txt: TEXT; defaultBase: [2..16] := 10): INTEGER
  RAISES {Lex.Error, (*FloatMode.Trap*)};
PROCEDURE Unsigned(txt: TEXT; defaultBase: [2..16] := 16): Word.T
  RAISES {Lex.Error (*, FloatMode.Trap*)};

(*
PROCEDURE Real(txt: TEXT): REAL
  RAISES {Lex.Error, FloatMode.Trap};
PROCEDURE LongReal(txt: TEXT): LONGREAL
  RAISES {Lex.Error, FloatMode.Trap};
PROCEDURE Extended(txt: TEXT): EXTENDED 
  RAISES {Lex.Error, FloatMode.Trap};
*)


END Scan.
