/*
 * Copyright 1994, 1995 University of Washington
 * All rights reserved.
 * See COPYRIGHT file for a full description
 *
 * SYMBOLS FOR SPIN TRUSTED.  (This file should go away...)
 *
 * HISTORY
 * 31-May-97  David Becker at the University of Washington
 *	Renamed SpinTrusted.h to trusted_symbols.h
 *	Exports addresses of underlying kernel code via kernel_symbols.c
 *
 # 28-May-96  David Becker (becker) at the University of Washington
 # 	Removed symbols from mips_dummy.c.  They are now in the osf.cam	domain
 *
 * 21-Apr-96  Stefan Savage (savage) at the University of Washington
 *	Changed osf_{un}timeout to {un}timeout
 *
 * 19-Apr-96  Emin Gun Sirer (egs) at the University of Washington
 *	spin_swap_ipl -> SpinSwapIpl
 *
 * 03-Apr-96  Marc Fiuczynski (mef) at the University of Washington
 *    Changed max_linkhdr, max_protohdr and mbstat from TEXT to DATA.
 *
 * 2-Apr-96 oystr at the University of Washington
 *	Added ws* entries.  See "for X".
 *
 * 21-Feb-96  Marc Fiuczynski (mef) at the University of Washington
 *	Added ulock interface to be used by the Digital Unix C code that
 *	we borrow.
 *
 * 19-Feb-96  Marc Fiuczynski (mef) at the University of Washington
 *	Added ifnet, if_index and if_attach_upcall symbols for
 *	networking.  Also added wakeup_one symbol for Digital Unix.
 *	Moved bcopy, memset and memmove to SpinPublic.h.
 *
 * 21-Dec-95  Charles Garrett (garrett) at the University of Washington
 *	Added subfree
 *
 * 11-Oct-95  Marc Fiuczynski (mef) at the University of Washington
 *	Removed the modula3 symbols, which are now generated by the
 *	m3build domain management support.
 *
 * 06-Aug-95  Brian Bershad (bershad) at the University of Washington
 *	Added syms for CAM, and file_io.
 * 
 */
TEXT(spin_malloc)
TEXT(spin_free)
TEXT(Debugger)
TEXT(printf)
TEXT(sprintf)
TEXT(strcpy)
TEXT(strcmp)
TEXT(bzero)
TEXT(timeout)
TEXT(untimeout)

/* fb.dl */
TEXT(strncmp)
TEXT(copyin)
TEXT(panicstr)
TEXT(tick)
TEXT(hz)
TEXT(ffs)

/* console */
TEXT(cnioctl)
TEXT(cnread)
TEXT(cnwrite)
TEXT(cnopen)
TEXT(cnclose)
TEXT(cnselect) /* for FreeBSD */

TEXT(ttselect) /* for OSF1 */

/* ln.dl */
TEXT(kmem_alloc)
TEXT(kmem_free)
TEXT(ether_sprintf)
TEXT(bcmp)
TEXT(panic)
TEXT(malloc)
TEXT(free)
TEXT(kernel_map)
TEXT(time)
TEXT(cpu)

/* thread control */
TEXT(wakeup)

#ifdef notyet
/* myri device */
DATA(DBLOCK)
DATA(DLANAI)
DATA(LANAI)
DATA(LANAI3)
DATA(LANAI_CONTROL)
DATA(LANAI_EEPROM)
DATA(LANAI_SPECIAL)
DATA(UBLOCK)
TEXT(myrilanaiioctl)
TEXT(serimyrimem)
TEXT(myriApiLoadLanai)
TEXT(myriApiSetDebugVariable)
TEXT(myriApiSetInterruptMask)
TEXT(myriApiSetDebugVariable)
TEXT(myriApiSetAddress)
TEXT(myriApiSetBurst)
TEXT(lanai_board_type)
TEXT(lanai_get_board_id)
TEXT(lanai_interrupt_unit)
TEXT(lanai_put)
TEXT(lanai_reset_unit)
#endif 

TEXT(dumplog)
TEXT(plog)
TEXT(plogi)
TEXT(plogx)

/* interrupts */
TEXT(RestoreInterruptMask)
TEXT(SetInterruptMask)

/* shell */
TEXT(set_member)
TEXT(set_difference)

/* URT */
DATA(mbstat)
DATA(sal_mbuf_free)
DATA(mfreelater)
TEXT(m_free)
TEXT(m_freem)
TEXT(m_length)
TEXT(m_copydata)
TEXT(m_copym)
TEXT(m_get)
TEXT(m_getclr)
TEXT(m_gethdr)
TEXT(m_prepend)
TEXT(m_pullup)
TEXT(m_leadingspace)

TEXT(in_cksum)



#ifdef __FreeBSD__

/* myri device */ /* Not currently supported */
/* DATA(myris) */

DATA(curproc)
DATA(bdevsw)
DATA(dc_list)
TEXT(geteblk)
TEXT(brelse)
TEXT(biowait)

/* for osf.tcp */
TEXT(splz)
TEXT(ipending)
TEXT(cpl)
TEXT(net_imask)
TEXT(mbtypes)
/* TEXT(mclrefcnt) */ /* Removed (DEC-OSF REF COUNTing) */
TEXT(mbutl)
TEXT(m_retry)
TEXT(psignal)
TEXT(pfind)
TEXT(selwakeup)
TEXT(uiomove)
TEXT(m_clalloc)
TEXT(m_retryhdr)
TEXT(phashinit)
TEXT(memcpy)
TEXT(m_adj)
TEXT(suser)

/* for Exec */
DATA(_ucodesel)
DATA(_udatasel)

/* for Exec */
DATA(_ucodesel)
DATA(_udatasel)
#endif /* __FreeBSD__ */

/* for salnet */
TEXT(strncpy)
DATA(kmembuckets)
#ifdef __FreeBSD__
DATA(mclfree)
#endif /* __FreeBSD__ */
DATA(max_linkhdr)
DATA(max_protohdr)

TEXT(salnfs_mount)
TEXT(salnfs_fetch)
TEXT(salnet_begin)
TEXT(salnet_end)
TEXT(salnet_arp)
TEXT(salnet_bootp)
TEXT(salnet_setipaddr)
TEXT(salnet_getipaddr)
TEXT(salnet_getetheraddr)
TEXT(salnet_getlocalroute)
#ifdef __FreeBSD__
TEXT(saldns_query)
#endif /* __FreeBSD__ */
TEXT(saltftp_fetch)
DATA(salnet_pollq)
DATA(salnet_debug)

TEXT(salnet_devsend)
TEXT(salnet_devrecv)
TEXT(salnet_udpmine)
TEXT(salnet_ipmine)
TEXT(salnet_ipfrag)
TEXT(salnet_ethermine)
TEXT(salnet_udploop)
TEXT(salnet_udpsend)
TEXT(salnet_perror)
TEXT(salnet_ether_packet)
TEXT(xdrprintf)
TEXT(rpclookup)
TEXT(ttd_ether_packet)
TEXT(arpd_ether_packet)

#ifdef __FreeBSD__
DATA(mono_time)
#endif /* __FreeBSD__ */
TEXT(cyclecounter)

#ifdef OSF
TEXT(__divl)
TEXT(__divlu)
TEXT(assert_wait_mesg)
TEXT(copyin_try)
TEXT(getspl)
TEXT(imin)
TEXT(in_checksum)
TEXT(insque)
TEXT(max)
TEXT(min)
TEXT(mpsleep)
TEXT(remque)
TEXT(select_dequeue)
TEXT(select_enqueue)
TEXT(select_wakeup)
TEXT(swap_ipl)
TEXT(swap_ipl_preempt_check)
TEXT(wakeup_one)
TEXT(index)
TEXT(cycleminus)
TEXT(hertz)

TEXT(m_adj)
TEXT(m_clalloc2)
TEXT(m_clalloc8)
TEXT(m_clalloc)
TEXT(m_copydata)
TEXT(m_copym)
TEXT(m_free)
TEXT(m_freem)
TEXT(m_get)
TEXT(m_getclr)
TEXT(m_gethdr)
TEXT(m_leadingspace)
TEXT(m_length)
TEXT(m_prepend)
TEXT(m_pullup)
TEXT(m_retry)
TEXT(m_retryhdr)

/* autoconf */
TEXT(system_bus)
TEXT(nulldev)
TEXT(bus_list)
TEXT(controller_list)
TEXT(device_list)
TEXT(tcconfl1)
TEXT(tcconfl2)
TEXT(pciconfl1)
TEXT(pciconfl2)
TEXT(isaconfl1)
TEXT(isaconfl2)
TEXT(conn_ctlr_hook)
TEXT(conn_device_hook)

/* cam and osf.cam */
TEXT(__remlu)
TEXT(__remq)
TEXT(__remqu)
TEXT(boot_protocol_reg)
TEXT(cold)
TEXT(conn_ctlr)
TEXT(conn_device)
TEXT(copyout)
TEXT(current_proc)
TEXT(current_task)
TEXT(current_thread)
TEXT(dequeue_head)
TEXT(dma_get_next_sgentry)
TEXT(dma_get_private)
TEXT(dma_map_load)
TEXT(dma_map_unload)
TEXT(dma_put_private)
TEXT(drvr_register_shutdown)
TEXT(dumpsize)
TEXT(enqueue_tail)
TEXT(get_ctlr)
TEXT(get_info)
TEXT(handler_add)
TEXT(handler_enable)
TEXT(iohandle_to_phys)
TEXT(itoa)
TEXT(kalloc)
TEXT(kernel_thread)
TEXT(ldbl_find_bus)
TEXT(ldbl_find_ctlr)
TEXT(lock_done)
TEXT(lock_setup)
TEXT(lock_try_write)
TEXT(lock_write)
TEXT(log)
TEXT(mb)
TEXT(microdelay)
TEXT(microtime)
TEXT(pci_config_cont)
TEXT(perf_init)
TEXT(pmap_dup)
TEXT(pmap_extract)
TEXT(pmap_svatophys)
TEXT(printstate)
TEXT(prom_getenv)
TEXT(read_io_port)
TEXT(rootdev)
TEXT(shutting_down)
TEXT(sleep)
TEXT(strlen)
TEXT(tc_addr_to_name)
TEXT(tc_config_cont)
TEXT(tc_enable_option)
TEXT(tc_isolate_memerr)
TEXT(tc_option_control)
TEXT(tc_slot)
TEXT(tc_slot_to_name)
TEXT(tc_slotaddr)
TEXT(thread_block)
TEXT(thread_wakeup)
TEXT(thread_wakeup_prim)
TEXT(u)
TEXT(useracc)
TEXT(write_io_port)
TEXT(zalloc)
TEXT(zcram)
TEXT(zfree)
TEXT(zget)
TEXT(zinit)

/* unix reader/writer locking support */
TEXT(ulock_setup)
TEXT(ulock_terminate)
TEXT(ulock_write)
TEXT(ulock_read)
TEXT(ulock_done)
TEXT(ulock_try_write)
TEXT(ulock_try_read)
TEXT(ulock_set_recursive)
TEXT(ulock_clear_recursive)

/* ws device */
TEXT(wsopen)
TEXT(wsclose)
TEXT(wsread)
TEXT(wswrite)
TEXT(wsioctl)
TEXT(wsselect)

#endif

#ifdef __FreeBSD__
TEXT(selrecord)
TEXT(selwakeup)
TEXT(tsleep)

#endif
