% top-level bootstrap installation 

% HISTORY
% 16-Jul-97  Tian Fung Lim (tian) at the University of Washington
%	Added writebarrier platform
%
% 25-Sep-96  Marc Fiuczynski (mef) at the University of Washington
%	Added SPINCOMMON template file.
%
% 05-May-96  Charles Garrett (garrett) at the University of Washington
%	Ship the new ALPHA_SPIN_PROF template.
%
% 22-Feb-96  Charles Garrett (garrett) at the University of Washington
%	Install the ALPHA_SPIN template.
%

 
readonly MAN1_DIR = MAN_INSTALL & "/man1"
readonly TMPL_DIR  = PKG_INSTALL & "/m3build/templates"
 
proc mkdir (d) is exec ("@m3build/" & LOCALTARGET  &"/m3mkdir", d) end

write ("top is ", TOP_ROOT, CR)

mkdir (BIN_INSTALL)
mkdir (LIB_INSTALL)
mkdir (MAN1_DIR)
mkdir (TMPL_DIR)

INSTALL_ROOT_TMPL = TMPL_DIR & "/INSTALL_ROOT"
QINSTALL_ROOT = "\"" & TOP_ROOT & "\""

 
proc install_bin(f) is install_file(f, BIN_INSTALL, "0755") end
proc install_lib(f) is install_file(f, LIB_INSTALL, "0755") end
proc install_man(f) is install_file(f, MAN1_DIR, "0644") end
proc install_tmp(f) is install_file(f, TMPL_DIR, "0644") end
 
install_bin("m3build/" & LOCALTARGET & "/m3build")
install_bin("m3build/" & LOCALTARGET & "/m3ship")
install_bin("m3build/" & LOCALTARGET & "/m3where")
install_lib("m3build/" & LOCALTARGET & "/m3mkdir")
 

install_tmp("m3build/templates/CLEANUP")
install_tmp("m3build/templates/COMMON")
install_tmp("m3build/templates/COMMON.BOOT")
install_tmp("m3build/templates/PLATFORMS")
install_tmp("m3build/templates/POSIX")
install_tmp("m3build/templates/WIN32")
install_tmp("m3build/templates/SPIN")

% Install INSTALL ROOT
install_tmp("m3build/templates/LINUXELF")
install_tmp("m3build/templates/ALPHA_OSF")
install_tmp("m3build/templates/ALPHA_OSF_HACK")
install_tmp("m3build/templates/ALPHA_OSF_REF")
% install_tmp("m3build/templates/ALPHA_OSF_WB")
install_tmp("m3build/templates/SPINCOMMON")
install_tmp("m3build/templates/IX86_SPIN")
install_tmp("m3build/templates/IX86_SPIN_PROF")
install_tmp("m3build/templates/ALPHA_SPIN")
install_tmp("m3build/templates/ALPHA_SPIN_HACK")
install_tmp("m3build/templates/ALPHA_SPIN_REF")
install_tmp("m3build/templates/ALPHA_SPIN_WB")
install_tmp("m3build/templates/ALPHA_SPIN_PROF")
install_tmp("m3build/templates/ALPHA_SPIN_PROF_REF")
exec("echo '# This file automatically generated by m3ship.boot' >", INSTALL_ROOT_TMPL)
exec("echo 'INSTALL_ROOT = ", QINSTALL_ROOT, "' >> ", INSTALL_ROOT_TMPL)

 
install_man("m3build/" & LOCALTARGET & "/m3build.1")
install_man("m3build/" & LOCALTARGET & "/m3ship.1")
install_man("m3build/" & LOCALTARGET & "/m3where.1")
 
install_bin("quake/" & LOCALTARGET & "/quake")
install_man("quake/src/quake.1")
 
