(*
 * Copyright 1994, 1995 University of Washington
 * All rights reserved.
 * See COPYRIGHT file for a full description
 *)
(*
 * HISTORY
 * 03-Nov-95  Yasushi Saito (yasushi) at the University of Washington
 *	created.
 *)
MODULE ExtensionI3;
IMPORT Fmt, IO, Rd, IWr;
IMPORT Msg;
IMPORT Text;
IMPORT Module;

VAR templateRd : Rd.T;

(* Copy contents of TEMPLATE_FILE into S until '@' is found at the
 *  beginning of line. *)
PROCEDURE CopyTemplateTillMarker(src : Rd.T; dest : IWr.T) =
VAR line : TEXT;
BEGIN
  TRY 
    LOOP
      line := IO.GetLine(src);
      IF (line = NIL OR
	  (Text.Length(line) >= 1 AND Text.GetChar(line, 0) = '@')) THEN
	EXIT;
      END;
      dest.put(line, "\n");
    END;
  EXCEPT
  | IO.Error => (* ignore I/O error *)
  END;
END CopyTemplateTillMarker;
    
PROCEDURE Output(READONLY m : Module.T) =
VAR wr := IWr.OpenWrite(m.intf&"Extension.i3");
BEGIN
  templateRd := IO.OpenRead(templateFile & ".i3");
  IF templateRd = NIL THEN
    Msg.Fatal(Msg.POS_VOID, templateFile & ".i3 : can't open.\n");
  ELSE
    Msg.Verbose(Msg.POS_VOID, "opening template file "&templateFile&".i3\n");
  END;
  
  wr.put(
"(* This file is produced by stubgen. Please do not edit this file directly.\n"
	 &"  Instead, kick yasushi@cs. *)\n", 
"INTERFACE "& m.intf & "Extension;\n");

  CopyTemplateTillMarker(templateRd, wr);
  IF m.domain # NIL THEN
      wr.put("CONST Domain_ = \"", m.domain, "\";\n");
  END;
  wr.put("CONST MinProcID = ", Fmt.Int(m.minProcID), ";\n");
  wr.put("CONST MaxProcID = ", Fmt.Int(m.maxProcID), ";\n");
  
  wr.put("END ",m.intf,"Extension.\n");
  wr.close();
END Output;

BEGIN
END ExtensionI3.
