(*
 * Copyright 1994, 1995 University of Washington
 * All rights reserved.
 * See COPYRIGHT file for a full description
 *
 *
 * HISTORY
 * 31-May-97  David Becker at the University of Washington
 *      Replace SAL with Kernel and MachineCPU interfaces
 *
 * 19-Sep-96  Wilson Hsieh (whsieh) at the University of Washington
 *	make guards FUNCTIONAL
 *
 * 20-May-96  Przemek Pardyak (pardy) at the University of Washington
 *	Changed the dispatcher interface.
 *
 * 31-Oct-95  Wilson Hsieh (whsieh) at the University of Washington
 *	converted all used REF PROCEDURE to PROCEDURE
 *      commented out unused PROCEDUREs
 *
 * 05-Oct-95  Emin Gun Sirer (egs) at the University of Washington
 *	Got rid of all warnings generated by this file.
 *
 * 12-Aug-95  Przemek Pardyak (pardy) at the University of Washington
 *	Created
 *)

UNSAFE MODULE DispTime;
IMPORT Fmt;
IMPORT Sirpa, Dispatcher, DispatcherPrivate;
IMPORT CPU, RTCollector, Spy, ThreadExtra;
IMPORT ParseParams, IO;

CONST 
  CYC = 133;

<* FATAL Dispatcher.Error *>

CONST MAX_ITER = 1000;

CONST a0 = TRUE;
CONST a1 = TRUE;
CONST a2 = FALSE;
CONST a3 = FALSE;
CONST a4 = FALSE;
CONST a5 = TRUE;
CONST a6 = FALSE;
CONST aA = FALSE;

CONST do_handle = ARRAY OF BOOLEAN{ FALSE, (* 0 *)
                                    TRUE, (* 1 *)
                                    FALSE, (* 2 *)
                                    FALSE, (* 3 *)
                                    FALSE, (* 4 *)
                                    TRUE, (* 5 *)
                                    FALSE, (* 6 *)
                                    FALSE, (* 7 *)
                                    FALSE, (* 8 *)
                                    FALSE, (* 9 *)
                                    TRUE, (* 10 *)
                                    FALSE (* --- *)
  };


(*
CONST a0 = TRUE;
CONST a1 = TRUE;
CONST a2 = TRUE;
CONST a3 = TRUE;
CONST a4 = TRUE;
CONST a5 = TRUE;
CONST a6 = TRUE;
CONST aA = TRUE;

CONST do_handle = ARRAY OF BOOLEAN{ TRUE, (* 0 *)
                                    TRUE, (* 1 *)
                                    TRUE, (* 2 *)
                                    TRUE, (* 3 *)
                                    TRUE, (* 4 *)
                                    TRUE, (* 5 *)
                                    TRUE, (* 6 *)
                                    TRUE, (* 7 *)
                                    TRUE, (* 8 *)
                                    TRUE, (* 9 *)
                                    TRUE, (* 10 *)
                                    TRUE (* --- *)
  };
*)

VAR tcost : INTEGER := -1;

(*
 * when clauses and handlers
 *)

(*
PROCEDURE WC1 (a1: Sirpa.RRT1; <* UNUSED *>a2: Sirpa.RRT2): BOOLEAN =
  BEGIN
    RETURN a1 = NIL;
  END WC1;

PROCEDURE H1 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    (* IO.Put ( "---> Handler 1 <---\n" );*)
    RETURN NIL;
  END H1;

PROCEDURE WC2 (<* UNUSED *> a1: Sirpa.RRT1; a2: Sirpa.RRT2): BOOLEAN =
  BEGIN
    RETURN a2 = NIL;
  END WC2;

PROCEDURE H2 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    (* IO.Put ( "---> Handler 2 <---\n" );*)
    RETURN NIL;
  END H2;

PROCEDURE WC3 (a1: Sirpa.RRT1; a2: Sirpa.RRT2): BOOLEAN =
  BEGIN
    RETURN a1 = NIL AND a2 = NIL;
  END WC3;

PROCEDURE H3 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    (* IO.Put ( "---> Handler 3 <---\n" );*)
    RETURN NIL;
  END H3;

PROCEDURE WC4 (a1: Sirpa.RRT1; a2: Sirpa.RRT2): BOOLEAN =
  BEGIN
    RETURN a1 # NIL AND a2 = NIL;
  END WC4;

PROCEDURE H4 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    (* IO.Put ( "---> Handler 4 <---\n" );*)
    RETURN NIL;
  END H4;

PROCEDURE WC5 (a1: Sirpa.RRT1; a2: Sirpa.RRT2): BOOLEAN =
  BEGIN
    RETURN a1 # NIL AND a2 = NIL;
  END WC5;

PROCEDURE H5 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    (* IO.Put ( "---> Handler 5 <---\n" );*)
    RETURN NIL;
  END H5;


(*
 * handlers that print
 *)

PROCEDURE PH1 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    IO.Put ( "---> Handler 1 <---\n" );
    RETURN NIL;
  END PH1;

PROCEDURE PH2 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    IO.Put ( "---> Handler 2 <---\n" );
    RETURN NIL;
  END PH2;

PROCEDURE PH3 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    IO.Put ( "---> Handler 3 <---\n" );
    RETURN NIL;
  END PH3;

PROCEDURE PH4 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    IO.Put ( "---> Handler 4 <---\n" );
    RETURN NIL;
  END PH4;

PROCEDURE PH5 (<* UNUSED *> a1: Sirpa.RRT1; <* UNUSED *> a2: Sirpa.RRT2)
  : Sirpa.RRT1 =
  BEGIN
    IO.Put ( "---> Handler 5 <---\n" );
    RETURN NIL;
  END PH5;
*)

(*
 * empty procedures with varying number of arguments
 *)

PROCEDURE E0 () =
  BEGIN
  END E0;

PROCEDURE E1 (<* UNUSED *> a1 : INTEGER) =
  BEGIN
  END E1;

PROCEDURE E2 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER) =
  BEGIN
  END E2;

PROCEDURE E3 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
              <* UNUSED *> a3 : INTEGER) =
  BEGIN
  END E3;

PROCEDURE E4 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER;
              <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER) =
  BEGIN
  END E4;

PROCEDURE E5 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
              <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
              <* UNUSED *> a5 : INTEGER) =
  BEGIN
  END E5;

PROCEDURE E6 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
              <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
              <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER) =
  BEGIN
  END E6;

PROCEDURE EA (<* UNUSED *> a1 : REF ARRAY [1..1024] OF INTEGER) =
  BEGIN
  END EA;

(*
PROCEDURE E7 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
              <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
              <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
              <* UNUSED *> a7 : INTEGER) =
  BEGIN
  END E7;

PROCEDURE E8 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
              <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
              <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
              <* UNUSED *> a7 : INTEGER; <* UNUSED *> a8 : INTEGER) =
  BEGIN
  END E8;

PROCEDURE E9 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
              <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
              <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
              <* UNUSED *> a7 : INTEGER; <* UNUSED *> a8 : INTEGER; 
              <* UNUSED *> a9 : INTEGER) =
  BEGIN
  END E9;

PROCEDURE E10 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
               <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
               <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
               <* UNUSED *> a7 : INTEGER; <* UNUSED *> a8 : INTEGER; 
               <* UNUSED *> a9 : INTEGER; <* UNUSED *> a10 : INTEGER) =
  BEGIN
  END E10;

PROCEDURE PWC0 (): BOOLEAN =
  BEGIN
    IO.Put ("PWC0\n");
    RETURN TRUE;
  END PWC0;
*)


(*
 * empty when clauses
 *)

FUNCTIONAL PROCEDURE WCE0 (): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE0;

FUNCTIONAL PROCEDURE WCE1 (<* UNUSED *> a1 : INTEGER): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE1;

FUNCTIONAL PROCEDURE WCE2 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER
               ): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE2;

FUNCTIONAL PROCEDURE WCE3 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
                <* UNUSED *> a3 : INTEGER): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE3;

FUNCTIONAL PROCEDURE WCE4 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
                <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER
               ): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE4;

FUNCTIONAL PROCEDURE WCE5 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
                <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
                <* UNUSED *> a5 : INTEGER): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE5;

FUNCTIONAL PROCEDURE WCE6 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
                <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
                <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER
               ): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE6;

FUNCTIONAL PROCEDURE WCEA (<* UNUSED *> a1 : REF ARRAY [1..1024] OF INTEGER
               ): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCEA;

(*
FUNCTIONAL PROCEDURE WCE7 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER;
                <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
                <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
                <* UNUSED *> a7 : INTEGER): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE7;

FUNCTIONAL PROCEDURE WCE8 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
                <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
                <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
                <* UNUSED *> a7 : INTEGER; <* UNUSED *> a8 : INTEGER
               ): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE8;

FUNCTIONAL PROCEDURE WCE9 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
                <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
                <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
                <* UNUSED *> a7 : INTEGER; <* UNUSED *> a8 : INTEGER; 
                <* UNUSED *> a9 : INTEGER): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE9;

FUNCTIONAL PROCEDURE WCE10 (<* UNUSED *> a1 : INTEGER; <* UNUSED *> a2 : INTEGER; 
                 <* UNUSED *> a3 : INTEGER; <* UNUSED *> a4 : INTEGER; 
                 <* UNUSED *> a5 : INTEGER; <* UNUSED *> a6 : INTEGER; 
                 <* UNUSED *> a7 : INTEGER; <* UNUSED *> a8 : INTEGER; 
                 <* UNUSED *> a9 : INTEGER; <* UNUSED *> a10 : INTEGER
                ): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END WCE10;
*)

(*
 * test argument passing
 *)

PROCEDURE SetOverhead () =
  VAR
    t1, t2, d, min, max, acc: INTEGER;
  BEGIN
    tcost := 0;
    min := LAST(INTEGER);
    max := FIRST(INTEGER);
    acc := 0;
    t1 := CPU.CycleCounter();
    t2 := CPU.CycleCounter();
    FOR i := 1 TO MAX_ITER DO 
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      d := (t2-t1); 
      min := MIN(min, d);
      max := MAX(max, d);
      acc := acc + d;
    END;
    IO.Put( "\n>>> timer:: " );
    PrintRes(min, max, acc, MAX_ITER);

    t1 := CPU.CycleCounter();
    t2 := CPU.CycleCounter();
    FOR i := 1 TO MAX_ITER DO 
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      d := (t2-t1); 
      min := MIN(min, d);
      max := MAX(max, d);
      acc := acc + d;
    END;
    IO.Put( "\n>>> timer:: " );
    PrintRes(min, max, acc, MAX_ITER);

    t1 := CPU.CycleCounter();
    t2 := CPU.CycleCounter();
    FOR i := 1 TO MAX_ITER DO 
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      d := (t2-t1); 
      min := MIN(min, d);
      max := MAX(max, d);
      acc := acc + d;
    END;
    IO.Put( "\n>>> timer:: " );
    PrintRes(min, max, acc, MAX_ITER);

    min := LAST(INTEGER);
    max := FIRST(INTEGER);
    acc := 0;
    t1 := CPU.CycleCounter();
    t2 := CPU.CycleCounter();
    FOR i := 1 TO MAX_ITER DO 
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      d := (t2-t1); 
      min := MIN(min, d);
      max := MAX(max, d);
      acc := acc + d;
    END;
    IO.Put( "\n>>> timer:: " );
    PrintRes(min, max, acc, MAX_ITER);

    tcost := min;
  END SetOverhead;

VAR 
  acc1, acc2, acc3, acc4, acc5, acc6: INTEGER;

PROCEDURE PrintRes(min, max, acc, n: INTEGER) =
  VAR ave := (((acc-max) DIV (n-1))-tcost);
  BEGIN
    IO.Put("min: " & Fmt.Int(min-tcost) & " max: " & Fmt.Int(max-tcost) &
      " ave: " & Fmt.Int((acc DIV n)-tcost) & " " & Fmt.Int(ave) & " " &
      " res: " & Fmt.Int((((acc-max) DIV (n-1))-tcost)* 1000 DIV CYC) & "\n" );
  END PrintRes;

PROCEDURE DoM3DirProcCall () =
  VAR
    t1, t2, d, min, max, acc: INTEGER;
    arr := NEW(REF ARRAY [1..1024] OF INTEGER);
  BEGIN
    IO.Put ("\n>>> M3 direct call\n");

    IF a0 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      E0();
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        E0();
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "0 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a1 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      E1(acc1);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        E1(acc1);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "1 arg :: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a2 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      E2(acc1,acc2);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        E2(acc1,acc2);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "2 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a3 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      E3(acc1,acc2,acc3);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        E3(acc1,acc2,acc3);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "3 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a4 THEN
      E4(acc1,acc2,acc3,acc4);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        E4(acc1,acc2,acc3,acc4);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "4 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a5 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      E5(acc1,acc2,acc3,acc4,acc5);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        E5(acc1,acc2,acc3,acc4,acc5);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "5 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a6 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      E6(acc1,acc2,acc3,acc4,acc5,acc6);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        E6(acc1,acc2,acc3,acc4,acc5,acc6);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "6 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF aA THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      EA(arr);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        EA(arr);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "A args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
  END DoM3DirProcCall; 

PROCEDURE DoM3IndirProcCall () =
  VAR
    t1, t2, d, min, max, acc: INTEGER;
    arr := NEW(REF ARRAY [1..1024] OF INTEGER);
  BEGIN
    IO.Put ("\n>>> M3 indirect call\n");

    IF a0 THEN
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E0();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E0();
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "0 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a1 THEN
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E1(acc1);
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E1(acc1);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "1 arg :: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a2 THEN
      Sirpa.E2(acc1,acc2);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E2(acc1,acc2);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "2 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a3 THEN
      Sirpa.E3(acc1,acc2,acc3);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E3(acc1,acc2,acc3);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "3 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a4 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E4(acc1,acc2,acc3,acc4);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E4(acc1,acc2,acc3,acc4);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "4 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a5 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E5(acc1,acc2,acc3,acc4,acc5);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E5(acc1,acc2,acc3,acc4,acc5);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "5 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
    
    IF a6 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "6 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF aA THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.EA(arr);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.EA(arr);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "A args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
    IO.Put ("\n>>> M3 indirect call\n");

    IF a0 THEN
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E0();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E0();
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "0 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a1 THEN
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E1(acc1);
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E1(acc1);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "1 arg :: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a2 THEN
      Sirpa.E2(acc1,acc2);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E2(acc1,acc2);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "2 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a3 THEN
      Sirpa.E3(acc1,acc2,acc3);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E3(acc1,acc2,acc3);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "3 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a4 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E4(acc1,acc2,acc3,acc4);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E4(acc1,acc2,acc3,acc4);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "4 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a5 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E5(acc1,acc2,acc3,acc4,acc5);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E5(acc1,acc2,acc3,acc4,acc5);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "5 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
    
    IF a6 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "6 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF aA THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.EA(arr);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.EA(arr);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "A args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
    IO.Put ("\n>>> M3 indirect call\n");

    IF a0 THEN
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E0();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E0();
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "0 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a1 THEN
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E1(acc1);
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E1(acc1);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "1 arg :: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a2 THEN
      Sirpa.E2(acc1,acc2);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E2(acc1,acc2);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "2 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a3 THEN
      Sirpa.E3(acc1,acc2,acc3);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E3(acc1,acc2,acc3);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "3 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a4 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E4(acc1,acc2,acc3,acc4);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E4(acc1,acc2,acc3,acc4);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "4 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a5 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E5(acc1,acc2,acc3,acc4,acc5);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E5(acc1,acc2,acc3,acc4,acc5);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "5 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
    
    IF a6 THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "6 args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF aA THEN
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.EA(arr);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.EA(arr);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "A args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
  END DoM3IndirProcCall;

PROCEDURE DoSynchHandling (nh: INTEGER) =
  VAR
    t1, t2, d, min, max, acc: INTEGER;
    arr := NEW(REF ARRAY [1..1024] OF INTEGER);
  BEGIN
    IO.Put("\n>>> Synch event handling with " & Fmt.Int(nh) & " handlers and ");
    IF NOT guards THEN
      IO.Put(" no ");
    END;
    IO.Put(" guards\n");
    
    IF a0 THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.E0, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on a0: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E0, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E0();
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E0();
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put("0 args:: ");
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a1 THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.E1, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on a1: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E1, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E1(acc);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E1(acc);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put("1 arg :: ");
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a2 THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.E2, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on a2: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E2, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E2(acc,acc);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E2(acc,acc);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put("2 args:: ");
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a3 THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.E3, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on a3: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E3, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E3(acc1,acc2,acc3);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E3(acc1,acc2,acc3);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put("3 args:: ");
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a4 THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.E4, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on a4: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E4, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E4(acc,acc,acc,acc);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E4(acc,acc,acc,acc);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put("4 args:: ");
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF a5 THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.E5, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on a5: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E5, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E5(acc,acc,acc,acc,acc);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E5(acc,acc,acc,acc,acc);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put("5 args:: ");
      PrintRes(min, max, acc, MAX_ITER);
    END;
    
    IF a6 THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.E6, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on a6: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E6, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.E6(acc1,acc2,acc3,acc4,acc5,acc6);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put("6 args:: ");
      PrintRes(min, max, acc, MAX_ITER);
    END;

    IF aA THEN
      IF NUMBER(Dispatcher.GetHandlers(Sirpa.EA, NIL)^) # nh  THEN
        IO.Put("ERROR >>> incorrect number of handlers on aA: " & 
          Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.EA, NIL)^)) &  "\n");
      END;
      t1 := CPU.CycleCounter();
      t2 := CPU.CycleCounter();
      Sirpa.EA(arr);
      min := LAST(INTEGER);
      max := FIRST(INTEGER);
      acc := 0;
      FOR i := 1 TO MAX_ITER DO 
        t1 := CPU.CycleCounter();
        Sirpa.EA(arr);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        min := MIN(min, d);
        max := MAX(max, d);
        acc := acc + d;
      END;
      IO.Put( "A args:: " );
      PrintRes(min, max, acc, MAX_ITER);
    END;
  END DoSynchHandling; 

VAR
  spindles : ARRAY [0..7] OF ARRAY [1..100] OF Dispatcher.Binding;


PROCEDURE DoSynchEventHandle(nh: INTEGER) = 
  BEGIN
    IF guards THEN
      IF nh > 0 THEN
        IF a0 THEN 
          spindles[0][nh] := Dispatcher.InstallHandler (Sirpa.E0, WCE0, E0);
        END;
        IF a1 THEN 
          spindles[1][nh] := Dispatcher.InstallHandler (Sirpa.E1, WCE1, E1);
        END;
        IF a2 THEN 
          spindles[2][nh] := Dispatcher.InstallHandler (Sirpa.E2, WCE2, E2);
        END;
        IF a3 THEN 
          spindles[3][nh] := Dispatcher.InstallHandler (Sirpa.E3, WCE3, E3);
        END;
        IF a4 THEN 
          spindles[4][nh] := Dispatcher.InstallHandler (Sirpa.E4, WCE4, E4);
        END;
        IF a5 THEN 
          spindles[5][nh] := Dispatcher.InstallHandler (Sirpa.E5, WCE5, E5);
        END;
        IF a6 THEN 
          spindles[6][nh] := Dispatcher.InstallHandler (Sirpa.E6, WCE6, E6);
        END;
        IF aA THEN 
          spindles[7][nh] := Dispatcher.InstallHandler (Sirpa.EA, WCEA, EA);
        END;
      END;
    ELSE
      IF nh > 0 THEN
        IF a0 THEN 
          spindles[0][nh] := Dispatcher.InstallHandler (Sirpa.E0, NIL, E0);
        END;
        IF a1 THEN 
          spindles[1][nh] := Dispatcher.InstallHandler (Sirpa.E1, NIL, E1);
        END;
        IF a2 THEN 
          spindles[2][nh] := Dispatcher.InstallHandler (Sirpa.E2, NIL, E2);
        END;
        IF a3 THEN 
          spindles[3][nh] := Dispatcher.InstallHandler (Sirpa.E3, NIL, E3);
        END;
        IF a4 THEN 
          spindles[4][nh] := Dispatcher.InstallHandler (Sirpa.E4, NIL, E4);
        END;
        IF a5 THEN 
          spindles[5][nh] := Dispatcher.InstallHandler (Sirpa.E5, NIL, E5);
        END;
        IF a6 THEN 
          spindles[6][nh] := Dispatcher.InstallHandler (Sirpa.E6, NIL, E6);
        END;
        IF aA THEN 
          spindles[7][nh] := Dispatcher.InstallHandler (Sirpa.EA, NIL, EA);
        END;
      END;
    END;

    IF nh = 50 THEN
      DoSynchHandling(nh);
    ELSIF nh <= 10 AND do_handle[nh] THEN
      DoSynchHandling(nh);
    END;
  END DoSynchEventHandle; 

PROCEDURE DoHandle () = 
  VAR
    p0, p1, p2, p3, p4, p5, p6, pA: Dispatcher.Binding;
  BEGIN
    IF Dispatcher.GetHandlers(Sirpa.E0, NIL) # NIL THEN
      IO.Put("ERROR 0 >>> incorrect number of handlers on a0\n");
    END;

    IF a0 THEN p0 := Dispatcher.GetOriginalHandler(Sirpa.E0); END;
    IF a1 THEN p1 := Dispatcher.GetOriginalHandler(Sirpa.E1); END;
    IF a2 THEN p2 := Dispatcher.GetOriginalHandler(Sirpa.E2); END;
    IF a3 THEN p3 := Dispatcher.GetOriginalHandler(Sirpa.E3); END;
    IF a4 THEN p4 := Dispatcher.GetOriginalHandler(Sirpa.E4); END;
    IF a5 THEN p5 := Dispatcher.GetOriginalHandler(Sirpa.E5); END;
    IF a6 THEN p6 := Dispatcher.GetOriginalHandler(Sirpa.E6); END;
    IF aA THEN pA := Dispatcher.GetOriginalHandler(Sirpa.EA); END;

    IF a0 THEN Dispatcher.Uninstall(p0); END;
    IF a1 THEN Dispatcher.Uninstall(p1); END;
    IF a2 THEN Dispatcher.Uninstall(p2); END;
    IF a3 THEN Dispatcher.Uninstall(p3); END;
    IF a4 THEN Dispatcher.Uninstall(p4); END;
    IF a5 THEN Dispatcher.Uninstall(p5); END;
    IF a6 THEN Dispatcher.Uninstall(p6); END;
    IF aA THEN Dispatcher.Uninstall(pA); END;

    IF NUMBER(Dispatcher.GetHandlers(Sirpa.E0, NIL)^) # 0  THEN
      IO.Put("ERROR 1 >>> incorrect number of handlers on a0: " & 
        Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E0, NIL)^)) &  "\n");
    END;

    FOR i := 1 TO 50 DO
      DoSynchEventHandle(i);
    END;

    FOR i := 1 TO 50 DO
      IF a0 THEN Dispatcher.Uninstall (spindles[0][i]); END;
      IF a1 THEN Dispatcher.Uninstall (spindles[1][i]); END;
      IF a2 THEN Dispatcher.Uninstall (spindles[2][i]); END;
      IF a3 THEN Dispatcher.Uninstall (spindles[3][i]); END;
      IF a4 THEN Dispatcher.Uninstall (spindles[4][i]); END;
      IF a5 THEN Dispatcher.Uninstall (spindles[5][i]); END;
      IF a6 THEN Dispatcher.Uninstall (spindles[6][i]); END;
      IF aA THEN Dispatcher.Uninstall (spindles[7][i]); END;
    END;

    IF NUMBER(Dispatcher.GetHandlers(Sirpa.E0, NIL)^) # 0  THEN
      IO.Put("ERROR 2 >>> incorrect number of handlers on a0: " & 
        Fmt.Int(NUMBER(Dispatcher.GetHandlers(Sirpa.E0, NIL)^)) &  "\n");
    END;

    IF a0 THEN Dispatcher.Install(p0); END;
    IF a1 THEN Dispatcher.Install(p1); END;
    IF a2 THEN Dispatcher.Install(p2); END;
    IF a3 THEN Dispatcher.Install(p3); END;
    IF a4 THEN Dispatcher.Install(p4); END;
    IF a5 THEN Dispatcher.Install(p5); END;
    IF a6 THEN Dispatcher.Install(p6); END;
    IF aA THEN Dispatcher.Install(pA); END;

    IF Dispatcher.GetHandlers(Sirpa.E0, NIL) # NIL THEN
      IO.Put("ERROR 3 >>> incorrect number of handlers on a0\n");
    END;
  END DoHandle;

(*
PROCEDURE DoInstall (opt_level: INTEGER; x: INTEGER) =
  VAR
    Tmin, Tmax, Tacc: ARRAY [1..10] OF INTEGER;
    d, t1, t2: INTEGER;
    sp: Dispatcher.Binding;
    n: INTEGER;
  BEGIN
    IF opt_level # -1 THEN
      DispatcherPrivate.SetOptLevel(Sirpa.E0, opt_level);
    END;

    SetOverhead();

    t1 := CPU.CycleCounter();
    t2 := CPU.CycleCounter();
    sp := Dispatcher.InstallHandler (Sirpa.E1, WCE1, E1);
    FOR i := 1 TO 10 DO
      Tmin[i] := LAST(INTEGER);
      Tmax[i] := FIRST(INTEGER);
      Tacc[i] := 0;
    END;
    Dispatcher.Uninstall(sp);
    FOR i := 0 TO 100 DO
      IF Dispatcher.GetHandlers(Sirpa.E0, NIL) # NIL THEN
        IO.Put("ERROR 4 >>> incorrect number of handlers on a0\n");
      END;
      FOR i := 1 TO 10 DO
        t1 := CPU.CycleCounter();
        spindles[0][i] := Dispatcher.InstallHandler (Sirpa.E0, WCE0, E0);
        t2 := CPU.CycleCounter();
        d := (t2-t1); 
        CASE i OF
        | 1 => n := 1;
        | 5 => n := 2;
        | 10 => n := 3;
        | 50 => n := 4;
        | 100 => n := 5;
        ELSE n := 0;
        END;
        IF n # 0 THEN
          Tmin[n] := MIN(Tmin[n], d);
          Tmax[n] := MAX(Tmax[n], d);
          INC(Tacc[n], d);
        END;
      END;
      FOR i := 1 TO 100 DO
        Dispatcher.Uninstall (spindles[0][i]);
      END;
    END;
    IF Dispatcher.GetHandlers(Sirpa.E0, NIL) # NIL THEN
      IO.Put("ERROR 5 >>> incorrect number of handlers on a0\n");
    END;
    IO.Put ("Handler installation:: \n");
    FOR i := 1 TO 5 DO
      IO.Put(Fmt.Int(i) & 
        " min: " & Fmt.Int(Tmin[i]-tcost) & 
        " max: " & Fmt.Int(Tmax[i]-tcost) &
        " ave: " & Fmt.Int((Tacc[i] DIV 10 - tcost) DIV CYC) & "\n");
    END;
  END DoInstall; 
*)

PROCEDURE DoInstall (opt_level: INTEGER; <*UNUSED*>x: INTEGER) =
  VAR
(*
    Tmin, Tmax, Tacc: ARRAY [1..10] OF INTEGER;
    d, t1, t2: INTEGER;
    l: INTEGER;
*)
    sp: Dispatcher.Binding;
    n: INTEGER;
    s: ARRAY [1..5] OF Spy.T;
  BEGIN
    IF opt_level # -1 THEN
      DispatcherPrivate.SetOptLevel(Sirpa.E0, opt_level);
    END;

    FOR i := 1 TO 5 DO
      s[i] := Spy.Create("S" & Fmt.Int(i));
    END;

    sp := Dispatcher.InstallHandler (Sirpa.E1, WCE1, E1);
    Dispatcher.Uninstall(sp);

    IF Dispatcher.GetHandlers(Sirpa.E0, NIL) # NIL THEN
      IO.Put("ERROR 4 >>> incorrect number of handlers on a0\n");
    END;

    FOR i := 1 TO 3 DO
      CASE i OF
      | 1 => n := 1;
      | 2 => n := 5;
      | 3 => n := 10;
      | 4 => n := 50;
      | 5 => n := 100;
      END;
      IO.Put(">>> " & Fmt.Int(i) & " - ");
      RTCollector.Collect(); RTCollector.Collect(); RTCollector.Collect();
      RTCollector.Disable();
      IO.Put(Fmt.Int(n) & "\n");

      FOR j := 1 TO 100 DO
        Spy.Enter(s[i]);
        FOR k := 1 TO n DO
          spindles[0][k] := Dispatcher.InstallHandler (Sirpa.E0, WCE0, E0);
        END;
        Spy.Exit(s[i]);
        
        FOR k := 1 TO n DO
          Dispatcher.Uninstall (spindles[0][k]);
        END;
      END;
      RTCollector.Enable();
    END;
  END DoInstall; 


PROCEDURE DoAsynch () =
  VAR
    alias: PROCEDURE (a:INTEGER);
  BEGIN
    Sirpa.min := LAST(INTEGER);
    Sirpa.max := FIRST(INTEGER);
    Sirpa.acc := 0;

    alias := LOOPHOLE(Dispatcher.GetAsynchAlias(Sirpa.Foo),
                      PROCEDURE(a:INTEGER));

    FOR i := 1 TO 100 DO
    END;

    FOR i := 1 TO 100 DO
      alias(CPU.CycleCounter());
      ThreadExtra.Yield();
    END;
  END DoAsynch;

VAR
  guards: BOOLEAN;

PROCEDURE Time (opt_level: INTEGER) =
  BEGIN
    IO.Put ("\n>>> DispTime.Time: opt level " & Fmt.Int(opt_level) & "\n" );

    IF opt_level # -1 THEN
      IF a0 THEN DispatcherPrivate.SetOptLevel(Sirpa.E0, opt_level); END;
      IF a1 THEN DispatcherPrivate.SetOptLevel(Sirpa.E1, opt_level); END;
      IF a2 THEN DispatcherPrivate.SetOptLevel(Sirpa.E2, opt_level); END;
      IF a3 THEN DispatcherPrivate.SetOptLevel(Sirpa.E3, opt_level); END;
      IF a4 THEN DispatcherPrivate.SetOptLevel(Sirpa.E4, opt_level); END;
      IF a5 THEN DispatcherPrivate.SetOptLevel(Sirpa.E5, opt_level); END;
      IF a6 THEN DispatcherPrivate.SetOptLevel(Sirpa.E6, opt_level); END;
      IF aA THEN DispatcherPrivate.SetOptLevel(Sirpa.EA, opt_level); END;
    END;

    TRY
      SetOverhead();
      DoM3DirProcCall();
      DoM3IndirProcCall();
(*
      guards := FALSE;
      DoHandle();
*)
      guards := TRUE;
      DoHandle();
    EXCEPT
    ELSE
      IO.Put (">>> ERROR >> exception caught\n");
    END;

    IO.Put ("\n>>> DispTime.Time done\n");
  END Time;

VAR
  zapped: BOOLEAN := FALSE;

PROCEDURE Run(pp: ParseParams.T): BOOLEAN =
  VAR
    optLevel: INTEGER;
    as, inst: BOOLEAN;
    x: INTEGER;
  BEGIN
    IF zapped THEN
      RETURN FALSE;
    END;

    pp.reset();
    TRY
      pp.skipNext();
      pp.skipNext();

      IF pp.keywordPresent("z") THEN
        zapped := TRUE;
        RETURN TRUE;
      END;

      inst := pp.keywordPresent("i");
      as := pp.keywordPresent("a");

      IF pp.keywordPresent("-all") THEN
        optLevel := -1;
      ELSE
        TRY
          optLevel := pp.getNextInt();
        EXCEPT
        ELSE
          optLevel := DispatcherPrivate.DefaultOptLevel;
        END;
        TRY
          x := pp.getNextInt();
        EXCEPT
        ELSE
          x := -1;
        END;
      END;
      
      IF inst THEN
        DoInstall(optLevel, x);
      ELSIF as THEN
        DoAsynch();
      ELSIF optLevel = -1 THEN
        FOR i := 0 TO DispatcherPrivate.MaxOptLevel DO
          Time(i);
        END;
      ELSE
        Time(optLevel);
      END;
    EXCEPT
    ELSE
      IO.Put("Usage: benchmark disp <-all|opt_level>\n");
    END;
    RETURN TRUE;
  END Run;


BEGIN
END DispTime.
