@style(references STDalphabetic,spacing 1,linewidth 79,
typewheel=elite 12)
@make(article)
@device(lpt)
@libraryfile(libscr)
@modify(figure,above 2,below 2)
@modify(subheading, below 0)
@set(page=1)
@define(romanize,use enumerate,numbered <(@i)>)
@define(alphabetize,use enumerate,numbered <(@a)>)
@modify(EquationCounter, numbered <(@i)>, referenced <(@i)>)
@modify(FootnoteCounter, within page, numbered <@*>, referenced <@*>)
@use(Bibliography = Press.Bib)

Note 172@>Alan Bundy@*
@>@value(Date)@*

@heading(A Toy Ecological Modelling Front End)

Two years ago, when Robert and I first discussed the Ecological Modelling
Front End Project, I wrote a toy program, I  called ECO, just to
familiarize myself with the problem. This is the 0th order program
mentioned in the grant. Now it has taken on a new lease of life
as a practice Prolog program for incoming researchers, so I thought
I had better write some documentation. This is it.

The program is input ecological data in the form of the values
of attributes of components and, using formulae that relate these
attributes, it outputs differential equations which describe the
behaviour of the system over time. In its present state it is geared
to tackle a particular example, about sheep and grass, given to me by Robert.

The program is contained on four
files:  eco, eqns, formul, and sheep, on directory [400,405,eco].
@begin(itemize)
Eco merely consults the other three when it is consulted,
simplifying the loading of the program.

Eqns is the top level file. It forms the equations from formul
and sheep.

Formul contains the standard ecological formulae for the various
processes involved in the sheep example.

Sheep contains the data specific to the sheep example.  This consists
mainly of the values of various attributes and the processes
affecting each state variable, but also some relational
information about the components.
@end(itemize)

The program can be run by the following.
@begin(enumerate)
Call UTIL at monitor level. You will enter a version of
Prolog with various utility routines provided by the
mathematical reasoning group.

Consulting ECO (type [eco].). This will consult all the files.

Call go. This runs the program and cause the equations
to be typed on the terminal.
@end(enumerate)

@subheading(Representation)
The components of the ecological system are things like sheep
and grass. They are represented by atoms, e.g. sheep, grass.

The attributes are either:
@begin(itemize)
Parameters, e.g. sheep rate of grazing;

Internal variables, e.g. grass biomass photosynthesis;

State Variables, e.g. sheep biomass; or

External variables, e.g. light.
@end(itemize)
The external variables are represented as Prolog atoms, e.g.  light.
The other three attributes are all functions of the components or the
external variables, and are, therefore, represented as Prolog
functions, e.g.  rate_of_grazing(sheep), biomass_photosynthesis(light),
biomass(sheep).

Processes are similar to attributes, and are also represented
as Prolog functions applied to components, e.g. grazing(sheep).

The initial values of state variables and parameters are real numbers,
and the functions relating internal variables to external variables,
are algebraic expressions.  Since Prolog does not (yet) support real
numbers, I was forced to kludge and represent real numbers by atoms,
e.g.  '1.25'.  Addition, subtraction and multiplication are represented
as the infix operators +, - and *, respectively, so a typical
expression is @w['1.0' - '0.05' * temperature].

@subheading(The Sheep File)
The sheep file consists of the declaration of various kinds
of problem specific information.
@begin(itemize)
Each external variable is declared with the unary predicate,
external_variable.

Each parameter is declared with the binary predicate, parameter,
where the second argument is its constant value.

Each state variable is declared with the ternary predicate, state_variable,
where the second argument is a time, and the third argument is its
value at that time. In all cases the time is initial.

Each internal variable is declared with the binary predicate,
internal_variable, where the second argument is a function defining its
changing value.

Process is a binary predicate relating a state variable
to a process that affects it. If the process decreases
the state variable then it is preceded by a minus sign.
@end(itemize)

The clauses headed "Ecological Knowledge" are properties
of or relations between the components, i.e.
@begin(itemize)
animal(sheep) means that a sheep is an animal;

vegetable(grass) means that grass is a vegatable; and

grazes_on(sheep,grass) means that sheep graze on grass.
@end(itemize)
This information is needed to satisfy the conditions of
the formulae.

@subheading(The Formul File)
The formul file
@foot(Blame the Dec10 for only allowing 6 characters file names.)
contains formulae for each of the processes mentioned
in the file sheep. These formulae are all defined by
clauses whose head predicate is formula.

formula is a binary predicate whose first argument is a process
and whose second argument is a formula for that process.
This formula is an algebraic expression in terms of attributes
or other processes.

Some of the formulae are conditional, and these conditions
are represented by calls to ecological knowledge in the
body of the clause. Notice how this knowledge is used
to separate the two different formula for the grazing process,
according to whether the grazing is a function of an animal
component, or a vegetable component grazed on by an animal
component.

@subheading(The Eqns File)
The eqns file contains procedures for constructing differential
equations for each of the state variables declared in the file sheep.
Each equation has the form @w[d(StateVar)/dt = Value], where
StateVar is the state variable in question and Value is an
algebraic expression in terms of state variables, values
of external variables at time t, and real numbers.
Each state variable is assumed to be affected by the additive effect of
all and only the processes declared in file sheep.


The top level clause is that for go.
It makes a list, VarList, of all state variables,
forms a differential equation for each of them,
and prints the result, EqnList.
The predicates, findall, maplist and writef, that do this
are all utility routines from UTIL.

findall(Var, state_variable(Var), VarList) has the procedural
meaning "find (and make a list, VarList, of) all substitutions
for Var which satisfy state_variable(Var)", i.e. VarList is the list
of state variables.
Its declarative meaning is a list version of the  set theory
operator, @w[{Var: state_variable(Var)}.]
Note the definition of the unary version of state_variable,
from the ternary one, to enable findall to work.

maplist(form_equation, VarList, EqnList) has the procedural
meaning, "apply form-equation to each pair of elements of the
lists VarList and EqnList in turn". Since EqnList is initially
empty, this causes it to be instantiated to a list of the same
length as VarList, consisting of outputs of form-equation
whose inputs are the elements of VarList, i.e. one differential equation
for each state variable.  Its declarative meaning is as the bounded
universally quantified  sentence,
@equation[@forall() Var@in()VarList, Eqn@in()EqnList form_equation(Var,Eqn)]
form_equation is described below.

writef('Equations formed are:  %l', [EqnList]) is a call to the
formatted write procedure in UTIL.  The value of EqnList, together with
suitable spaces, newlines, etc, are substituted for %l, and the
resulting string is typed on the terminal.  The only declarative meaning
that can be assigned to such input/output procedures is 'true', since
they always succeed.  (This is not a helpful way of thinking about them.)

form_equation(StateVar, d(StateVar)/dt = Value) is the key
procedure in the file. It relates a state variable, StateVar,
to a differential equation which describes the state variable's
behaviour over time. When called, StateVar is bound to a particular
state variable and Value must be filled in.
form_equation works in two parts.
In the first part, all the processes affecting StateVar are added
together to form an initial value, Value1, and in the second part
this value is converted by replacing intermediate attributes
and processes by their values, to form the final value, Value.
We deal with each part in turn.

The first part of form_equation is done by using findall
to form a list, ValList, of all processes affecting
StateVar, and then using dottoplus to convert ValList into
a sum, Value1.
Recall that each process, Process, affecting each state variable, StateVar,
is stored in file sheep as the assertion process(StateVar,Process)
or process(StateVar,-Process), according as Process increases
or decreases StateVar.
Assuming that all processes affecting StateVar are so stored,
the call to findall will form a list, ValList, of them (with or without
minus signs as appropriate).
Dottoplus replaces each cons "." with a "+", by recursing down the
list, to make a sum, Value1, form the list, ValList.

The second part of form_equation is done by convert.
It removes each parameter, internal variable and process
from Value1, and replaces it with its value, as defined
in file sheep.
State variables are left intact, and external variables
have their dependancy on t recorded by inserting it as an argument.
These jobs are all done by replace, the job of convert
being to apply replace to all subterms of Value1.

convert(Exp,Value) relates an algebraic expression to its value.  It is
defined, recursively, by three clauses. Their definition assumes that
convert will be called with Exp instantiated and Value a Prolog variable.
@begin(itemize)
The first clause is a call to
replace, which will do the conversion iff Exp is an attribute or
process.  If this call succeeds then the !  prevents backtracking to the
other two clauses.  

The second clause deals with any atom that has not been dealt with by
the first clause.  Since the only atoms are external variables or real
numbers, and external variables have been dealt with already, then this
must be a real number.  (This hack should be removed when real numbers
are put into Prolog.)  The original real number is returned by
identifying the two arguments of convert. If this call succeeds
then the ! prevents backtracking to the other clause.

The third clause only receives expressions which are not attributes,
processes or numbers. It applies convert, recursively, to all subterms
of Exp. =.. is used to break Exp into a list whose head
is the dominant symbol of Exp, and whose tail is a list of the arguments
of Exp. maplist is used to apply convert to each of these arguments.
Finally, =.. is used to reconstruct the converted expression, from
the dominant symbol, Sym, and the list of converted arguments, NewArgs.
@end(itemize)

replace(Attr,Value) relates an attribute or process to its value.
It is defined by five clauses; four for each kind of attribute
and one for processes. The definitions assume that replace is called
with Attr instantiated and Value a Prolog variable.
The first literal in the body of each clause is a test for the
appropriate kind of attribute or process.
This is followed by a !, for efficiency reasons only.
The procedure in each case is as follows.
@begin(itemize)
@b(External Variables): =..is used to convert the Prolog
constant representing the external variable into a unary
function with argument t.

@b(Parameter): Since the value of a parameter is a real number, Ans,
this is returned, and no further processing is required.

@b(State Variable): The state variable, StateVar, is returned
unchanged, since it is  required as a variable in the equation.

@b(Internal Variable): The value of the internal variable, Value, is found, 
but since this can be a complex expression containing further
attributes or processes, it is converted to form Ans, before being
returned.

@b(Process):  The value of the process, Value, is found, 
but since this can be a complex expression containing further
attributes or processes, it is converted to form Ans, before being
returned.
@end(itemize)

This completes the description of file Eqns, and hence of the whole
program.

@subheading(Some Projects)
If you would like to practice your Prolog then here are some possible
projects you might try, extending this program.
@begin(enumerate)
Find some ecological data like that recorded in the file sheep and,
using sheep as a model, run the program on it. Update formul and
debug eqns as required.

Extend the program to deal with components with substructure, e.g.
type hieracrchies, age classes.

Design a front end which queries the user for the ecological data,
and stores it as in file sheep.
@end(enumerate)



