%   File   :  /usr/bs/lpdir/desc.pl
%   Author : Bernard Silver
%   Updated: Tue Oct 15 11:57:01 1985
%   Purpose: Description for LP


 % Produce description of method
construct_method([Eqn|ExampleList],Conjlist1,Method,X,UnkList) :- 
	process_conjlist(Conjlist1,[],Conjlist),
	process_method([Eqn|ExampleList],Method,New1,Conjlist),
	analyze(X,New1,Eqn,NewMethod,ExampleList),
	rev(NewMethod,Description),
	make_schema(X,Eqn,Description,[Eqn|ExampleList],UnkList),
	!.

 % Get conjectures
process_conjlist([conj_mess(Type,Comm,E1,E2)|Rest],Acc,Ans) :-
	process_cm(Type,Comm,E1,E2,New),
	process_conjlist(Rest,[New|Acc],Ans).

process_conjlist([],Ans,Ans) :- !.

 % Process conjecture ready for description

 % This code is probably not needed
process_cm(fail,_,_,_,at(fail,fail,tellfail)) :- !.  

 % Now there is a name for this rule
process_cm(equal,rule(A,B),E1,E2,at(E1,E2,tellequal(A,B))) :- !.
process_cm(Old,_,E1,E2,at(E1,E2,Old)) :- !.

process_method([],[],[],_)  :- !.
process_method([A,B|T1],[fail|T],[C1|Ans],Conj) :- 
	match_conj(A,Conj,C1,NewConj),
	process_method([B|T1],T,Ans,NewConj),
	!.

process_method([_|T1],[H|T],[H|Ans],Conj) :-
	process_method(T1,T,Ans,Conj),	
	!.

match_conj(A,Conj,X,NewConj) :- 
	member(at(E,A,X),Conj),
	!,
	delete_one(at(E,A,X),Conj,NewConj).

match_conj(A,Conj,X,NewConj) :-
	member(at(E,B,X),Conj),
	match_check(A,B),
	!,
	delete_one(at(E,B,X),Conj,NewConj).

 
analyze(X,Desc,Eqn,NewMethod,ExampleList) :-  
	rev(Desc,Desc2),
	rev([Eqn|ExampleList],RExList),
	find_new_method(X,Desc2,NewMethod,RExList),
	!.					



make_schema(X,Eqn,MethodL,ExampleList,UnkList) :-
	partition_the_list(X,MethodL,P1,ExampleList,Part1,UnkList,Part2,Type),
	find_the_purpose(U,U1,P1,Part1,Part2,Schema),
	store_schema(X,Eqn,Schema,Type),
	!.


% Schema already exists
store_schema(X,Eqn,Schema,Type) :-
	known_method_schema(_,_,_,_,schema(S,Eqn1,X),Type,_,_,_),
	match(Eqn,Eqn1),
	!,
	(same_methods(S,Schema) ->
	writef('\n[Already have this schema for this equation]\n');writef('\n
[**There is already a DIFFERENT schema for this equation**]\n')).

store_schema(X,_,Schema,Type) :-
	known_method_schema(_,_,_,_,schema(S,Eqn1,X),Type,_,_,_),
	same_methods(S,Schema),
	!,
	writef('\nA schema with these methods already exists.
It was generated by equation\n%t\n',[Eqn1]).

 % Store schema
store_schema(X,Eqn,Schema,Type) :-
	first_method(Schema,Precond,Var,Old),
	mod_gensym(auto,Name),
	writef('\n[Creating new schema method, called %w, for this equation]
\n',[Name]),
	mod_asserta(known_method_schema(Var,Old,New,method(Name),
schema(Schema,Eqn,X),Type,use_schema(Var,Old,New,Type,Eqn,Schema,X),Precond,
[dis_solution(Var,New)])),
	flag(method(method(Name)),_,on),
	mod_asserta(method(method(Name))),
	mod_asserta(schema(method(Name))),
	!.

same_methods([],[]) :- !.
same_methods([[H|T]|T1],[[H1|T2]|T3]) :- !,
	same_methods([H|T],[H1|T2]),
	same_methods(T1,T3).
same_methods([H|T],[H1|T1]) :-
	arg(1,H,E),
	arg(1,H1,E),	
	!,
	same_methods(T,T1).

first_method([[conditions(NM,_,_)|_]|_],Pre,Var,H) :- !,
	get_preconditions(Var,NM,H,Pre).

first_method([conditions(NM,_,_)|_],Pre,Var,H) :- !,
	get_preconditions(Var,NM,H,Pre).

