/*
	xpcopy.m -- prolog machine copymode instructions

	Copyright (c) 1987 by High Level Hardware Limited
*/

*I proregs.m
*I proops.m
*I proconsts.m

EXTERNAL  fillIr0
EXTERNAL  in_unatomic, unify, pctobyte, pctoword
EXTERNAL  copyFetch, matchFetch, processorTrap, Arrive, Fail
EXTERNAL  copyFetch1, copyFetch2, matchFetch1, matchFetch2
EXTERNAL  cexit, cfexit, cpnoop, cbackup
EXTERNAL  rcache, wcache, rwcache
EXTERNAL  dref, in_trail, checkGlobal, claimclause
EXTERNAL  multiply, tcdivcore

GLOBAL	rst112, rst115, rst002
GLOBAL	rst007, rst008, rst009, rst010, rst011, rst012, rst013
GLOBAL	rst014, rst015, rst016, rst017, rst018, rst019, rst020
GLOBAL	rst021, rst022, rst023, rst024, rst025, rst026, rst027
GLOBAL	rst001, rst029, rst030, rst004, rst032, rst033, rst003
GLOBAL	cunimp

DEFAULTENTRY	copymode

cunimp:
	CONT	DZ RTL1  OR  RAMA A=ir0 B=ir0
	JUMP	cexit  ZB  SUBR  RAMF B=pc
	CONT	DZ D=BR, cunimpl  OR  QREG
//----------

ENTRY	copymode + ipop
ENTRY	matchmode + ipop

	/*
		PM = *SP--;
		D = (int *) *SP--;
		if (PM) goto MatchMode; else goto CopyMode;
	*/
	
	CONT	DA D=BR,2 A=sp  SUBR CIN  RAMF B=sp  DECCA
	CJP	NZ,  matchFetch  DZ D=CSH  OR
	CJP	NLC, copyFetch1  DZ D=CSH  OR  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + poparg

	/*
		SP--;
		D = (int *) *SP--;
		goto CopyMode;
	*/

	CONT	DA D=BR, 2 A=sp  SUBR CIN  RAMF B=sp  DECCA
	JUMP	copyFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	DZ D=CSH  OR  RAMF B=d
//---------

ENTRY	copymode + initvar

	/*
		ip = cl + *pc++;
		*ip = makeword(UNDEF, (int) IP);
		goto CopyMode;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=cl  ADD  RAMF B=R0  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CONT	DA D=BR,undeftag SHL3  A=R0  OR  RAMF B=R0  LOCK
	CJP	NWFLT, copyFetch  ZA A=R0  OR  LBR  WR
	CJS	NLC, wcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0
	LDCT	cbackup
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND
//----------

ENTRY copymode + ivar

	/*
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) == UNDEF)
		{
			if ((int *) val (R0) >= D)
			{
				memoff0 (R0) = makeword (LINK, (int) D);
				*D = makeword (UNDEF, (int) D);
				D++;
				in_trail (R0);
			}
			else
			{
				*D++ = makeword (LINK, val (R0));
			}
		}
		else
		{
			*D++ = R0;
		}
		goto CopyMode;
	*/
	
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CJS	dref
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
 	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R3
	CONT	NZ DA D=BR, undeftag SHL3 A=R3  EXOR
	CJP	LC, ivar1  ZA A=R0  OR  RAMF B=R2
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R3  LVAR
	CJP	BW, ivar1  AB A=R3 B=d  SUB CIN  D=TB  LBR
	CONT	DA D=BR, linktag SHL3 A=R3  OR  RAMF B=R0
	CONT	DA D=BR, linktag SHL3 A=d  OR  RAMF B=R3  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=R3  OR  LBR  WR
rst010:
	CJS	in_trail  ZA A=R2  OR  RAMF B=R0
	LDCT	fix010
	CONT	DA D=BR, undeftag SHL3 A=d  OR  RAMF B=R0
rst011:
ivar1:
	CONT	ZB  ADD CIN  RAMA A=d B=d  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  LOCK
	CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
	LDCT	fix011
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

fix010:
	JUMP	cfexit
	CONT	DZ D=BR,10  OR  QREG
fix011:
	JUMP	cfexit  ZB  SUBR  RAMF B=d
	CONT	DZ D=BR,11  OR  QREG
//----------	

ENTRY copymode + vararg

	/*

	R0 = *(CL + *PC++);
	*D++ = (tag(R0) == UNDEF) ? makeword(LINK, val(R0)) : R0;
	goto CopyMode;

	*/

VarArg:
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CONT	DZ D=BR, tagmask SHL3  OR  QREG
 	CONT	DQ D=BUS  AND  RAMF B=R0
	CONT	NZ DA D=BR, undeftag SHL3 A=R0  EXOR
	CJP	LC, varg1  DZ D=BUS  OR  RAMA A=d B=R0  LVAR
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  QREG
	CONT	DQ D=BR, linktag SHL3  OR  RAMF B=R0
varg1:
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  ZB  ADD CIN  RAMF B=d  LOCK
	CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
	LDCT	cbackup  ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + firstvar

	/*
		*(CL + *PC++) = makeword(LINK, (int) D);
		*D = makeword(UNDEF, (int) D);
		D++;
		goto CopyMode;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=cl  ADD  RAMF B=R0  LVAR
	CONT	DA D=BR, linktag SHL3 A=d  OR  RAMF  B=R0
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	WFLT, wcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  ZA A=R0  OR  LBR  WR
	CONT	DA D=BR, undeftag SHL3  OR  RAMA A=d  B=R0  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  ZB  ADD CIN  RAMF B=d  LOCK
	CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
	LDCT	cbackup  ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + firvararg

	/*
		IP = CL + *PC++;
		*IP = makeword(UNDEF, (int) IP);
		*D++ = makeword(LINK, (int) IP);
		goto CopyMode;
	*/

FirVarArg:
	CONT	DZ MASK  OR  RAMA A=ir0 B=R1
	CONT	AB A=cl  ADD  RAMF B=R1  LVAR
	CONT	DA D=BR, undeftag SHL3  A=R1  OR  RAMF B=R0
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	WFLT, wcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  ZA A=R0  OR  LBR  WR
	CONT	DZ D=BR, linktag SHL3  OR  RAMA A=d B=R0  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  AB A=R1  OR  RAMF B=R0  LOCK
	CJS	NLC, wcache  ZB  ADD CIN  RAMA A=R0 B=d  LBR  WR
	LDCT	cbackup  ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------	

ENTRY	copymode + glofirvar

	/*
		if (BL >= CL) goto FirVarArg;
		*(CL + *PC++) = *D++ = makeword (LINK, (int) g);
		*G = makeword (UNDEF, (int) g);
		++G;
		goto CopyMode;
	*/

	CJP	NBW, FirVarArg  AB A=bl B=cl  SUB CIN
	CONT	DZ MASK  OR  RAMA A=ir0 B=R1
	CONT	AB A=cl B=R1  ADD  LVAR
	CONT	DA D=BR, linktag SHL3 A=g  OR  RAMF B=R0
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	WFLT, wcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  ZA A=R0  OR  LBR  WR
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cbackup  ZA A=R0  OR  LBR  WR
	CONT	DA D=BR, undeftag SHL3  OR  RAMA  A=g  B=R0   LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  ZB  ADD CIN  RAMF B=g  LOCK
	CONT	ZB  ADD  CIN  RAMA A=R0 B=d  LBR  WR
	CJS	wcache  ZB  SUBR  RAMF B=d
	LDCT	cbackup  ZB  SUBR  RAMF B=g
	JUMP	copyFetch  ZB  ADD CIN  RAMF B=g
	CONT	ZB  ADD CIN  RAMF B=d
//----------

ENTRY	copymode + glovar

	/*
		if (BL >= CL) goto VarArg;
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) == UNDEF)
		{
			if ((int *) val (R0) >= CL)
			{
				memoff0 (R0) = *D++ = makeword (LINK, (int) G);
				*G = makeword (UNDEF, (int) G);
				++G;
			}
			else
			{
				*D++ = makeword (LINK, val (R0));
			}
		}
		else
		{
			*D++ = R0;
		}
		goto CopyMode;
	*/
	
	CJP	NBW, VarArg  AB A=bl B=cl  SUB CIN
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CJS	dref
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
 	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R3
	CONT	NZ DA D=BR, undeftag SHL3 A=R3  EXOR
	CJP	LC, glovar1
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R3  LVAR
	CJP	BW, glovar1  AB A=R3 B=cl  SUB CIN  D=TB  LBR
	CONT	DA D=BR, linktag SHL3 A=R3  OR  RAMF B=R0 
	CONT	DA D=BR, linktag SHL3 A=g  OR  RAMF B=R0  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cbackup  ZA A=R0  OR  LBR  WR
rst009:
	CONT	DA D=BR, undeftag SHL3 A=g  OR  RAMA B=R3  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  ZB  ADD CIN  RAMF B=g  LOCK
	LDCT	fix009  ZA A=R3  OR  LBR  WR
rst008:
glovar1:
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  LOCK
	CJS	NLC, wcache  ZB  ADD CIN  RAMA A=R0  B=d  LBR  WR
	LDCT	fix008	ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR

fix008:
	JUMP	cfexit
	CONT	DZ D=BR,8  OR  QREG
fix009:
	JUMP	cfexit  ZB  SUBR  RAMF B=g
	CONT	DZ D=BR,9  OR  QREG
//----------	

ENTRY	copymode + voidn

	/*
		R0 = *PC++;
		while (R0--)
		{
			*D = makeword (UNDEF, (int) D);
			++D;
		}
		goto CopyMode;
	*/

	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
 	CJP	Z, copyFetch  DZ ZZZA  OR  RAMA A=ir0 B=R1
	CONT	ZB  ADD CIN  RAMF B=pc
rst115:
	LDCT	cfexit
	CONT	DZ D=BR, 115  OR  QREG
voidlp:
		CONT	DA D=BR, undeftag  SHL3  OR  RAMA A=d B=R0  LVAR
		CONT	ZB  ADD CIN  RAMF B=d  D=TB  LBR  ADDR
		CJP	NZ, voidlp  ZB  SUBR  RAMF B=R1  LOCK
		CJP	WFLT, voidlp1  ZA A=R0  OR  LBR  WR
	CJP	NLC, copyFetch
	CONT

voidlp1:
	CJS	wcache  ZB  SUBR  RAMF B=d  LVAR
	CONT	ZB  ADD CIN  RAMF B=R1
	JUMP	voidlp
	CONT
//----------
	
ENTRY	copymode + void

	/*
		*D = makeword (UNDEF, (int) D);
		++D;
		goto CopyMode;
	*/

	CONT	DA D=BR, undeftag SHL3  OR  RAMA A=d  B=R0  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  LOCK
	CJS	NLC, wcache  ZB  ADD CIN  RAMA A=R0 B=d  LBR  WR
	LDCT	cpnoop  ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + ifunctor

	/*
		*D++ = makeword (TERM, (int) G);
		*G++ = *(XC + CLAUSELEN + *PC++);
		*++SP = (int) D;
		*++SP = 0;
		D = G;
		G += *PC++;
		checkglobal (10);
		goto CopyMode;
	*/
 
 	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DA D=BR, clauselen A=R0  ADD  RAMF B=R0
	CONT	AB A=xc  ADD  RAMF B=R0  LVAR
	LDCT	cbackup  ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	CONT	DA D=BR, termtag SHL3  A=g  OR  RAMF B=R0  RD
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  DZ D=BUS  OR  RAMF B=R1  LOCK
	LDCT	cbackup  ZA A=R0  OR  LBR  WR
rst112:
	CONT	ZA A=g  ADD CIN  RAMA B=g  LVAR
	CONT	ZB  ADD CIN  RAMF B=d  D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix112  ZA A=R1  OR  LBR  WR

	CONT	ZB  ADD CIN  RAMF B=sp  ALDCA
	CONT	ZB  ADD CIN  RAMA A=d  B=sp  CWR  INCCA
	CONT	ZA A=g  OR  RAMF B=d  D=BR,0  CWR

 	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=R0  ADD  RAMF B=g
	CONT	ZB  ADD CIN  RAMF B=pc
  	CJS	checkGlobal  DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	DZ D=BR, 10  OR  RAMF B=R0
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

fix112:
	CONT	ZB  SUBR  RAMF B=d
	JUMP	cfexit  ZB  SUBR  RAMF B=g
	CONT	DZ D=BR, 112  OR  QREG
//----------	

ENTRY	copymode + conslist

	/*
		checkglobal (12);
		*D++ = makeword (CONS, (int) G);
		*++SP = (int) D;
		*++SP = 0;
		D = G;
		G += 2;
		goto CopyMode;
	*/
 
	CJS	checkGlobal
	CONT	DZ D=BR, 12  OR  RAMF B=R0
	CONT	DA D=BR, constag SHL3  A=g  OR  RAMF B=R0
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  ZA A=R0  OR  LBR  WR

	CONT	ZB  ADD CIN  RAMF B=sp  ALDCA
	CONT    ZB  ADD CIN  RAMF B=d  CWR  INCCA
	CONT	ZB  ADD CIN  RAMF B=sp  D=BR, 0  CWR

	CJP	copyFetch  ZA A=g  OR  RAMF B=d
	CONT	DA D=BR, 2  A=g  ADD  RAMF B=g
//----------	

ENTRY	copymode + lastfunctor

	/*
		*D = makeword (TERM, (int) g);
		*G++ = *(XC + CLAUSELEN + *PC++);
		D = G;
		G += *PC++;
		checkglobal(10);
		goto CopyMode;
	*/

 	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DA D=BR, clauselen A=R0  ADD  RAMF B=R0
	CONT	AB A=xc  ADD  RAMF B=R0  LVAR
	LDCT	cbackup  ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	CONT	DA D=BR, termtag SHL3  A=g  OR  RAMF B=R0  RD
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  DZ D=BUS  OR  RAMF B=R1  LOCK
	LDCT	cbackup  ZA A=R0  OR  LBR  WR
rst007:
	CONT	ZA A=g  ADD CIN  RAMA B=g  LVAR
	CONT	ZA A=g  OR  RAMF B=d  D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix007  ZA A=R1  OR  LBR  WR
 
 	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=R0  ADD  RAMF B=g
	CONT	ZB  ADD CIN  RAMF B=pc
  	CJS	checkGlobal  DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	DZ D=BR, 10  OR  RAMF B=R0
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

fix007:
	JUMP	cfexit  ZB  SUBR  RAMF B=g
	CONT	DZ D=BR, 7  OR  QREG
//----------	

ENTRY	copymode + lastconslist

	/*
		checkglobal (12);
		*D = makeword (CONS, (int) G);
		D = G;
		G += 2;
		goto CopyMode;
	*/

	CJS	checkGlobal
	CONT	DZ D=BR, 12  OR  RAMF B=R0
	CONT	DA D=BR, constag SHL3  A=g  OR  RAMF B=R0
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop	ZA A=R0  OR  LBR  WR
	CJP	copyFetch  ZA A=g  OR  RAMF B=d
	CONT	DA D=BR, 2  A=g  ADD  RAMF B=g
//----------	

ENTRY	copymode + immed

	/*
		*D++ = makeword (INT, (*PC++ & 0xff));
		goto CopyMode;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DA D=BR, inttag SHL3   A=R0  OR  RAMF B=R0
	CONT	ZA A=d  OR  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	CJS	NLC, wcache  ZB  ADD CIN  RAMA A=R0 B=d  LBR  WR
	LDCT	cbackup  ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY copymode + constant

	/*
		*D++ = *(XC + CLAUSELEN + *PC++);
		goto CopyMode;
	*/

  	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DA D=BR, clauselen A=R0  ADD  RAMF B=R0
	CONT	AB A=xc  ADD  RAMF B=R0  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  DZ D=BUS  OR  RAMF B=R0  LOCK
	CJS	NLC, wcache  ZB  ADD CIN  RAMA A=R0 B=d  LBR  WR
	LDCT	cbackup  ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + constnil

	/*
		*D++ = syswords[SWNIL];
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + syswords  OR  ALDCA
	CONT	DZ D=BR, swnil  OR  RAMF B=R0
	CONT	DA D=CSH A=R0  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  DZ D=BUS  OR  RAMF B=R0  LOCK
	CJS	NLC, wcache  ZB  ADD CIN  RAMA A=R0 B=d  LBR  WR
	LDCT	cpnoop  ZB  SUBR  RAMF B=d
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + enter
ENTRY	matchmode + enter

	/*
		claimclause ();
		L += *PC++;
		D = L + ACTSIZE;
		if (INTFLAG)
		{
			INTFLAG = 0;
			M0 = syswords[SWBREAK];
			goto Call;
		}
		goto CopyMode;
	*/

	CJS	claimclause
	LDCT	cpnoop
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
rst027:
	CONT	DZ D=BR, pswapbase + intflag  OR  ALDCA
	CONT
	CONT	DZ D=CSH  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, rwcache  LOCK
	LDCT	fix027  RD
	CONT	AB A=R0  ADD  RAMF B=l D=BR, 0  LBR  WR
	CJP	Z, copyFetch  DZ D=BUS  OR
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d
rst015:
	CONT	DZ D=BR, pswapbase + syswords  OR  ALDCA
	CONT	DZ D=BR, swbreak  OR  RAMF B=R0
	CONT	DA D=CSH A=R0  ADD  LVAR
	LDCT	cfexit  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, 15  OR  QREG  RD
	JUMP	Call
	CONT	DZ D=BUS  OR  RAMF B=m0

fix027:
	JUMP	cfexit
	CONT	DZ D=BR, 27  OR  QREG
//----------

ENTRY copymode + cut
ENTRY matchmode + cut

	/*
		if (BL >= CL)
		{
			while (CL <= (IP = (int *) *(BL + BLOFF))) BL = IP;
			goto LocalCut;
		}
		else
			PC++;
		goto CopyMode;
	*/

	CJP	NBW, cut1  AB A=bl B=cl  SUB CIN		
	CONT
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=pc
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR

cut1:
	CONT	DA D=BR, bloff A=bl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT
	CJP	BW, LocalCut  DA D=BUS A=cl  SUB CIN
	CJP	NLC, cut1  DZ D=BUS  OR  RAMF B=ip
	CONT	ZA A=ip  OR  RAMF B=bl
//----------

ENTRY	copymode + localcut
ENTRY	matchmode + localcut

iq	=	R3
ttr2	=	R2
ttr1	=	R1

	/*
		TR1 = (int *) *(BL + TROFF);
		BP = *(BL + BPOFF);
		BL = (int *) *(BL + BLOFF);
		if (TR1 < TR)
		{
			TTR1 = (int *) *(BL + GOFF);
			IP = IQ = TR1;
			while (IP < TR)
			{
				R0 = *IP;
				TTR2 = (int *) val(R0);
				if ( (tag (R0) == CLAUSE) ||
					((TTR2 > LORG) && (TTR2 < BL)) ||
					(TTR2 < TTR1) )
				{
					if (IP != IQ) *IQ = R0;
					IQ++;
				}
				IP++;
			}
			TR = IQ;
		}
		L = CL + *PC++;
		D = L + ACTSIZE;
		goto CopyMode;
	*/

rst020:
LocalCut:
	CONT	DA D=BR, troff A=bl  ADD  LVAR
	LDCT	fix020  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA  RD
	CONT	DA D=BR, bpoff A=bl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=ip  LOCK
	LDCT	fix020  ZA A=ip  OR  RAMF B=iq  RD
	CONT	DA D=BR, bloff A=bl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  CWR  LOCK
	LDCT	fix020  RD
	CJP	NBW, localcut1  AB A=ip B=tr  SUB CIN
	CONT	DZ D=BUS  OR  RAMF B=bl

rst021:
	CONT	DA D=BR,goff A=bl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix021  RD
	CJP	NBW, localcut2  AB A=ip B=tr  SUB CIN
	CONT	DZ D=BUS  OR  RAMF B=ttr1
rst022:
localcut3:
	CONT	ZA A=ip  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix022	RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=ttr2
	CONT	DA D=BUS A=ttr2  AND  RAMF B=ttr2
	CONT	DZ D=BUS  OR  RAMF B=R0
	CJP	BW, localcut5  AB A=ttr2 B=ttr1  SUB CIN
	CONT	DA D=BR,tagmask SHL3 A=R0  AND  QREG
	CONT	Z  DQ D=BR,clausetag SHL3  EXOR
	CJP	LC, localcut5
	CONT	DZ D=BR, pswapbase + lorg  OR  ALDCA
	CJP	NBW,localcut4  AB A=ttr2 B=bl  SUB CIN
	CONT
	CJP	NBW,localcut4  DA D=CSH A=ttr2  SUB CIN
	CONT
localcut5:
	CJP	Z, localcut6  AB A=ip B=iq  EXOR
rst023:
	CONT	ZA A=iq  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix023  ZA A=R0  OR  LBR  WR
localcut6:
	CONT	ZB  ADD CIN  RAMF B=iq
localcut4:
	CONT	ZB  ADD CIN  RAMF B=ip
	CJP	BW, localcut3  AB A=ip B=tr  SUB CIN
	CONT
localcut2:
	CONT	ZA A=iq  OR  RAMF B=tr
localcut1:
	CONT	DZ MASK  OR  RAMA A=ir0 B=l
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
	JUMP	copyFetch  AB A=cl  ADD  RAMF B=l
	CONT	DA D=BR,actsize A=l  ADD  RAMF B=d

fix020:
	JUMP	cfexit
	CONT	DZ D=BR, 20  OR  QREG
fix021:
	JUMP	cfexit
	CONT	DZ D=BR, 21  OR  QREG
fix022:
	JUMP	cfexit
	CONT	DZ D=BR, 22  OR  QREG
fix023:
	JUMP	cfexit
	CONT	DZ D=BR, 23  OR  QREG
//----------

ENTRY	copymode + icontinue

	/*
		PC = PC + *PC + 1
		goto CopyMode
	*/

	CONT	DZ MASK  ADD CIN  RAMA A=ir0 B=R0
	CONT	AB  A=R0  ADD  RAMF B=pc
rst013:
	CJS	fillIr0
	LDCT	fix013
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

fix013:
	JUMP	cfexit
	CONT	DZ D=BR,13  OR  QREG
//----------

ENTRY	copymode + savel

	/*
		*(CL + *PC++) = (int) l;
		goto CopyMode;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	CJS	NLC, wcache  ZA A=l  OR  LBR  WR
	LDCT	cbackup
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND
//----------

ENTRY	copymode + disjunct

	/*
		*(L + CLOFF) = (int) CL;
		*(L + BLOFF) = (int) BL;
		*(L + BPOFF) = BP;
		*(L + GOFF) = (int) G;
		*(L + TROFF) = (int) TR;
		*(L + XCOFF) = (int) XC;
		BL = L;
		BP = makeword (INT, (int) (PC + *PC + 1));
		++PC;
		L += ACTSIZE;
		D = L + ACTSIZE;
		goto CopyMode;
	*/

	CONT	DA D=BR, cloff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  ZA A=cl  OR  LBR  WR
	CONT	DA D=BR, bloff A=l  ADD  LVAR
	LDCT	cpnoop  D=TB  LBR  ADDR
	CJS	WFLT, wcache  ZA A=bl  OR  LBR  LOCK
	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA  WR
	CONT	DA D=BR, bpoff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  D=CSH  LBR  WR
	CONT	DA D=BR, goff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  ZA A=g  OR  LBR  WR
	CONT	DA D=BR, troff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  ZA A=tr  OR  LBR  WR
	CONT	DA D=BR, xcoff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  ZA A=xc  OR  LBR  WR
	CONT	ZA A=l  OR  RAMF B=bl

	CONT	ZA A=pc  OR  RAMF B=R1
	CJS	pctoword  DZ MASK  ADD CIN  RAMA A=ir0 B=R0
	CONT	AB A=R0  ADD  RAMF B=pc
	CONT	ZA A=pc  OR  CWR
	CONT	ZA A=R1  ADD CIN  RAMF B=pc
	CONT	DA D=BR,actsize A=l  ADD  RAMF B=l
	JUMP	copyFetch  DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	DA D=BR,actsize A=l  ADD  RAMF B=d
//--------

ENTRY	copymode + endor
ENTRY	matchmode + endor

	/*
		BP = *(L + BPOFF);
		BL = (int *) *(L + BLOFF):
		D = L + ACTSIZE;
		goto CopyMode;
	*/

	CONT	DA D=BR, bpoff A=l  ADD  LVAR
	LDCT	cpnoop  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA  RD
	CONT	DA D=BR, bloff A=l  ADD  LVAR
	LDCT	cpnoop  D=TB  LBR  ADDR
	CJS	RFLT, rcache  D=BUS  CWR  LOCK
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d  RD
	JUMP	copyFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	DZ D=BUS  OR  RAMF B=bl
//----------

ENTRY	copymode + callx
	/*
		R0 = *(CL + *PC++);
		deref (R0);
		metaproc ();
		checkglobal (R1 + 10);
		if (tag (M0) == PROC && tag (R0) == TERM)
		{
			IP = (int *) val (R0);
			while (R1--)
			{
				R0 = *++IP;
				*D++ = (tag(R0) == UNDEF) ?
					makeword (LINK, (int) IP) : R0;
			}
		}
		goto Call;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=R0 B=cl  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT 	ZA A=R0  OR  RAMF B=m0
	CONT	ZB  AND  RAMF B=R1
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CONT	NZ  DQ D=BR, atomtag SHL3  EXOR
	CJP	LC, callx2
	CONT	DZ D=BR, findfunctCode SHL1  OR  QREG	
	JUMP	cexit  ZB  AND  RAMF B=R2
	CONT	DQ D=BR, 01  OR  QREG
rst001:
	CONT	DA D=BR, tagmask SHL3 A=R2  AND  QREG
	CONT	Z  DQ D=BR, termintag SHL3  EXOR
	CJP	LC, callx3  
	CONT	DZ D=BR, findprocCode SHL1  OR  QREG	
	JUMP	cexit
	CONT	DQ D=BR, 2  OR  QREG
callx2:
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CONT	NZ  DQ D=BR, termtag SHL3  EXOR
	CJP	LC, callx3
rst033:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix033  RD
	CONT	DZ D=BR, findprocCode SHL1  OR  QREG	
	JUMP	cexit  DZ D=BUS  OR  RAMF B=R2
	CONT	DQ D=BR, 3  OR  QREG
rst003:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix003  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  QREG
	CONT	DQ D=BUS  AND  QREG
	CONT	DQ D=BR, funaroff  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix003  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  QREG
	CONT	DQ D=BUS  AND  RAMF B=R1	
rst002:
callx3:
	CONT	DA D=BR, tagmask SHL3 A=m0  AND  QREG
	CONT	NZ  DQ D=BR, termintag SHL3  EXOR
	CJP	LC, callx4
	CONT
	CONT	ZA A=R2  OR  RAMF B=m0
callx4:
	CONT	DA D=BR, tagmask SHL3 A=m0  AND  QREG
	CONT	NZ  DQ D=BR, termintag SHL3  EXOR
	CJP	LC, callx5
	CONT
	CONT	ZA A=R0  OR  RAMF B=m0
callx5:
	CJS	checkGlobal  ZA A=R0  OR  RAMF B=R2
	CONT	DA D=BR, 10 A=R1  ADD  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=m0  AND  RAMF B=R0
	CONT	NZ  DA D=BR, proctag SHL3 A=R0  EXOR
	CJP	LC, Call
	CONT	DA D=BR, tagmask SHL3 A=R2  AND  RAMF B=R0
	CONT	NZ  DA D=BR, termtag SHL3 A=R0  EXOR
	CJP	LC, Call
	CONT	DA D=BR, tagmask SHL3 A=R2  NOTRS  RAMF B=ip
callxloop:
rst029:
	CJP	Z, Call  ZA A=R1  OR
	CONT	ZA A=ip  ADD  CIN  LVAR
	LDCT	fix029  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, tagmask SHL3  OR  RAMF B=R2  RD
	CONT	ZB  SUBR  RAMF B=R1
	CONT	DA D=BUS A=R2  AND  RAMF B=R2
	CONT	NZ  DA D=BR, undeftag SHL3  A=R2  EXOR
	CJP	LC, callx1  DZ D=BUS  OR  RAMF B=R0
	CONT	ZB  ADD CIN  RAMF B=ip
	CONT	DA D=BR, linktag SHL3 A=ip  OR  RAMF B=R0
callx1:
rst030:
	CONT	ZA A=d  OR  LVAR
	CONT	ZB  ADD CIN  RAMF B=d  D=TB  LBR  ADDR
	CJP	NWFLT, callxloop  LOCK
	CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
	LDCT	fix030
	JUMP	callxloop
	CONT

fix029:
	JUMP	cfexit
	CONT	DZ D=BR, 29  OR  QREG

fix030:
	JUMP	cfexit  ZB  SUBR  RAMF B=d
	CONT	DZ D=BR, 30  OR  QREG

fix033:
	JUMP	cfexit
	CONT	DZ D=BR, 33  OR  QREG

fix003:
	JUMP	cfexit
	CONT	DZ D=BR, 3  OR  QREG
//----------

ENTRY	copymode + depart

	/*
		M0 = *(XC + CLAUSELEN + *PC++);
		if (BL >= CL)
		{
			PC++;
			*(L + XCOFF) = *(CL + XCOFF);
			*(L + CPOFF) = *(CL + CPOFF);
			*(L + CLOFF) = *(CL + CLOFF);
			CL = L;
			goto Arrive;
		}
		R0 = *PC++;
		IP = L + ACTSIZE;
		IQ = CL + ACTSIZE;
		while (R0--) *IQ++ = *IP++;
		L = CL;
		goto Arrive;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=m0
	CONT	DA D=BR, clauselen A=m0  ADD  RAMF B=m0
	CONT	AB A=m0 B=xc  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cbackup  DZ RTR1  OR  RAMA A=ir0 B=ir0  RD
	CJP	BW, depart1  AB A=bl B=cl  SUB CIN
	CONT	DZ D=BUS  OR  RAMF B=m0
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
rst024:
	CONT	DA D=BR, xcoff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix024  RD
	CONT	DA D=BR, xcoff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	D=BUS  LBR  WR
	CONT	DA D=BR, cpoff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix024  RD
	CONT	DA D=BR, cpoff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	D=BUS  LBR  WR
	CONT	DA D=BR, cloff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix024  RD
	CONT	DA D=BR, cloff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	D=BUS  LBR  WR
	JUMP	Arrive  ZA A=l  OR  RAMF B=cl
	CONT
depart1:
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=ip
	CONT	DA D=BR, actsize A=cl  ADD  RAMF B=iq
depart2:
rst025:
	CJP	Z, Arrive  ZA A=R0  OR
	CONT	ZA A=cl  OR  RAMF B=l
	CONT	ZB ADD CIN  RAMA A=ip B=ip  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix025  RD
	CONT	ZA A=iq  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	D=BUS  LBR  WR
	CJP	depart2  ZB  SUBR  RAMF B=R0
	CONT	ZB  ADD CIN  RAMF B=iq
	
fix024:
	JUMP	cfexit
	CONT	DZ D=BR,24  OR  QREG

fix025:
	JUMP	cfexit  ZB  SUBR  RAMF B=ip
	CONT	DZ D=BR, 25  OR  QREG
//----------

ENTRY	copymode + call

	/*
		M0 = *(XC + CLAUSELEN + *PC++);
	Call:	*(L + CPOFF) = (int) PC;
		*(L + XCOFF) = (int) XC;
		*(L + CLOFF) = (int) CL;
		CL = L;
		goto Arrive;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=xc  ADD  RAMF B=R0
	CONT	DA D=BR, clauselen A=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cbackup  DZ RTR1  OR  RAMA A=ir0 B=ir0  RD
	CONT
	CONT	DZ D=BUS  OR  RAMF B=m0
Call:

rst014:
	CJS	pctoword  ZA A=pc  OR  RAMF B=R1
	CONT
	CONT	DA D=BR, cpoff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix014  ZA A=pc  OR  LBR  WR
	CONT	DA D=BR, xcoff A=l  ADD  LVAR
	CONT	ZA A=R1  OR  RAMF B=pc  D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix014  ZA A=xc  OR  LBR  WR
	CONT	DA D=BR, cloff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix014  ZA A=cl  OR  LBR  WR
	JUMP	Arrive
	CONT	ZA A=l  OR  RAMF B=cl

fix014:
	JUMP	cfexit
	CONT	DZ D=BR, 14  OR  QREG
//----------

ENTRY	copymode + iexit

	/*
		if (!(BL >= CL))
		{
			L = CL;
			D = L + ACTSIZE;
		}
		goto Return;
	*/

	CJP	NBW, Return  AB A=bl B=cl  SUB CIN
	CONT
	JUMP	Return  ZA A=cl  OR  RAMF B=l
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d
//----------

ENTRY	copymode + ireturn
ENTRY	matchmode + ireturn

	/*
		claimclause ();
		if (BL >= CL) L += *PC;
		++PC;
		D = L + ACTSIZE;
Return:
		XC = (int *) val (*(CL + XCOFF));
		PC = (char *) ((int *) val (*(CL + CPOFF)));
		CL = (int *) val (*(CL + CLOFF));
		goto CopyMode;
	*/

	CJS	claimclause
	LDCT	cpnoop
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CJP	BW, ir1  AB A=bl B=cl  SUB CIN
	CONT	ZB  ADD CIN  RAMF B=pc
	CONT	AB A=R0  ADD  RAMF B=l
ir1:
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d
Return:
rst026:
	CONT	DA D=BR, xcoff A=cl  ADD  LVAR
	LDCT	fix026  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=R0  RD
	CONT	DA D=BR, cpoff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DA D=BUS A=R0  AND  RAMF B=xc  LOCK
	LDCT	fix026  RD
	CONT	DA D=BR, cloff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DA D=BUS A=R0  AND  RAMF B=pc  LOCK
	LDCT	fix026  RD
	CJS	pctobyte
	CONT
	CJS	fillIr0
	LDCT	fix026  DA D=BUS A=R0  AND  RAMF B=R0
	JUMP	copyFetch1  ZA A=R0  OR  RAMF B=cl
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR

fix026:
	JUMP	cfexit
	CONT	DZ D=BR, 26  OR  QREG
//----------

ENTRY	copymode + provar
ENTRY	matchmode + provar

	/*
		++T1;
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) != UNDEF)  goto FAIL;
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	AB  A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD  ZQ  OR  CWR
	CJS	dref  
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R0
	CONT	Z  DA D=BR, undeftag SHL3 A=R0  EXOR
	CJP	LC, copyFetch
	CJP	NLC, Fail
	CONT
//----------

ENTRY	copymode + prononvar
ENTRY	matchmode + prononvar

	/*
		++T1;
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) == UNDEF)  goto FAIL;
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	AB  A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD  ZQ  OR  CWR
	CJS	dref
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R0
	CONT	NZ  DA D=BR, undeftag SHL3 A=R0  EXOR
	CJP	LC, copyFetch
	CJP	NLC, Fail  
	CONT
//----------

ENTRY	copymode + proatom
ENTRY	matchmode + proatom

	/*
		++T1;
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) != ATOM)  goto FAIL;
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	AB  A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD  ZQ  OR  CWR
	CJS	dref
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R0
	CONT	Z  DA D=BR, atomtag SHL3 A=R0  EXOR
	CJP	LC, copyFetch
	CJP	NLC, Fail  
	CONT
//----------

ENTRY	copymode + proint
ENTRY	matchmode + proint

	/*
		++T1;
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) != INT)  goto FAIL;
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ D=CSH  OR  QREG
	CONT	AB  A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD  ZQ  OR  CWR
	CJS	dref
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R0
	CONT	Z  DA D=BR, inttag SHL3 A=R0  EXOR
	CJP	LC, copyFetch
	CJP	NLC, Fail  
	CONT
//----------

ENTRY	copymode + proaic
ENTRY	matchmode + proaic

	/*
		++T1;
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) == UNDEF || tag (R0) == TERM ||
			tag (R0) == CONS)  goto FAIL;
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	AB  A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD  ZQ  OR  CWR
	CJS	dref
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R0
	CONT	Z  DA D=BR, undeftag SHL3 A=R0  EXOR
	CJP	LC, Fail
	CONT	Z  DA D=BR, termtag SHL3 A=R0  EXOR
	CJP	LC, Fail
	CONT	Z  DA D=BR, constag SHL3 A=R0  EXOR
	CJP	LC, Fail
	CJP	NLC, copyFetch
	CONT
//----------

ENTRY	copymode + proarg
ENTRY	matchmode + proarg

	/*
		++T1;
		D = L + ACTSIZE;
		R0 = *D;
		deref (R0);
		if (tag (R0) != INT) goto Fail;
		R0 = signextend (R0);
		if (R0 <= 0) goto Fail;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d  LVAR
	CONT	DZ D=CSH  ADD CIN  QREG
	LDCT	cpnoop  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK  ZQ  OR  CWR
	CONT	DZ D=BR, tagmask SHL3  OR  RAMF B=R1  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	AB A=R0  AND  RAMF B=R1
	CONT	NZ  DA D=BR, inttag SHL3 A=R1  EXOR
	CJP	LC, Fail
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R0
	CJP	OS, Fail  ZA A=R0  OR
	CJP	Z, Fail  ZA A=R0  OR
	/*
		R1 = *(D + 1);
		deref (R1);
		if (tag(R1) == CONS)
		{
			if (R0 > 2) goto Fail;
			--R0;
		}
		else if ((tag (R1) != TERM) || (R0 > termarity(R1))) goto Fail;
		R1 = memoff(R1, R0);
		R0 = *(D + 2);
		if (unify()) goto CopyMode; else goto Fail;
	*/
	CONT	ZA A=d  ADD CIN  LVAR
	LDCT	cpnoop  ZA A=R0  OR  RAMF B=R1  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, tagmask SHL3  OR  RAMF B=R2  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	AB A=R0  AND  RAMF B=R2
	CONT	NZ  DA D=BR, constag SHL3 A=R2  EXOR
	CJP	LC, proarg1
	CONT	BW  DA D=BR, 2 A=R1  SUB CIN
	CJP	NLC, proarg2  ZB  SUBR  RAMF B=R1
	CJP	NLC, Fail
	CONT
proarg1:
	CONT	NZ  DA D=BR, termtag SHL3 A=R2  EXOR
	CJP	LC, Fail
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=R2
	CONT	DA D=BUS A=R2  AND  RAMF B=R2
	CONT	DA D=BR, funaroff A=R2  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=R2
	CONT	DA D=BUS A=R2  AND  RAMF B=R2
	CJP	BW, Fail  AB A=R2 B=R1  SUB CIN
proarg2:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R0
	CONT	AB A=R0 B=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	DA D=BR, 2 A=d  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R1  LOCK
	LDCT	cpnoop  RD
	JUMP	unify  ZB  AND  RAMF B=R2
	CONT	DZ D=BUS  OR  RAMF B=R0
//----------
	
ENTRY	copymode + profunctor
ENTRY	matchmode + profunctor

	/*
		++T1;
		D = L + ACTSIZE;
		R0 = *D;
		deref (R0);
		switch (tag (R0);
		{
		}
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK  DZ D=CSH  ADD CIN  QREG
	LDCT	cpnoop  RD  ZQ  OR  CWR
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	ZA A=d  ADD CIN  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	DA D=BR, 2 A=d  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R2  LOCK	
	LDCT	cpnoop  RD
	CONT	DA D=BR, tagmask SHL3  A=R0  AND  QREG
	CONT	DZ D=BUS  OR  RAMF B=R3
	CONT	Z  DQ D=BR, atomtag SHL3  EXOR
	CJP	LC, @pf1
	CONT	Z  DQ D=BR, inttag SHL3  EXOR
	CJP	LC, @pf1
	CONT	Z  DQ D=BR, constag SHL3  EXOR
	CJP	LC, @pf2
	CONT	Z  DQ D=BR, termtag SHL3  EXOR
	CJP	LC, @pf3
	CONT	Z  DQ D=BR, undeftag SHL3  EXOR
	CJP	LC, @pf4
	CJP	NLC, Fail
	CONT

@pf1:
	/*
	case ATOM:
	case INT:
		R1 = *(D + 1);
		if (!in_unatomic (R1, R0)) goto Fail;
		R1 = *(D + 2);
		if (!in_unatomic (R1, makeword (INT, 0))) goto Fail;
	break;
	*/

	CJS	in_unatomic  ZA A=R0  OR  RAMF B=R1
	LDCT	cpnoop  ZA A=R2  OR  RAMF B=R0
	CJS	in_unatomic  ZA A=R3  OR  RAMF B=R0
	CONT	DZ D=BR, inttag SHL3  OR  RAMF B=R1
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND
	
@pf2:
	/*
	case CONS:
		R1 = *(D + 1);
		if (!in_unatomic (R1, syswords[SWDOT])) goto Fail;
		R1 = *(D + 2);
		if (!in_unatomic (R1, makeword (INT, 2))) goto Fail;
	break;
	*/
			
	CONT	DZ D=BR, pswapbase + syswords  OR  ALDCA
	CONT	DZ D=BR, swdot  OR  RAMF B=R1
	CONT	DA D=CSH A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CJS	in_unatomic  ZA A=R2  OR  RAMF B=R0
	LDCT	cpnoop  DZ D=BUS  OR  RAMF B=R1
	CONT	DZ D=BR, 2  OR  RAMF B=R1
	CJS	in_unatomic  ZA A=R3  OR  RAMF B=R0
	CONT	DA D=BR, inttag SHL3 A=R1  ADD  RAMF B=R1
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND
	
@pf3:
	/*
	case TERM:
		R0 = val (termfunctor (R0));
		R1 = *(D + 1);
		if (!in_unatomic (R1, mem (R0 + FUNATOFF))) goto Fail;
		R1 = *(D + 2);
		if (!in_unatomic (R1, mem (R0 + FUNAROFF))) goto Fail;
	break;
	*/
	
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	ZA A=R2  OR  RAMF B=R0
	CONT	DZ D=BUS  OR  RAMF B=R2
	CONT	DA D=BR, tagmask SHL3 A=R2  NOTRS  RAMF B=R2
	CONT	DA D=BR, funatoff A=R2  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CJS	in_unatomic
	CONT	DZ D=BUS  OR  RAMF B=R1
	CONT	DA D=BR, funaroff A=R2  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CJS	in_unatomic  ZA A=R3  OR  RAMF B=R0
	CONT	DZ D=BUS  OR  RAMF B=R1
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

@pf4:
	/*
	case UNDEF:
		R0 = *(D + 1);
		deref (R0);
		R1 = *(D + 2);
		deref (R1);
		if (tag(R1) != INT) goto Fail;
		R1 = val (R1);
		if (R1 == 0)
		{
			R1 = *D;
			if (!in_unatomic (R1, R0) goto Fail;
		}
		else
		{
		}
	break;
	*/

	CJS	dref   ZA A=R3  OR  RAMF B=R0
	LDCT	cpnoop
	CJS	dref  ZA A=R0  OR  RAMF B=R1
	CONT	ZA A=R2  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R1  AND  QREG
	CONT	NZ  DQ D=BR, inttag SHL3  EXOR
	CJP	LC, Fail
	CONT	Z  DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=R1
	CJP	NLC, @pf41  ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CJS	in_unatomic  ZA A=R0  OR  RAMF B=R1
	CONT	DZ D=BUS  OR  RAMF B=R0	
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

@pf41:
	CJS	checkGlobal  ZA A=R0  OR  RAMF B=R2
	CONT	DA D=BR, 10 A=R1  ADD  RAMF B=R0
	CONT	DZ D=BR, pswapbase + syswords  OR  ALDCA
	CONT	DZ D=BR, swdot  OR  RAMF B=R0
	CONT	DA D=CSH A=R0  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	DZ D=BR, 2  OR  RAMF B=R0
	CJP	NZ, @pf42  DA D=BUS A=R2  EXOR
	CONT
	CJP	NZ, @pf42  AB A=R0 B=R1  EXOR
	CONT	DA D=BR, undeftag SHL3 A=g  OR  RAMF B=R3
	CONT	DA D=BR, constag SHL3  OR  RAMA A=g B=R0  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  ZA A=R3  OR  LBR  WR
	CONT	ZA A=g  ADD CIN  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	cpnoop  ZA A=R3  ADD CIN  LBR  WR
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	DA D=BR,2 A=g  ADD  RAMF B=g
	JUMP	unify  DZ D=BUS  OR  RAMF B=R1
	CONT	ZB  AND  RAMF B=R2
@pf42:
	CONT	ZA A=R2  OR  RAMF B=R0
	CONT	DZ D=BR, findfunctCode SHL1  OR  QREG	
	JUMP	cexit  ZB  AND  RAMU ONE B=R2
	CONT	DQ D=BR, 04  OR  QREG
rst004:
	CONT	ZA A=g  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix004  ZA A=R2  OR  LBR  WR
	CONT	DA D=BR, termtag SHL3 A=g  OR  RAMF B=R0
	CONT	ZB  ADD CIN  RAMF B=g
rst032:
@pf43:
	CJP	Z, @pf44  ZB  OR  RAMA A=g B=R1  LVAR
	CONT	DA D=BR, undeftag SHL3 A=g  OR  RAMF B=R2
	CONT	ZB  ADD CIN  RAMF B=g  D=TB  LBR  ADDR
	CJP	NWFLT, @pf43  ZB  SUBR  RAMF B=R1  LOCK
	CJS	NLC, wcache  ZA A=R2  OR  LBR  WR
	LDCT	fix032	ZB  SUBR  RAMF B=g
	JUMP	@pf43  ZB  ADD CIN  RAMF B=g
	CONT
@pf44:
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix032b  RD
	JUMP	unify  ZB  AND  RAMF B=R2
	CONT	DZ D=BUS  OR  RAMF B=R1	
	
fix004:
	JUMP	cfexit
	CONT	DZ D=BR, 04  OR  QREG
	
fix032:
	CONT	ZB  ADD CIN  RAMF B=R1
fix032b:
	JUMP	cfexit
	CONT	DZ D=BR, 32  OR  QREG
//----------

ENTRY	copymode + prosucc
ENTRY	matchmode + prosucc

	/*
		++T1;
		D = L + ACTSIZE;
		R0 = *D;
		deref (R0);
		if (tag (R0) == INT)
		{
			R1 = *(D + 1);
			if (!in_unatomic (R1,
				 makeword (INT, val (signextend (R0) + 1))))
				goto Fail;
		}
		else
		{
			R0 = *(D + 1);
			deref (R0);
			if (tag (R0) != INT) goto Fail;
			R1 = *D;
			if (!in_unatomic (R1,
				 makeword (INT, val (signextend (R0) - 1))))
				goto Fail;
		}
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK  DZ D=CSH  ADD CIN  QREG
	LDCT	cpnoop  RD  ZQ  OR  CWR
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	DZ D=BR, inttag SHL3  OR  RAMF B=R2
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R1
	CONT	NZ  AB A=R1 B=R2  EXOR
	CONT	LC  ZA A=d  ADD CIN  LVAR
	CJP	LC, prosucc1  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  ZA A=R0  ADD CIN  RAMF B=R1  RD
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=R1
	CONT	DZ D=BUS  OR  RAMF B=R0
rst019:
	CJS	in_unatomic  AB A=R2  OR  RAMF B=R1
	LDCT	fix019
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND
prosucc1:
	LDCT	cpnoop  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R1
	CJP	NZ, Fail  AB A=R1 B=R2  EXOR
	CONT	ZA A=d  OR  LVAR
	CONT	ZA A=R0  SUBR  RAMF B=R1  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	cpnoop  RD
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=R1
	CJS	in_unatomic  AB A=R2  OR  RAMF B=R1	
	LDCT	fix019  DZ D=BUS  OR  RAMF B=R0
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

fix019:
	JUMP	cfexit
	CONT	DZ D=BR, 19  OR  QREG
//----------
	
ENTRY	copymode + proequal
ENTRY	matchmode + proequal

	/*
		++T1;
		D = L + ACTSIZE;
		R0 = *D;
		R1 = *(D + 1);
		if (unify ()) goto CopyMode; else goto Fail;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK  DZ D=CSH  ADD CIN  QREG
	LDCT	cpnoop  RD  ZQ  OR  CWR
	CONT	ZA A=d  ADD CIN  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R0  LOCK
	LDCT	cpnoop  RD
	JUMP	unify  ZB  AND  RAMF B=R2
	CONT	DZ D=BUS  OR  RAMF  B=R1
//----------

ENTRY	copymode + eval
ENTRY	matchmode + eval

	/*
		R0 = *(CL + *PC++);
		deref(R0);
		IP = CL + *PC++;
		if (tag(R0) == INT)
		{
			*IP = R0;
			goto CopyMode;
		else
		{
			M0 = syswords[SWISPROC];
			*IP = R1 = makeword (UNDEF, (int) IP);
			*D++ = (tag (r1) == UNDEF) ?
				 makeword (LINK, (int) val(R1) : R1;
			*D++ = (tag (r0) == UNDEF) ?
				 makeword (LINK, (int) val(R0) : R0;
			goto Call;
		}
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CJS	dref  
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
	CONT	DZ MASK  OR  RAMA A=ir0 B=ip
	CONT	DZ  RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R2
	CONT	NZ  DA D=BR, inttag SHL3 A=R2  EXOR
	CJP	LC, eval3  AB A=cl  ADD  RAMF B=ip
rst018:
	CONT	ZA A=ip  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  LOCK
	CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
	LDCT	fix018
	JUMP	copyFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CJV	NZ  DA D=BR,3 A=pc  AND
	
eval3:
rst016:
	CONT	DZ D=BR, pswapbase + syswords  OR  ALDCA
	CONT	DZ D=BR, swisproc  OR  RAMF B=m0
	CONT	DA D=CSH A=m0  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix016  RD
	CONT	DA D=BR, undeftag SHL3  OR  RAMA A=ip B=R1  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  DZ D=BUS  OR  RAMF B=m0  LOCK
	CONT	ZA A=R1  OR  LBR  WR
	CONT	DA D=BR, linktag SHL3  OR  RAMA A=ip B=R1
	CONT	ZB  ADD CIN  RAMA A=d B=d  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix016a  ZA A=R1  OR  LBR  WR
rst017:
	CONT	NZ  DA D=BR, undeftag SHL3 A=R2  EXOR
	CJP	LC, eval2  ZB  ADD CIN  RAMA A=d B=d  LVAR
	CONT	D=TB  LBR  ADDR
	CONT	AB A=R2  NOTRS  RAMF B=R0  LOCK
	CONT	DA D=BR, linktag SHL3 A=R0  OR  RAMF B=R0  LOCK
eval2:
	CJP	NWFLT, Call  LOCK
	CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
	LDCT	fix017
	JUMP	Call
	CONT

fix018:
	JUMP	cfexit
	CONT	DZ D=BR,18  OR  QREG

fix016a:
	CONT	ZB  SUBR  RAMF B=d
fix016:
	JUMP	cfexit
	CONT	DZ D=BR,16  OR  QREG

fix017:
	JUMP	cfexit  ZB  SUBR  RAMF B=d
	CONT	DZ D=BR,17  OR  QREG
//----------

ENTRY	copymode + pushb
ENTRY	matchmode + pushb
 
	/*
		*++SP = *PC++ & 0xff;
		goto CopyMode;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0  INCCA
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	JUMP	copyFetch  ZB  ADD CIN  RAMF B=sp
	CONT	ZB  ADD CIN  RAMA A=R0 B=pc  CWR
//----------
 
ENTRY	copymode + pushi
ENTRY	matchmode + pushi

	/*
		R0 = *(XC + CLAUSELEN + *PC++);
		*++SP = signextend (R0);
		goto CopyMode;
	*/
		
  	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DA D=BR, clauselen A=R0  ADD  RAMF B=R0
	CONT	AB A=xc  ADD  RAMF B=R0  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CONT	ZB  ADD CIN  RAMF B=sp  ALDCA
 	CJP	ES, pushi1  DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3  A=R0  NOTRS  RAMF B=R0
	CONT	DA D=BR, extend SHL3  A=R0  OR  RAMF B=R0
pushi1:
	CJP	copyFetch1  ZA A=R0  OR  CWR
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + pushv
ENTRY	matchmode + pushv

	/*
		R0 = *(CL + *PC++);
		deref (R0);
		*++SP = signextend (R0);
		goto CopyMode;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	LDCT	cbackup  AB A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD
	CJS	dref  
	CONT	DZ D=BUS  OR  RAMF B=R0
	CJP	ES, pushv1  ZA A=R0  OR
	CONT	DA D=BR, tagmask SHL3  A=R0  NOTRS  RAMF B=R0
	CONT	DA D=BR, extend SHL3  A=R0  OR  RAMF B=R0
pushv1:
	JUMP	copyFetch  ZB  ADD CIN  RAMF B=sp  ALDCA
	CONT	ZA A=R0  OR  CWR
//----------

ENTRY	copymode + result

	/*
		++T1;
		R0 = *(CL + *PC++);
		deref (R0);
		if (tag (R0) == UNDEF)
		{
			in_trail (R0);
			memoff0(R0) = makeword (INT, val (*SP--));
		}
		else if (makeword (INT, val(*SP--)) != R0)
			goto Fail;
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	AB A=cl B=R0  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	cbackup  RD  ZQ  OR  CWR
	CJS	dref  ZA A=sp  OR  ALDCA
	LDCT	cbackup  DZ D=BUS  OR  RAMF B=R0
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=R1
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  RAMF B=R2
	CONT	Z  DA D=BR, undeftag SHL3 A=R2  EXOR	
	CJP	LC, result1  DA D=CSH A=R1  AND  RAMF B=R2
	CONT	DA D=BR, inttag SHL3 A=R2  OR  RAMF B=R2
	CJP	Z, copyFetch  AB A=R0 B=R2  EXOR
	CJP	NLC, Fail  ZB  SUBR  RAMF B=sp
	CONT
result1:
	CONT	AB A=R0 B=R1  AND  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=R2  OR  LBR  WR
rst012:
	CJS	in_trail
	LDCT	fix012	
	JUMP	copyFetch1  ZB  SUBR  RAMF B=sp
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR

fix012:
	JUMP	cfexit
	CONT	DZ D=BR, 12  OR  QREG
//----------

ENTRY	copymode + firresult

	/*
		++T1;
		*(CL + *PC++) = makeword (INT, val (*SP--));
		goto CopyMode;
	*/
	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DZ D=CSH  OR  RAMF  B=R1
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	ZQ  OR  CWR
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	AB A=cl B=R0  ADD  LVAR
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=R0
	CONT	DA D=BR, inttag SHL3 A=R0  OR  RAMF B=R0
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJP	NWFLT, copyFetch  LOCK
	CJS	NLC, wcache  ZB  SUBR  RAMA A=R0 B=sp  LBR  WR
	LDCT	cbackup  ZB  ADD CIN  RAMF B=sp
	JUMP	copyFetch1  ZB  SUBR  RAMF B=sp
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
//----------

ENTRY	copymode + isadd

	/*
		--SP;
		*SP += *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  OR  RAMF B=R0  DECCA
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	JUMP	copyFetch1  DA D=CSH A=R0  ADD  RAMF B=R0
	CONT	ZB  SUBR  RAMA A=R0  B=sp  CWR
//----------

ENTRY	copymode + issub


	/*
		--SP;
		*SP -= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  OR  RAMF B=R0  DECCA
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	JUMP	copyFetch1  DA D=CSH A=R0  SUB CIN  RAMF B=R0
	CONT	ZB  SUBR  RAMA A=R0  B=sp  CWR
//----------

ENTRY	copymode + ismul

	/*
		--SP;
		*SP *= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  OR  RAMF B=R0  DECCA
	CJS	multiply  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	DZ D=CSH  OR  QREG
	JUMP	copyFetch1  ZB  SUBR  RAMF  B=sp
	CONT	ZQ  OR  CWR
//----------

ENTRY	copymode + isdiv

	/*
		--SP;
		*SP /= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  OR  RAMF B=R0  DECCA
	CJP	Z, Fail  ZA A=R0  OR
	CONT	DZ D=CSH  OR  QREG

	CJP	S, @3	ZQ  OR
	CJS	tcdivcore	ZA A=R0  OR  RAMQU B=R1  TCDIVF

	LDCT, 14	ZB  AND  RAMF B=R1  TCDIV
	CJP	S, @2	DA CSH A=R0  ADD  RAMF B=R1
	CJP	@4
	CONT
@1:
	CJP	@4
@2:
	CONT	ZQ  ADD  CIN  QREG

@3:
	LDCT, 14	AB A=R1  SUBR  RAMF B=R1  TCDIV
	CONT	DA CSH A=R0  ADD  RAMF B=R1
	CJP	S, @1	ZB  SUB CIN  B=R1
	CJP	Z, @2	AB  A=R0 B=R1  SUBR CIN
	CJP	@4
	CONT

@4:
	JUMP	copyFetch  ZB  SUBR  RAMF B=sp
	CONT	ZQ  OR  CWR
//----------

ENTRY	copymode + ismod

	/*
		--SP;
		*SP %= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  OR  RAMF B=R0  DECCA
	CJP	Z, Fail  ZA A=R0  OR
	CONT
	CJP	S, @7	DZ D=CSH  OR  QREG
	CJS	tcdivcore	ZA A=R0  OR  RAMQU B=R1  TCDIVF
	LDCT, 14	ZB  AND  RAMF B=R1 TCDIV
	CJP	S, @6	DA CSH A=R0  ADD  RAMF B=R1
	CONT	ZB  SUBR  RAMF B=sp
	JUMP	copyFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	ZA A=R1  OR  CWR

@5:
	CONT	ZB  SUBR  RAMF B=sp
@6:	
	JUMP	copyFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	AB A=R0 B=R1  SUBR CIN  CWR

@7:
	LDCT, 14	AB A=R1  SUBR  RAMF B=R1  TCDIV
	CONT	DA CSH A=R0  ADD  RAMF B=R1
	CJP	Z, @5	AB A=R0 B=R1  SUBR CIN
	CJP	S, @6	ZB  SUB CIN  B=R1

	CONT	ZB  SUBR  RAMF B=sp
	JUMP	copyFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	ZA A=R1  OR  CWR
//----------

ENTRY	copymode + isshr

	/*
		--SP;
		*SP >>= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  SUBR CIN  RAMF B=R1  DECCA
	CJP	NS, @abort  ZA A=R1  OR
	PUSH, 31  ZB  SUBR  RAMF B=sp
	CONT	DZ D=CSH  OR  RAMF B=R0

		TWB	Z, @shr1  ZA A=R1  ADD CIN  RAMF B=R1
		CONT	ZA A=R0  OR  RAMD ARI B=R0
@shr1:
	JUMP	copyFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	ZA A=R0  CWR
//----------

ENTRY	copymode + isshl

	/*
		--SP;
		*SP <<= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  SUBR CIN  RAMF B=R1  DECCA
	CJP	NS, @abort  ZA A=R1  OR
	PUSH, 31  ZB  SUBR  RAMF B=sp
	CONT	DZ D=CSH  OR  RAMF B=R0

		TWB	Z, @shl1  ZA A=R1  ADD CIN  RAMF B=R1
		CONT	ZA A=R0  OR  RAMU ZERO B=R0
@shl1:
	JUMP	copyFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	CONT	ZA A=R0  CWR

@abort:
	JUMP	copyFetch
	LOOP	T
//----------

ENTRY	copymode + isand

	/*
		--SP;
		*SP &= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  OR  RAMF B=R0  DECCA
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	JUMP	copyFetch1  DA D=CSH A=R0  AND  RAMF B=R0
	CONT	ZB  SUBR  RAMA A=R0 B=sp  CWR
//----------

ENTRY	copymode + isor

	/*
		--SP;
		*SP |= *(SP+1);
		goto CopyMode;
	*/

	CONT	DZ D=CSH  OR  RAMF B=R0  DECCA
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
	JUMP	copyFetch1  DA D=CSH A=R0  OR  RAMF B=R0
	CONT	ZB  SUBR  RAMA A=R0 B=sp  CWR
//----------

ENTRY	copymode + isnot

	/*
		*SP = ~(*SP);
		goto CopyMode;
	*/

	JUMP	copyFetch  DZ D=CSH  EXNOR  RAMF B=R0
	CONT	ZA A=R0  CWR
//----------

ENTRY	copymode + isneg

	/*
		*SP = -(*SP);
		goto CopyMode;
	*/

	JUMP	copyFetch  DZ D=CSH  SUBR CIN  RAMF B=R0
	CONT	ZA A=R0  CWR
//----------

ENTRY	copymode + iseq

	/*
		++T1;
		if (*(SP - 1) != *SP) goto fail;
		SP -= 2;
		goto CopyMode;
	*/
	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	ZQ  OR  CWR
	CONT	ZA A=sp  OR  ALDCA
	CONT	DECCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CJP	Z, copyFetch DA D=CSH A=R0 EXOR
	CONT	DA D=BR, 2  A=sp  SUBR CIN  RAMF B=sp

	JUMP	Fail
	CONT	DA D=BR,2 A=sp  ADD RAMF B=sp
//----------

ENTRY	copymode + isne

	/*
		++T1;
		if (*(SP - 1) == *SP) goto fail;
		SP -= 2;
		goto CopyMode;
	*/
	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	ZQ  OR  CWR
	CONT	ZA A=sp  OR  ALDCA
	CONT	DECCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CJP	NZ, copyFetch DA D=CSH A=R0 EXOR
	CONT	DA D=BR, 2  A=sp  SUBR CIN  RAMF B=sp

	JUMP	Fail
	CONT	DA D=BR,2 A=sp  ADD RAMF B=sp
//----------

ENTRY	copymode + islt

	/*
		++T1;
		if (*(SP - 1) => *SP) goto fail;
		SP -= 2;
		goto CopyMode;
	*/
	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	ZQ  OR  CWR
	CONT	ZA A=sp  OR  ALDCA
	CONT	DECCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CJP	NCS, copyFetch DA D=CSH A=R0  SUBR
	CONT	DA D=BR, 2  A=sp  SUBR CIN  RAMF B=sp

	JUMP	Fail
	CONT	DA D=BR,2 A=sp  ADD RAMF B=sp
//----------

ENTRY	copymode + isle

	/*
		++T1;
		if (*(SP - 1) > *SP) goto fail;
		SP -= 2;
		goto CopyMode;
	*/

	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	ZQ  OR  CWR
	CONT	ZA A=sp  OR  ALDCA
	CONT	DECCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CJP	NCS, copyFetch DA D=CSH A=R0  SUBR CIN
	CONT	DA D=BR, 2  A=sp  SUBR CIN  RAMF B=sp

	JUMP	Fail
	CONT	DA D=BR,2 A=sp  ADD RAMF B=sp
//----------

ENTRY	copymode + isgt

	/*
		++T1;
		if (*(SP - 1) <= *SP) goto fail;
		SP -= 2;
		goto CopyMode;
	*/
	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	ZQ  OR  QREG
	CONT	ZA A=sp  OR  ALDCA
	CONT	DECCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CJP	NCS, copyFetch DA D=CSH A=R0  SUB
	CONT	DA D=BR, 2  A=sp  SUBR CIN  RAMF B=sp

	JUMP	Fail
	CONT	DA D=BR,2 A=sp  ADD RAMF B=sp
//----------

ENTRY	copymode + isge

	/*
		++T1;
		if (*(SP - 1) < *SP) goto fail;
		SP -= 2;
		goto CopyMode;
	*/
	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	ZQ  OR  CWR
	CONT	ZA A=sp  OR  ALDCA
	CONT	DECCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CJP	NCS, copyFetch DA D=CSH A=R0  SUB CIN
	CONT	DA D=BR, 2  A=sp  SUBR CIN  RAMF B=sp

	JUMP	Fail
	CONT	DA D=BR,2 A=sp  ADD RAMF B=sp
//----------
