/*
	xpinterp.m
	
	Copyright (c) 1986, 1987 by High Level Hardware
*/

*I opcodes.m
*I proregs.m
*I proops.m
*I proconsts.m

GLOBAL	Arrive, Fail
GLOBAL	rst040, rst041, rst044, rst045
GLOBAL	rst050, rst051, rst052, rst000, rst054, rst055, rst056, rst057
GLOBAL	rst060, rst061, rst062

EXTERNAL cexit, cfexit, copyFetch, fillIr0, matchFetch1
EXTERNAL dref, processorTrap, pctobyte, checkLocal, untrail
EXTERNAL rcache, wcache, rwcache

/*
	perform nextmatch(), updating the match register M0 to point
	to the next clause
	R2 contains a value to load into the IR.  Return is performed
	by a CJV.  LDIR to return 'TRUE' and ALDIR to return 'FALSE'.
*/

nextmatch:
	/*
		if (tag (M0) == TERMIN) return FALSE;
		R1 = memoff (M0, CLAKEYOFF);
		if (tag (R1) == UNDEF) return TRUE;
		R0 = *(CL + A1OFF);
		deref (R0);
		if (tag(R0) == UNDEF) return TRUE;
		if (tag(R0) == TERM) R0 = termfunctor (R0);
	*/

rst060:
	CONT	DA D=BR, tagmask SHL3  A=m0  AND  RAMF B=R1
	CONT	Z  DA D=BR, termintag SHL3 A=R1  EXOR
	CJP	LC, falsexit
	CONT	DA D=BR, tagmask SHL3 A=m0  NOTRS  RAMF B=R1
	CONT	DA D=BR, clakeyoff A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix060  RD
	CONT	DZ D=BR, tagmask SHL3  OR  RAMF B=R1
	CONT	DA D=BUS A=R1  AND  RAMF  B=R1
	CONT	Z  DA D=BR, undeftag SHL3 A=R1  EXOR
	CJP	LC, truexit  DZ D=BUS  OR  RAMF B=R1
	CONT	DA D=BR, a1off A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT    fix060  RD
	CJS	dref
	LDCT	fix060  DZ D=BUS  OR  RAMF  B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CONT	Z  DQ D=BR, undeftag SHL3  EXOR
	CJP	LC, truexit
	CONT	NZ  DQ D=BR, termtag SHL3  EXOR
	CJP	LC, next
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR	
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix060  RD
	CONT
	CONT	DZ D=BUS  OR  RAMF  B=R0	
next:
	/*
		switch (tag(R1))
		{
		case FUNCTOR:
		case ATOM:
		case INT:
		case CLAUSE:
			if (R0 == R1)  return TRUE;
		break;

		case CONS:
		case BOX:
			if (tag (R0) == tag (R1)) return TRUE;
		break;
	
		default:
			processortrap (2);
		}

		M0 = memoff (M0, CLAFOROFF);
		if (tag (M0) == TERMIN) return FALSE;
		R1 = memoff (M0, CLAKEYOFF);
		if (tag (R1) == UNDEF) return TRUE;
		goto next;

	*/

	CONT	DA D=BR, tagmask SHL3 A=R1  AND  QREG
	CONT	Z  DQ D=BR, functortag SHL3  EXOR
	CJP	LC, @2
	CONT	Z  DQ D=BR, atomtag SHL3  EXOR
	CJP	LC, @2
	CONT	Z  DQ D=BR, inttag SHL3  EXOR
	CJP	LC, @2
	CONT	Z  DQ D=BR, clausetag SHL3  EXOR
	CJP	LC, @2
	CONT	Z  DQ D=BR, constag SHL3  EXOR
	CJP	LC, @4
	CONT	Z  DQ D=BR, boxtag SHL3  EXOR
	CJP	LC, @4
	CJP	NLC  processorTrap
	CONT	DZ D=BR, 2  OR  RAMF B=R0

@2:	CJP	Z, truexit  AB A=R0 B=R1  EXOR
	CJP	NLC, @endsw
	CONT

@4:	CONT	AQ A=R0  EXOR  QREG
	CONT	Z  DQ D=BR, tagmask SHL3  AND
	CJP	LC, truexit
	CONT

@endsw:
rst061:
	CONT	DA D=BR, tagmask SHL3  A=m0  NOTRS  RAMF B=R1
	CONT	DA D=BR, claforoff A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix061  RD
	CONT	DZ D=BR, tagmask SHL3  OR  QREG
	CONT	DQ D=BUS  AND  RAMF  B=m0
	CONT	Z  DA D=BR, termintag SHL3  A=m0  EXOR
	CJP	LC, falsexit  DZ D=BUS  OR  RAMF B=m0
rst062:
	CONT	DA D=BR, tagmask SHL3 A=m0  NOTRS  RAMF  B=R1
	CONT	DA D=BR, clakeyoff A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix062  RD
	CONT	DZ D=BR, tagmask SHL3  OR  QREG
	CONT	DQ D=BUS  AND  RAMF  B=R1
	CONT	Z  DA D=BR, undeftag SHL3 A=R1  EXOR
	CJP	NLC, next  DZ D=BUS  OR  RAMF B=R1
truexit:
	CONT	ZA A=R2  OR  LDIR
	CJV
	CONT

falsexit:
	CONT	ZA A=R2  OR  ALDIR
	CJV
	CONT

fix060:
	JUMP	cfexit
	CONT	DZ D=BR, 60  OR  QREG
fix061:
	JUMP	cfexit
	CONT	DZ D=BR, 61  OR  QREG
fix062:
	JUMP	cfexit
	CONT	DZ D=BR, 62  OR  QREG
//----------

Arrive:
	/*
		++T1;
		if (tag (M0) != PROC)
		{
			if (unknown ())
				goto Arrive;
			else
				goto Fail;
		}
	*/
	CONT	DZ D=BR, pswapbase + t1  OR  ALDCA
	CONT	DA D=BR, tagmask SHL3 A=m0  AND  RAMF B=R0
	CONT	DZ D=CSH  ADD CIN  QREG
	CONT	Z  DA D=BR, proctag SHL3 A=R0  EXOR
	CJP	LC, arrive1  ZQ  OR  CWR
unknown:
rst050:
	CONT	DA D=BR, tagmask SHL3 A=m0  AND  RAMF B=R1
	CONT	Z  DA D=BR, atomtag SHL3 A=R1  EXOR
	CJP	LC, arrive2  ZA A=m0  OR  RAMF B=R0
	CONT	Z  DA D=BR, proctag SHL3 A=R1  EXOR
	CJP	NLC, arrive3  ZA A=m0  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=m0  NOTRS  RAMF B=R1
	CONT	DA D=BR, profunoff A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix050  RD
	CONT
	CONT	DZ D=BUS  OR  RAMF B=R0
arrive3:
	CONT	DZ D=BR, pswapbase + syswords  OR  ALDCA
	CONT	DZ D=BR, swdatabase  OR  RAMF B=R1
	CONT	DA D=CSH A=R1  ADD  LVAR	
	LDCT	fix050  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, swsource  OR  RAMF B=R1  RD
	CONT	DA D=CSH A=R1  ADD LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R1  LOCK
	CONT	RD
	CJP	Z, Fail  AB A=R0 B=R1  EXOR
	CONT	DA D=BR,tagmask SHL3  A=R0  NOTRS  RAMF B=R1
	CJP	Z, Fail  DA D=BUS A=R0  EXOR
	CONT	DA D=BR, funatoff  A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	RD
	CONT
	CONT	DZ D=BUS  OR  RAMF B=R0
arrive2:
rst051:
	CONT	DA D=BR, a1off A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix051  ZA A=R0  OR  LBR  WR
	CONT	DZ D=BR, pswapbase + syswords  ADD  ALDCA
	CONT	DZ D=BR, swunknown  OR  RAMF B=R1
	CONT	DA D=CSH A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix051  RD
	JUMP	Arrive
	CONT	DZ D=BUS  OR  RAMF B=m0

fix050:
	JUMP	cfexit
	CONT	DZ D=BR, 50  OR  QREG
fix051:
	JUMP	cfexit
	CONT	DZ D=BR, 51  OR  QREG

arrive1:
	/*
		R0 = memoff(M0, PROCLAOFF);
		if (tag (R0) == INT)
		{
			if (primhandle (val (R0)))
			{
				PC = (char *) ((int *) val (*(CL + CPOFF)));
				XC = (int *) val (*(CL + XCOFF));
				CL = (int *) val (*(CL + CLOFF));
				D = L + ACTSIZE;
				goto Copymode;
			}
			else goto Fail;
		}
	*/
rst052:
	CONT	DA D=BR, tagmask SHL3 A=m0  NOTRS  RAMF B=R1
	CONT	DA D=BR, proclaoff A=R1  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix052  RD
	CONT	DZ D=BR, tagmask SHL3  OR  RAMF B=R0
	LDCT	cexit  DA D=BUS A=R0  AND  RAMF B=R0
	CONT	NZ  DA D=BR, inttag SHL3 A=R0  EXOR
	CJP	LC, arrive4  DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R0
	JRP	F  DZ D=BR, primhandleCode SHL1  OR  QREG
	CONT	DQ D=BR, 00  OR  QREG
rst000:
	CJP	Z, Fail  ZA A=R0  OR
	CONT	DA D=BR, cpoff A=cl  ADD  LVAR
	LDCT	fix000  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=R1  RD
	CONT	DA D=BR, xcoff A=cl  ADD  LVAR
	CJS	pctobyte  DA D=BUS A=R1  AND  RAMF B=pc
	CONT
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix000  RD
	CJS	fillIr0		//>>> clobbers R1
	CONT	DA D=BUS A=R1  AND  RAMF B=xc
	CONT	DA D=BR, cloff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix000  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=R1
	CONT	DA D=BUS A=R1  AND  RAMF B=cl
	JUMP	copyFetch
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d
	
fix052:
	JUMP	cfexit
	CONT	DZ D=BR, 52  OR  QREG
	
fix000:
	JUMP	cfexit
	CONT	DZ D=BR, 00  OR  QREG
		
arrive4:
rst054:
	/*
		R0 = memoff (R0, FIXFIROFF);
		if (tag (R0) == TERMIN)
		{
			if (unknown ()) goto Arrive; else goto Fail;
		}
		M0 = R0;
		if (!nextmatch ()) goto Fail;
	*/
	CONT	DA D=BR, fixfiroff A=R0  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix054  RD
	CONT	DZ D=BR, tagmask SHL3  OR  RAMF B=R0
	CONT	DA D=BUS A=R0  AND  RAMF B=R0
	CONT	Z  DA D=BR, termintag SHL3 A=R0  EXOR
	CJP	LC, unknown  DZ D=BUS  OR  RAMF B=R0
	CONT
	JUMP	nextmatch  ZA A=R0  OR  RAMF B=m0
	CONT	DZ D=BR, next0  OR  RAMF B=R2
ENTRY	nexttrue + next0
	/*
		M1 = M0;
		XC = (int *) val (M0);
		checklocal (10 + (*(XC + CLAFLAOFF) & CFSIZE));
		M0 = *(XC + CLAFOROFF);
	*/
	CONT	DZ D=BR, pswapbase + m1  OR  ALDCA
	CONT	ZA A=m0  OR  CWR
	CONT	DA D=BR, tagmask SHL3 A=m0  NOTRS  RAMF B=xc
rst055:
	CONT	DA D=BR, claflaoff A=xc  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix055  RD
	CONT	DZ D=BR, cfsize  OR  QREG
	CJS	checkLocal  DQ D=BUS  AND  RAMF B=R0
	CONT	DA D=BR, 10 A=R0  ADD RAMF B=R0
	CONT	DA D=BR, claforoff A=xc  ADD  LVAR
	LDCT	fix055  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, next1  OR  RAMF B=R2  RD
	JUMP	nextmatch
	CONT	DZ D=BUS  OR  RAMF B=m0
ENTRY	nexttrue + next1
	/*
		*(CL + BPOFF) = BP;
		*(CL + BLOFF) = (int) BL;
		*(CL + TROFF) = (int) TR;
		*(CL + GOFF) = (int) G;
		BP = M0;
		BL = CL;
	*/

rst056:
	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA
	CONT	DA D=BR, bpoff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix056  D=CSH  LBR  WR
	CONT	DA D=BR, bloff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix056  ZA A=bl  OR  LBR  WR
	CONT	DA D=BR, troff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix056  ZA A=tr  OR  LBR  WR
	CONT	DA D=BR, goff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix056  ZA A=g  OR  LBR  WR
	CONT	ZA A=m0  OR  CWR
	CONT	ZA A=cl  OR  RAMF B=bl
ENTRY	nextfalse + next1
Setup:
	/*
		PC = (char *) ((int *) val (*(xc + clatexoff)) + 1);
		D = L + ACTSIZE;
		SP = pad;
		goto MatchMode;
	*/
rst057:
	CONT	DA D=BR, clatexoff A=xc  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix057  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  QREG
	CJS	pctobyte  DQ D=BUS  AND  RAMF B=pc
	CONT	ZB  ADD CIN  RAMF B=pc
	CJS	fillIr0
	CONT
/*
	CONT	DZ D=BR, pswapbase + pad  OR  ALDCA
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d
	JUMP	matchFetch1  DZ D=CSH  OR  RAMF B=sp
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
*/
	CONT	DZ D=BR, pswapbase + padarray  OR  RAMF B=sp
	JUMP	matchFetch1  DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
	CONT	DA D=BR, actsize A=l  ADD  RAMF B=d

fix054:
	JUMP	cfexit
	CONT	DZ D=BR, 54  OR  QREG
fix055:
	JUMP	cfexit
	CONT	DZ D=BR, 55  OR  QREG
fix056:
	JUMP	cfexit
	CONT	DZ D=BR, 56  OR  QREG
fix057:
	JUMP	cfexit
	CONT	DZ D=BR, 57  OR  QREG
//----------

ENTRY	copymode + ifail
ENTRY	matchmode + ifail
ENTRY	nextfalse + next0

Fail:
	/*
		G = (int *) *(BL + GOFF);
		TR1 = (int *) *(BL + TROFF);
		if (BL < L)
		{
			L = BL;
			if (tag (BP) == CLAUSE) CL = L;
			else
			{
				CL = (int *) *(L + CLOFF);
				XC = (int *) *(L + XCOFF);
				PC = (char *) ((int *) val (BP));
				untrail ();
				goto CopyMode;
			}
		}
	*/

rst040:
	CONT	DA D=BR, goff A=bl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix040  RD
	CONT	DA D=BR, troff A=bl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=g  LOCK
	LDCT	fix040  RD
	CJP	NBW, fail1  AB A=bl B=l  SUB CIN
	CONT	DZ D=BUS  OR  RAMF B=R2  // >>> tr1

	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA
	CONT	ZA A=bl  OR  RAMF B=l
	CONT	DZ D=BR, tagmask SHL3  OR  QREG
	CONT	DQ D=CSH  AND  RAMF B=R0
	CONT	Z  DA D=BR, clausetag SHL3 A=R0  EXOR
	CJP	LC, fail1  ZA A=l  OR  RAMF B=cl
rst041:
	CONT	DA D=BR, cloff A=l  ADD  LVAR
	LDCT	fix041  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
// May lose ALDCA through a fault
	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA  RD
	CONT	DA D=BR, xcoff A=l  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=cl  LOCK
	LDCT	fix041  DZ D=CSH  OR  RAMF B=R0  RD
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=pc
	CJS	pctobyte
	CONT
	CJS	fillIr0
	CONT	DZ D=BUS  OR  RAMF B=xc
	JUMP	untrail  ZA A=R2  OR  RAMF B=R1
	CONT	DZ D=BR, untr0  OR  RAMF B=R2
// untr0 is at copyFetch

fail1:
	/*
		M1 = BP;
		XC = (int *) val (BP);
		checklocal (10 + (*(XC + CLAFLAOFF) & CFSIZE));
		M0 = *(XC + CLAFOROFF);
		untrail ();
	*/

	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA
	CONT	DZ D=BR, pswapbase + m1  OR  ALDCA
	CONT	DZ D=CSH  OR  RAMF B=R0  CWR
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=xc
rst044:
	CONT	DA D=BR, claflaoff A=xc  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix044  RD
	CONT	DZ D=BR, cfsize  OR  QREG
	CJS	checkLocal  DQ D=BUS  AND  RAMF B=R0
	CONT	DA D=BR, 10 A=R0  ADD RAMF B=R0
	CONT	DA D=BR, claforoff A=xc  ADD  LVAR
	LDCT	fix044  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	RD
	CONT	ZA A=R2  OR  RAMF B=R1
	JUMP	untrail  DZ D=BUS  OR  RAMF B=m0
	CONT	DZ D=BR, untr1  OR  RAMF B=R2
ENTRY	copymode + untr1
	JUMP	nextmatch
	CONT	DZ D=BR, next2  OR  RAMF B=R2
ENTRY	nexttrue + next2
	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA
	JUMP	Setup  ZA A=m0  OR  CWR
	CONT
ENTRY	nextfalse + next2
rst045:
	CONT	DA D=BR, bpoff A=cl  ADD  LVAR
	LDCT	fix045  D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	DZ D=BR, pswapbase + bp  OR  ALDCA  RD
	CONT	DA D=BR, bloff A=cl  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  D=BUS  CWR  LOCK
	LDCT	fix045  RD
	JUMP	Setup
	CONT	DZ D=BUS  OR  RAMF B=bl

fix040:
	CJP	cfexit
	CONT	DZ D=BR, 40  OR  QREG

fix041:
	CJP	cfexit
	CONT	DZ D=BR, 41  OR  QREG
	
fix044:
	CJP	cfexit
	CONT	DZ D=BR, 44  OR  QREG
	
fix045:
	CJP	cfexit
	CONT	DZ D=BR, 45  OR  QREG
//----------
