/*  CHECK.C:  Routines for comparing, unifying, dereferencing */


#include "zip.h"

extern int *G;  /* used by compare to note start of workspace */
extern int syswords[];

#ifdef HLHMODS
int unifytable[256] =
#else
char unifytable[256] =
#endif
{

/* INT     */ 6,7,7,7,7,7,0,3,0,0,0,0,7,0,7,7,
/* FLOAT   */ 7,5,7,7,7,7,0,3,0,0,0,0,7,0,7,7,
/* ATOM    */ 7,7,6,7,7,7,0,3,0,0,0,0,7,0,7,7,
/* BOX     */ 7,7,7,5,7,7,0,3,0,0,0,0,7,0,7,7,
/* TERM    */ 7,7,7,7,4,8,0,3,0,0,0,0,7,0,7,7,
/* CONS    */ 7,7,7,7,8,9,0,3,0,0,0,0,7,0,7,7,
/* LINK    */ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
/* UNDEF   */ 2,2,2,2,2,2,0,1,0,0,0,0,2,0,2,2,
/* FUNCTOR */ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
/* BLOCK   */ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
/* EMPTY   */ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
/* TERMIN  */ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
/* PROC    */ 7,7,7,7,7,7,0,3,0,0,0,0,7,0,7,7,
/* TABLE   */ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
/* TABREF  */ 7,7,7,7,7,7,0,3,0,0,0,0,7,7,10,7,
/* CLAUSE  */ 7,7,7,7,7,7,0,3,0,0,0,0,7,0,7,7
};

static cmpcode[16] =
{
  -2, -1, 0, -1, 0, 2, 0, -4, 0, 0, 0, 0, 0, 0, 0, -3
};

/* Move n consecutive memory locations from a to b */
/* The macro version (macblkmov) destroys its arguments */

blkmov(n,a,b)
register int n, *a, *b;
{
  macblkmov(n,a,b);
}


/*
  Compare two boxes addressed by a and b.
  Check a word at a time, starting with the count field.
*/

int boxcmp(a,b)
int a,b;
{
  register int n, *pa, *pb;
  pa = (int *) a;
  pb = (int *) b;
  n = blocksize(val(mem(a)));
  while (n--) if (*pa++ != *pb++) return(FALSE);
  return(TRUE);
}


/* signed comparison of boxes for compare(_,_) */

static int compbox(a,b)
int a,b;
{
  register int n, d;
  register char *pa, *pb;
  int la, lb;
  la = blockchars(a);
  lb = blockchars(b);
  n = (la < lb) ? la : lb;
  pa = (char *) (((int *) val(a)) + 1);
  pb = (char *) (((int *) val(b)) + 1);
  while (n--) if (d = *pa++ - *pb++) return(d);
  return(la - lb);
}


/*
  General Purpose Comparison of two terms U0, U1.
  Note the use of 'continue', which returns control back to the main loop.
*/

int compare(U0,U1)
register int U0,U1;
{
  int a,b,c,d0,d1, *bot, *p;
  c = 1;
  p = bot = G;
  while (TRUE)
  {
    deref(U0);
    deref(U1);
    d0 = (tag(U0) == TERM) ? (termarity(U0)) : cmpcode[tagint(U0)];
    d1 = (tag(U1) == TERM) ? (termarity(U1)) : cmpcode[tagint(U1)];
    if (d0 - d1) return(d0-d1);
    switch (unifytable[tagcode(U0,U1)])
    {
      case 0:
        processortrap(141);
      case 1:
      case 7:
        if (d0 = (val(U0) - val(U1))) return(d0);
        break;
      case 9:
        if (c > 1)
        {
          *++p = a;
          *++p = b;
          *++p = c;
        }
        a = val(U0);
        b = val(U1);
        c = 2;
        U0 = mem(a);
        U1 = mem(b);
        continue;
      case 8:
        U0 = (tag(U0) == CONS) ? atomname(syswords[SWDOT]) : atomname(funcatom(termfunctor(U0)));
        U1 = (tag(U1) == CONS) ? atomname(syswords[SWDOT]) : atomname(funcatom(termfunctor(U1)));
        if (d0 = compbox(U0,U1)) return(d0);
        break;
      case 4:
        if (termfunctor(U0) == termfunctor(U1))
        {
          if (c > 1)
          {
            *++p = a;
            *++p = b;
            *++p = c;
          }
          a = adroff(val(U0),1);
          b = adroff(val(U1),1);
          c = termarity(U0);
          U0 = mem(a);
          U1 = mem(b);
          continue;
        }
        else
        {
          U0 = atomname(funcatom(termfunctor(U0)));
          U1 = atomname(funcatom(termfunctor(U1)));
          if (d0 = compbox(U0,U1)) return(d0);
        }
        break;
      case 6:
        if (tag(U0) == INT)
        {
          U0 = signextend(U0);
          U1 = signextend(U1);
          if (d0 = (U0 - U1)) return(d0);
          break;
        }
        U0 = atomname(U0);
        U1 = atomname(U1);
        /* drop through */
      case 5:
        if (d0 = compbox(U0,U1)) return(d0);
        break;
    }
    if (--c == 0)
    {
      if (p == bot) return(0);
      c = (*p--) - 1;
      b = *p--;
      a = *p--;
    }
    a = adroff(a,1);
    b = adroff(b,1);
    U0 = mem(a);
    U1 = mem(b);
  }
}

